/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application.replication;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.exoplatform.commons.serialization.SerializationContext;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.portal.application.replication.SerializationContextSingleton;
import org.exoplatform.webui.core.UIApplication;

public class ApplicationState
implements Serializable {
    private UIApplication application;
    private byte[] serialization;
    private String userName;

    public ApplicationState(UIApplication application, String userName) {
        if (application == null) {
            throw new NullPointerException();
        }
        this.application = application;
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public UIApplication getApplication() throws IOException, ClassNotFoundException {
        if (this.serialization != null) {
            SerializationContext serializationContext = SerializationContextSingleton.getInstance();
            byte[] bytes = this.serialization;
            this.serialization = null;
            this.application = (UIApplication)serializationContext.read(bytes);
        }
        return this.application;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.userName != null) {
            oos.writeBoolean(true);
            oos.writeUTF(this.userName);
        } else {
            oos.writeBoolean(false);
        }
        if (this.application != null && this.application.getClass().getAnnotation(Serialized.class) != null) {
            oos.writeBoolean(true);
            SerializationContext serializationContext = SerializationContextSingleton.getInstance();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            serializationContext.write((Object)this.application, (OutputStream)baos);
            baos.close();
            byte[] bytes = baos.toByteArray();
            oos.writeInt(bytes.length);
            oos.write(bytes);
        } else {
            oos.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        if (ois.readBoolean()) {
            this.userName = ois.readUTF();
        }
        if (ois.readBoolean()) {
            int size = ois.readInt();
            byte[] bytes = new byte[size];
            ois.readFully(bytes);
            this.serialization = bytes;
        } else {
            this.serialization = null;
        }
        this.application = null;
    }
}

