/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import groovy.util.ResourceConnector;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.runtime.InvokerHelper;

public class GroovyScriptEngine
implements ResourceConnector {
    private URL[] roots;
    private Map<String, ScriptCacheEntry> scriptCache = Collections.synchronizedMap(new HashMap());
    private ResourceConnector rc;
    private static ThreadLocal<ScriptCacheEntry> currentCacheEntryHolder = new ThreadLocal();
    private GroovyClassLoader groovyLoader = null;

    public static void main(String[] urls) throws Exception {
        GroovyScriptEngine gse = new GroovyScriptEngine(urls);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("groovy> ");
            String line = br.readLine();
            if (line == null || line.equals("quit")) break;
            try {
                System.out.println(gse.run(line, new Binding()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initGroovyLoader(final ClassLoader parentClassLoader) {
        if (this.groovyLoader == null || this.groovyLoader.getParent() != parentClassLoader) {
            this.groovyLoader = AccessController.doPrivileged(new PrivilegedAction<GroovyClassLoader>(){

                @Override
                public GroovyClassLoader run() {
                    ScriptClassLoader loader = parentClassLoader instanceof GroovyClassLoader ? new ScriptClassLoader((GroovyClassLoader)parentClassLoader) : new ScriptClassLoader(parentClassLoader);
                    return loader;
                }
            });
        }
    }

    public URLConnection getResourceConnection(String resourceName) throws ResourceException {
        URLConnection groovyScriptConn = null;
        ResourceException se = null;
        for (URL root : this.roots) {
            String message;
            URL scriptURL = null;
            try {
                scriptURL = new URL(root, resourceName);
                groovyScriptConn = scriptURL.openConnection();
                groovyScriptConn.getInputStream();
                break;
            }
            catch (MalformedURLException e) {
                message = "Malformed URL: " + root + ", " + resourceName;
                if (se == null) {
                    se = new ResourceException(message);
                    continue;
                }
                se = new ResourceException(message, se);
            }
            catch (IOException e1) {
                message = "Cannot open URL: " + scriptURL;
                se = se == null ? new ResourceException(message) : new ResourceException(message, se);
            }
        }
        if (groovyScriptConn == null) {
            throw se;
        }
        return groovyScriptConn;
    }

    public GroovyScriptEngine(URL[] roots) {
        this.roots = roots;
        this.rc = this;
        this.initGroovyLoader(this.getClass().getClassLoader());
    }

    public GroovyScriptEngine(URL[] roots, ClassLoader parentClassLoader) {
        this(roots);
        this.initGroovyLoader(parentClassLoader);
    }

    public GroovyScriptEngine(String[] urls) throws IOException {
        this.roots = new URL[urls.length];
        for (int i = 0; i < this.roots.length; ++i) {
            this.roots[i] = urls[i].indexOf("://") != -1 ? new URL(urls[i]) : new File(urls[i]).toURI().toURL();
        }
        this.rc = this;
        this.initGroovyLoader(this.getClass().getClassLoader());
    }

    public GroovyScriptEngine(String[] urls, ClassLoader parentClassLoader) throws IOException {
        this(urls);
        this.initGroovyLoader(parentClassLoader);
    }

    public GroovyScriptEngine(String url) throws IOException {
        this(new String[]{url});
    }

    public GroovyScriptEngine(String url, ClassLoader parentClassLoader) throws IOException {
        this(url);
        this.initGroovyLoader(parentClassLoader);
    }

    public GroovyScriptEngine(ResourceConnector rc) {
        this.rc = rc;
        this.initGroovyLoader(this.getClass().getClassLoader());
    }

    public GroovyScriptEngine(ResourceConnector rc, ClassLoader parentClassLoader) {
        this(rc);
        this.initGroovyLoader(parentClassLoader);
    }

    public ClassLoader getParentClassLoader() {
        return this.groovyLoader.getParent();
    }

    public void setParentClassLoader(ClassLoader parentClassLoader) {
        if (parentClassLoader == null) {
            throw new IllegalArgumentException("The parent class loader must not be null.");
        }
        this.initGroovyLoader(parentClassLoader);
    }

    public Class loadScriptByName(String scriptName) throws ResourceException, ScriptException {
        scriptName = scriptName.replace('.', File.separatorChar) + ".groovy";
        ScriptCacheEntry entry = this.updateCacheEntry(scriptName);
        return entry.scriptClass;
    }

    public Class loadScriptByName(String scriptName, ClassLoader parentClassLoader) throws ResourceException, ScriptException {
        this.initGroovyLoader(parentClassLoader);
        return this.loadScriptByName(scriptName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScriptCacheEntry updateCacheEntry(String scriptName) throws ResourceException, ScriptException {
        ScriptCacheEntry entry;
        String string = scriptName = scriptName.intern();
        synchronized (string) {
            URLConnection scriptConn = this.rc.getResourceConnection(scriptName);
            long lastModified = scriptConn.getLastModified();
            entry = this.scriptCache.get(scriptName);
            if (entry == null || entry.lastModified < lastModified || this.dependencyOutOfDate(entry)) {
                ScriptCacheEntry cacheEntry = new ScriptCacheEntry();
                currentCacheEntryHolder.set(cacheEntry);
                cacheEntry.scriptClass = this.parseScript(scriptName, scriptConn);
                cacheEntry.lastModified = lastModified;
                this.scriptCache.put(scriptName, cacheEntry);
                entry = cacheEntry;
                cacheEntry = null;
            } else {
                this.forceClose(scriptConn);
            }
        }
        return entry;
    }

    private Class parseScript(String scriptName, URLConnection scriptConn) throws ScriptException {
        try {
            InputStream in = scriptConn.getInputStream();
            Class clazz = this.groovyLoader.parseClass(in, scriptName);
            return clazz;
        }
        catch (Exception e) {
            throw new ScriptException("Could not parse script: " + scriptName, e);
        }
        finally {
            currentCacheEntryHolder.set(null);
            this.forceClose(scriptConn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dependencyOutOfDate(ScriptCacheEntry cacheEntry) {
        if (cacheEntry != null) {
            for (URL url : cacheEntry.dependencies.keySet()) {
                URLConnection urlc = null;
                try {
                    urlc = url.openConnection();
                    urlc.setDoInput(false);
                    urlc.setDoOutput(false);
                    long dependentLastModified = urlc.getLastModified();
                    if (dependentLastModified <= (Long)cacheEntry.dependencies.get(url)) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (IOException ioe) {
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.forceClose(urlc);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceClose(URLConnection urlConnection) {
        if (urlConnection != null) {
            InputStream in = null;
            try {
                in = urlConnection.getInputStream();
            }
            catch (Exception e) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public String run(String scriptName, String argument) throws ResourceException, ScriptException {
        Binding binding = new Binding();
        binding.setVariable("arg", argument);
        Object result = this.run(scriptName, binding);
        return result == null ? "" : result.toString();
    }

    public Object run(String scriptName, Binding binding) throws ResourceException, ScriptException {
        return this.createScript(scriptName, binding).run();
    }

    public Script createScript(String scriptName, Binding binding) throws ResourceException, ScriptException {
        ScriptCacheEntry entry = this.updateCacheEntry(scriptName);
        scriptName = scriptName.intern();
        return InvokerHelper.createScript(entry.scriptClass, binding);
    }

    public GroovyClassLoader getGroovyClassLoader() {
        return this.groovyLoader;
    }

    private class ScriptClassLoader
    extends GroovyClassLoader {
        public ScriptClassLoader(ClassLoader loader) {
            super(loader);
        }

        public ScriptClassLoader(GroovyClassLoader parent) {
            super(parent);
        }

        protected Class findClass(String className) throws ClassNotFoundException {
            String filename = className.replace('.', File.separatorChar) + ".groovy";
            URLConnection dependentScriptConn = null;
            try {
                dependentScriptConn = GroovyScriptEngine.this.rc.getResourceConnection(filename);
                ScriptCacheEntry currentCacheEntry = (ScriptCacheEntry)currentCacheEntryHolder.get();
                if (currentCacheEntry != null) {
                    currentCacheEntry.dependencies.put(dependentScriptConn.getURL(), dependentScriptConn.getLastModified());
                }
                Class clazz = this.parseClass(dependentScriptConn.getInputStream(), filename);
                return clazz;
            }
            catch (ResourceException e1) {
                throw new ClassNotFoundException("Could not read " + className + ": " + e1);
            }
            catch (CompilationFailedException e2) {
                throw new ClassNotFoundException("Syntax error in " + className + ": " + e2);
            }
            catch (IOException e3) {
                throw new ClassNotFoundException("Problem reading " + className + ": " + e3);
            }
            finally {
                try {
                    if (dependentScriptConn != null && dependentScriptConn.getInputStream() != null) {
                        dependentScriptConn.getInputStream().close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    private static class ScriptCacheEntry {
        private Class scriptClass;
        private long lastModified;
        private Map<URL, Long> dependencies = new HashMap<URL, Long>();

        private ScriptCacheEntry() {
        }
    }
}

