/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.header;

import javax.ws.rs.core.NewCookie;
import org.exoplatform.services.rest.header.AbstractHeaderDelegate;
import org.exoplatform.services.rest.impl.header.HeaderHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewCookieHeaderDelegate
extends AbstractHeaderDelegate<NewCookie> {
    @Override
    public Class<NewCookie> support() {
        return NewCookie.class;
    }

    public NewCookie fromString(String header) {
        throw new UnsupportedOperationException("NewCookie used only for response headers.");
    }

    public String toString(NewCookie cookie) {
        StringBuffer sb = new StringBuffer();
        sb.append(cookie.getName()).append('=').append(HeaderHelper.addQuotesIfHasWhitespace(cookie.getValue()));
        sb.append(';').append("Version=").append(cookie.getVersion());
        if (cookie.getComment() != null) {
            sb.append(';').append("Comment=").append(HeaderHelper.addQuotesIfHasWhitespace(cookie.getComment()));
        }
        if (cookie.getDomain() != null) {
            sb.append(';').append("Domain=").append(HeaderHelper.addQuotesIfHasWhitespace(cookie.getDomain()));
        }
        if (cookie.getPath() != null) {
            sb.append(';').append("Path=").append(HeaderHelper.addQuotesIfHasWhitespace(cookie.getPath()));
        }
        if (cookie.getMaxAge() != -1) {
            sb.append(';').append("Max-Age=").append(HeaderHelper.addQuotesIfHasWhitespace("" + cookie.getMaxAge()));
        }
        if (cookie.isSecure()) {
            sb.append(';').append("Secure");
        }
        return sb.toString();
    }
}

