/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.util.ArrayList;
import java.util.List;
import javax.resource.NotSupportedException;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.RelationshipLifeCycle;
import org.exoplatform.social.core.relationship.RelationshipListener;
import org.exoplatform.social.core.relationship.RelationshipListenerPlugin;
import org.exoplatform.social.core.relationship.model.Property;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.RelationshipStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipManager {
    private RelationshipStorage storage;
    private RelationshipLifeCycle lifeCycle = new RelationshipLifeCycle();

    public RelationshipManager(RelationshipStorage relationshipStorage) {
        this.storage = relationshipStorage;
    }

    public Relationship getRelationshipById(String id) throws Exception {
        return this.storage.getRelationship(id);
    }

    public Relationship invite(Identity currIdentity, Identity requestedIdentity) throws Exception {
        Relationship relationship = this.create(currIdentity, requestedIdentity);
        relationship.setStatus(Relationship.Type.PENDING);
        this.saveRelationship(relationship);
        this.lifeCycle.relationshipRequested(this, relationship);
        return relationship;
    }

    public void confirm(Relationship relationship) throws Exception {
        relationship.setStatus(Relationship.Type.CONFIRM);
        for (Property prop : relationship.getProperties()) {
            prop.setStatus(Relationship.Type.CONFIRM);
        }
        this.saveRelationship(relationship);
        this.lifeCycle.relationshipConfirmed(this, relationship);
    }

    public void deny(Relationship relationship) throws Exception {
        this.storage.removeRelationship(relationship);
        this.lifeCycle.relationshipDenied(this, relationship);
    }

    public void remove(Relationship relationship) throws Exception {
        this.storage.removeRelationship(relationship);
        this.lifeCycle.relationshipRemoved(this, relationship);
    }

    public void ignore(Relationship relationship) throws Exception {
        relationship.setStatus(Relationship.Type.IGNORE);
        for (Property prop : relationship.getProperties()) {
            prop.setStatus(Relationship.Type.IGNORE);
        }
        this.saveRelationship(relationship);
        this.lifeCycle.relationshipIgnored(this, relationship);
    }

    public List<Relationship> getPendingRelationships(Identity identity) throws Exception {
        List<Relationship> relationships = this.getAllRelationships(identity);
        ArrayList<Relationship> pendingRel = new ArrayList<Relationship>();
        for (Relationship rel : relationships) {
            if (rel.getStatus() == Relationship.Type.PENDING) {
                pendingRel.add(rel);
                continue;
            }
            if (rel.getProperties(Relationship.Type.PENDING).size() <= 0) continue;
            pendingRel.add(rel);
        }
        return pendingRel;
    }

    public List<Relationship> getPendingRelationships(Identity identity, boolean toConfirm) throws Exception {
        List<Relationship> rels = this.getAllRelationships(identity);
        ArrayList<Relationship> pendingRel = new ArrayList<Relationship>();
        if (toConfirm) {
            for (Relationship rel : rels) {
                if (!this.getRelationshipStatus(rel, identity).equals((Object)Relationship.Type.PENDING)) continue;
                pendingRel.add(rel);
            }
            return pendingRel;
        }
        for (Relationship relationship : rels) {
            if (!this.getRelationshipStatus(relationship, identity).equals((Object)Relationship.Type.REQUIRE_VALIDATION)) continue;
            pendingRel.add(relationship);
        }
        return pendingRel;
    }

    public List<Relationship> getPendingRelationships(Identity currIdentity, List<Identity> identities, boolean toConfirm) throws Exception {
        List<Relationship> pendingRels = this.getPendingRelationships(currIdentity, true);
        List<Relationship> invitedRels = this.getPendingRelationships(currIdentity, false);
        ArrayList<Relationship> pendingRel = new ArrayList<Relationship>();
        if (toConfirm) {
            block0: for (Identity id : identities) {
                for (Relationship rel : pendingRels) {
                    if (!rel.getReceiver().getRemoteId().equals(id.getRemoteId())) continue;
                    pendingRel.add(rel);
                    continue block0;
                }
            }
            return pendingRel;
        }
        block2: for (Identity id : identities) {
            for (Relationship rel : invitedRels) {
                if (!rel.getSender().getRemoteId().equals(id.getRemoteId())) continue;
                pendingRel.add(rel);
                continue block2;
            }
        }
        return pendingRel;
    }

    public List<Relationship> getContacts(Identity currIdentity, List<Identity> identities) throws Exception {
        List<Relationship> contacts = this.getContacts(currIdentity);
        ArrayList<Relationship> relations = new ArrayList<Relationship>();
        block0: for (Identity id : identities) {
            for (Relationship contact : contacts) {
                Identity identity = contact.getSender();
                Identity identityRel = identity.getRemoteId().equals(currIdentity.getRemoteId()) ? contact.getReceiver() : contact.getSender();
                if (!identityRel.getRemoteId().equals(id.getRemoteId())) continue;
                relations.add(contact);
                continue block0;
            }
        }
        return relations;
    }

    public List<Relationship> getContacts(Identity identity) throws Exception {
        List<Relationship> rels = this.getAllRelationships(identity);
        if (rels == null) {
            return null;
        }
        ArrayList<Relationship> contacts = new ArrayList<Relationship>();
        for (Relationship rel : rels) {
            if (rel.getStatus() != Relationship.Type.CONFIRM) continue;
            contacts.add(rel);
        }
        return contacts;
    }

    public List<Relationship> getAllRelationships(Identity identity) throws Exception {
        return this.storage.getRelationshipByIdentity(identity);
    }

    public List<Relationship> getRelationshipsByIdentityId(String id) throws Exception {
        return this.storage.getRelationshipByIdentityId(id);
    }

    public List<Identity> getIdentities(Identity id) throws Exception {
        return this.storage.getRelationshipIdentitiesByIdentity(id);
    }

    public Relationship create(Identity sender, Identity receiver) {
        return new Relationship(sender, receiver);
    }

    void saveRelationship(Relationship relationship) throws Exception {
        String receiverId;
        Identity sender = relationship.getSender();
        Identity receiver = relationship.getReceiver();
        String senderId = sender.getId();
        if (senderId.equals(receiverId = receiver.getId())) {
            throw new Exception("the two identity are the same");
        }
        for (Property prop : relationship.getProperties()) {
            String initiatorId = prop.getInitiator().getId();
            if (initiatorId.equals(senderId) || initiatorId.equals(receiverId)) continue;
            throw new Exception("the property initiator is not member of the relationship");
        }
        this.storage.saveRelationship(relationship);
    }

    public List findRoute(Identity sender, Identity receiver) throws NotSupportedException {
        throw new NotSupportedException();
    }

    public Relationship getRelationship(Identity sender, Identity receiver) throws Exception {
        List<Relationship> rels = this.getAllRelationships(sender);
        String sId2 = receiver.getId();
        for (Relationship rel : rels) {
            if (!rel.getSender().getId().equals(sId2) && !rel.getReceiver().getId().equals(sId2)) continue;
            return rel;
        }
        return null;
    }

    public Relationship.Type getRelationshipStatus(Relationship rel, Identity id) {
        if (rel == null) {
            return Relationship.Type.ALIEN;
        }
        Identity identity1 = rel.getSender();
        if (rel.getStatus().equals((Object)Relationship.Type.PENDING)) {
            if (identity1.getId().equals(id.getId())) {
                return Relationship.Type.PENDING;
            }
            return Relationship.Type.REQUIRE_VALIDATION;
        }
        if (rel.getStatus().equals((Object)Relationship.Type.IGNORE)) {
            return Relationship.Type.ALIEN;
        }
        return Relationship.Type.CONFIRM;
    }

    public Relationship.Type getConnectionStatus(Identity fromIdentity, Identity toIdentity) throws Exception {
        if (fromIdentity.getId().equals(toIdentity.getId())) {
            return Relationship.Type.SELF;
        }
        Relationship relationship = this.getRelationship(fromIdentity, toIdentity);
        return this.getRelationshipStatus(relationship, toIdentity);
    }

    public void registerListener(RelationshipListener listener) {
        this.lifeCycle.addListener(listener);
    }

    public void unregisterListener(RelationshipListener listener) {
        this.lifeCycle.removeListener(listener);
    }

    public void addListenerPlugin(RelationshipListenerPlugin plugin) {
        this.registerListener(plugin);
    }
}

