/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.jcr.JCRSessionManager;
import org.exoplatform.social.common.jcr.LockManager;
import org.exoplatform.social.common.jcr.QueryBuilder;
import org.exoplatform.social.common.jcr.SocialDataLocation;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.relationship.model.Relationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipStorage {
    private static final Log LOG = ExoLogger.getLogger(RelationshipStorage.class);
    private IdentityManager identityManager;
    private SocialDataLocation dataLocation;
    private JCRSessionManager sessionManager;
    private final LockManager lockManager;
    public static final String RELATION_NODETYPE = "exo:relationship".intern();
    public static final String PROPERTY_ISSYMETRIC = "exo:isSymetric".intern();
    public static final String PROPERTY_STATUS = "exo:status".intern();
    public static final String PROPERTY_NAME = "exo:name".intern();
    public static final String PROPERTY_INITIATOR = "exo:initiator".intern();
    public static final String PROPERTY_NODETYPE = "exo:relationshipProperty".intern();
    public static final String RELATION_SENDER = "exo:identity1Id".intern();
    public static final String RELATION_RECEIVER = "exo:identity2Id".intern();
    public static final String REFERENCEABLE_TYPE = "mix:referenceable";

    public RelationshipStorage(SocialDataLocation dataLocation, LockManager lockManager) {
        this.lockManager = lockManager;
        this.dataLocation = dataLocation;
        this.sessionManager = dataLocation.getSessionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRelationship(Relationship relationship) {
        Session session = this.sessionManager.getOrOpenSession();
        Node relationshipNode = null;
        Lock lock = this.lockManager.getLock("Relationship", relationship.getSender().getId() + "_" + relationship.getReceiver().getId());
        lock.lock();
        try {
            try {
                Node relationshipHomeNode = this.getRelationshipServiceHome(session);
                if (relationship.getId() == null) {
                    relationshipNode = relationshipHomeNode.addNode(IdGenerator.generate(), RELATION_NODETYPE);
                    relationshipNode.addMixin(REFERENCEABLE_TYPE);
                } else {
                    relationshipNode = session.getNodeByUUID(relationship.getId());
                }
                Node id1Node = session.getNodeByUUID(relationship.getSender().getId());
                Node id2Node = session.getNodeByUUID(relationship.getReceiver().getId());
                relationshipNode.setProperty(RELATION_SENDER, id1Node);
                relationshipNode.setProperty(RELATION_RECEIVER, id2Node);
                relationshipNode.setProperty(PROPERTY_STATUS, relationship.getStatus().toString());
                this.updateProperties(relationship, relationshipNode, session);
                if (relationship.getId() == null) {
                    relationshipHomeNode.save();
                    relationship.setId(relationshipNode.getUUID());
                    LOG.debug((Object)("relationship " + relationship + " stored"));
                } else {
                    relationshipNode.save();
                    LOG.debug((Object)("relationship " + relationship + " updated"));
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                this.sessionManager.closeSession();
            }
        }
        finally {
            lock.unlock();
        }
        try {
            this.loadProperties(relationship, relationshipNode);
        }
        catch (Exception e) {
            LOG.warn((Object)"can not loadProperties()", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRelationship(Relationship relationship) {
        Session session = this.sessionManager.openSession();
        try {
            Node relationshipNode = session.getNodeByUUID(relationship.getId());
            relationshipNode.remove();
            LOG.debug((Object)("relationship: " + relationship + " deleted"));
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Relationship getRelationship(String uuid) {
        Session session = this.sessionManager.getOrOpenSession();
        Relationship relationship = null;
        try {
            Node relationshipNode = session.getNodeByUUID(uuid);
            relationship = new Relationship(relationshipNode.getUUID());
            Node idNode = relationshipNode.getProperty(RELATION_SENDER).getNode();
            this.identityManager = this.getIdentityManager();
            Identity id = this.identityManager.getIdentity(idNode.getUUID());
            relationship.setSender(id);
            idNode = relationshipNode.getProperty(RELATION_RECEIVER).getNode();
            id = this.identityManager.getIdentity(idNode.getUUID());
            relationship.setReceiver(id);
            relationship.setStatus(Relationship.Type.valueOf(relationshipNode.getProperty(PROPERTY_STATUS).getString()));
            this.loadProperties(relationship, relationshipNode);
        }
        catch (ItemNotFoundException e) {
            LOG.warn((Object)e.getMessage());
            Relationship relationship2 = null;
            return relationship2;
        }
        catch (RepositoryException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return relationship;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Identity> findRelationships(String identityId, String relationshipTypeName) throws Exception {
        Session session = this.sessionManager.getOrOpenSession();
        Node relationshipServiceHome = this.getRelationshipServiceHome(session);
        ArrayList<Identity> results = new ArrayList<Identity>();
        QueryBuilder queryBuilder = new QueryBuilder(session);
        try {
            queryBuilder.select(RELATION_NODETYPE, new String[]{RELATION_SENDER, RELATION_RECEIVER}).like("jcr:path", relationshipServiceHome.getPath() + "/%").and().equal(PROPERTY_STATUS, relationshipTypeName).and().group().equal(RELATION_SENDER, identityId).or().equal(RELATION_RECEIVER, identityId).endGroup();
            List valueList = queryBuilder.execProperties();
            for (Map valueMap : valueList) {
                for (Map.Entry entry : valueMap.entrySet()) {
                    String uuid = ((Value)entry.getValue()).getString();
                    if (identityId.equals(uuid)) continue;
                    Identity identity = this.getIdentityManager().getIdentity(uuid, false);
                    if (identity != null) {
                        results.add(identity);
                        continue;
                    }
                    LOG.warn((Object)(identityId + " has a  relationship of type: " + relationshipTypeName + " with" + uuid + " which does not exist in storage"));
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to findRelationships:" + e.getMessage()), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return results;
    }

    public List<Relationship> getRelationshipByIdentity(Identity identity) throws Exception {
        if (identity.getId() == null) {
            return null;
        }
        return this.getRelationshipByIdentityId(identity.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Relationship> getRelationshipByIdentityId(String identityId) throws Exception {
        Session session = this.sessionManager.getOrOpenSession();
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        PropertyIterator refNodes = null;
        try {
            if (identityId == null) {
                List<Relationship> list = null;
                return list;
            }
            Node identityNode = session.getNodeByUUID(identityId);
            refNodes = identityNode.getReferences();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            List<Relationship> list = null;
            return list;
        }
        finally {
            this.sessionManager.closeSession();
        }
        while (refNodes.hasNext()) {
            Property property = (Property)refNodes.next();
            Node node = property.getParent();
            if (!node.isNodeType(RELATION_NODETYPE)) continue;
            results.add(this.getRelationship(node.getUUID()));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Identity> getRelationshipIdentitiesByIdentity(Identity identity) throws Exception {
        Session session = this.sessionManager.getOrOpenSession();
        ArrayList<Identity> results = new ArrayList<Identity>();
        PropertyIterator refNodes = null;
        try {
            if (identity.getId() == null) {
                List<Identity> list = null;
                return list;
            }
            Node identityNode = session.getNodeByUUID(identity.getId());
            refNodes = identityNode.getReferences();
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            List<Identity> list = null;
            return list;
        }
        finally {
            this.sessionManager.closeSession();
        }
        this.identityManager = this.getIdentityManager();
        while (refNodes.hasNext()) {
            Node relationshipNode;
            Property property = (Property)refNodes.next();
            Node node = property.getParent();
            if (!node.isNodeType(RELATION_NODETYPE)) continue;
            try {
                relationshipNode = session.getNodeByUUID(node.getUUID());
            }
            catch (ItemNotFoundException e) {
                continue;
            }
            Node idNode = relationshipNode.getProperty(RELATION_SENDER).getNode();
            String sId = idNode.getUUID();
            if (!sId.equals(identity.getId())) {
                results.add(this.identityManager.getIdentity(idNode.getUUID()));
                continue;
            }
            idNode = relationshipNode.getProperty(RELATION_RECEIVER).getNode();
            results.add(this.identityManager.getIdentity(idNode.getUUID()));
        }
        return results;
    }

    private Node getRelationshipServiceHome(Session session) {
        String path = this.dataLocation.getSocialRelationshipHome();
        try {
            return session.getRootNode().getNode(path);
        }
        catch (PathNotFoundException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void loadProperties(Relationship relationship, Node relationshipNode) throws Exception {
        NodeIterator nodes = relationshipNode.getNodes(PROPERTY_NODETYPE);
        ArrayList<org.exoplatform.social.core.relationship.model.Property> props = new ArrayList<org.exoplatform.social.core.relationship.model.Property>();
        while (nodes.hasNext()) {
            Node node = (Node)nodes.next();
            org.exoplatform.social.core.relationship.model.Property property = new org.exoplatform.social.core.relationship.model.Property();
            property.setId(node.getUUID());
            property.setName(node.getProperty(PROPERTY_NAME).getString());
            property.setSymetric(node.getProperty(PROPERTY_ISSYMETRIC).getBoolean());
            property.setStatus(Relationship.Type.valueOf(node.getProperty(PROPERTY_STATUS).getString()));
            if (node.hasProperty(PROPERTY_INITIATOR)) {
                Node idNode = node.getProperty(PROPERTY_INITIATOR).getNode();
                Identity id = this.identityManager.getIdentity(idNode.getUUID());
                property.setInitiator(id);
            }
            props.add(property);
        }
        relationship.setProperties(props);
    }

    private void updateProperties(Relationship relationship, Node relationshipNode, Session session) throws Exception {
        List<org.exoplatform.social.core.relationship.model.Property> properties = relationship.getProperties();
        NodeIterator oldNodes = relationshipNode.getNodes(PROPERTY_NODETYPE);
        while (oldNodes.hasNext()) {
            Node node = (Node)oldNodes.next();
            String uuid = node.getUUID();
            Boolean toRemove = true;
            for (org.exoplatform.social.core.relationship.model.Property property : properties) {
                if (!uuid.equals(property.getId())) continue;
                toRemove = false;
                break;
            }
            if (!toRemove.booleanValue()) continue;
            node.remove();
        }
        for (org.exoplatform.social.core.relationship.model.Property property : properties) {
            Node propertyNode;
            if (property.getId() == null) {
                propertyNode = relationshipNode.addNode(PROPERTY_NODETYPE, PROPERTY_NODETYPE);
                propertyNode.addMixin(REFERENCEABLE_TYPE);
            } else {
                propertyNode = session.getNodeByUUID(relationship.getId());
            }
            propertyNode.setProperty(PROPERTY_NAME, property.getName());
            propertyNode.setProperty(PROPERTY_ISSYMETRIC, property.isSymetric());
            propertyNode.setProperty(PROPERTY_STATUS, property.getStatus().toString());
            if (property.getInitiator() == null) continue;
            Node initiatorNode = session.getNodeByUUID(property.getInitiator().getId());
            propertyNode.setProperty(PROPERTY_INITIATOR, initiatorNode);
        }
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager;
    }
}

