/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceListAccess;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.space.UISpaceSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/social/webui/space/UIManagePendingSpaces.gtmpl", events={@EventConfig(listeners={RevokePendingActionListener.class}), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE)})
public class UIManagePendingSpaces
extends UIContainer {
    private static final String MSG_ERROR_REVOKE_PENDING = "UIManagePendingSpaces.msg.error_revoke_pending";
    private static final String SPACE_DELETED_INFO = "UIManagePendingSpaces.msg.DeletedInfo";
    SpaceService spaceService = null;
    String userId = null;
    private UIPageIterator iterator;
    private final String ITERATOR_ID = "UIIteratorPendingSpaces";
    private final Integer SPACES_PER_PAGE = 4;
    private List<Space> spaces;
    private UISpaceSearch uiSpaceSearch = (UISpaceSearch)this.createUIComponent(UISpaceSearch.class, null, "UISpaceSearch");

    public UIManagePendingSpaces() throws Exception {
        this.addChild((UIComponent)this.uiSpaceSearch);
        this.iterator = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UIIteratorPendingSpaces");
    }

    public UIPageIterator getUIPageIterator() {
        return this.iterator;
    }

    public List<Space> getAllPendingSpaces() throws SpaceException {
        SpaceService spaceService = this.getSpaceService();
        String userId = this.getUserId();
        List userSpaces = spaceService.getPendingSpaces(userId);
        return SpaceUtils.getOrderedSpaces((List)userSpaces);
    }

    public List<Space> getPendingSpaces() throws Exception {
        List<Space> listSpace = this.getSpaceList();
        this.uiSpaceSearch.setSpaceNameForAutoSuggest(this.getPendingSpaceNames());
        return this.getDisplayPendingSpaces(listSpace, this.iterator);
    }

    public String getImageSource(Space space) throws Exception {
        return space.getImageSource();
    }

    public void setSpaces(List<Space> spaces) {
        this.spaces = spaces;
    }

    public List<Space> getSpaces() {
        return this.spaces;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private String getUserId() {
        if (this.userId == null) {
            this.userId = Util.getPortalRequestContext().getRemoteUser();
        }
        return this.userId;
    }

    private List<Space> getSpaceList() throws Exception {
        List<Space> spaceList = this.getSpaces();
        List<Space> allPendingSpace = this.getAllPendingSpaces();
        if (allPendingSpace.size() == 0) {
            return allPendingSpace;
        }
        ArrayList<Space> pendingSpaces = new ArrayList<Space>();
        if (spaceList != null) {
            block0: for (Space space : spaceList) {
                for (Space pendingSpace : allPendingSpace) {
                    if (!space.getName().equals(pendingSpace.getName())) continue;
                    pendingSpaces.add(pendingSpace);
                    continue block0;
                }
            }
            return pendingSpaces;
        }
        return allPendingSpace;
    }

    private List<String> getPendingSpaceNames() throws SpaceException {
        List<Space> pendingSpaces = this.getAllPendingSpaces();
        ArrayList<String> pendingSpaceNames = new ArrayList<String>();
        for (Space space : pendingSpaces) {
            pendingSpaceNames.add(space.getName());
        }
        return pendingSpaceNames;
    }

    private String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    private String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    private String getRestContext() {
        return PortalContainer.getInstance().getRestContextName();
    }

    private List<Space> getDisplayPendingSpaces(List<Space> spaces, UIPageIterator iterator) throws Exception {
        int currentPage = iterator.getCurrentPage();
        LazyPageList pageList = new LazyPageList((ListAccess)new SpaceListAccess(spaces), this.SPACES_PER_PAGE.intValue());
        iterator.setPageList((PageList)pageList);
        int pageCount = iterator.getAvailablePage();
        if (pageCount >= currentPage) {
            iterator.setCurrentPage(currentPage);
        } else if (pageCount < currentPage) {
            iterator.setCurrentPage(currentPage - 1);
        }
        return iterator.getCurrentPageData();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchActionListener
    extends EventListener<UIManagePendingSpaces> {
        public void execute(Event<UIManagePendingSpaces> event) throws Exception {
            UIManagePendingSpaces uiForm = (UIManagePendingSpaces)((Object)event.getSource());
            UISpaceSearch uiSpaceSearch = (UISpaceSearch)uiForm.getChild(UISpaceSearch.class);
            List<Space> spaceList = uiSpaceSearch.getSpaceList();
            uiForm.setSpaces(spaceList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RevokePendingActionListener
    extends EventListener<UIManagePendingSpaces> {
        public void execute(Event<UIManagePendingSpaces> event) throws Exception {
            UIManagePendingSpaces uiPendingSpaces = (UIManagePendingSpaces)((Object)event.getSource());
            SpaceService spaceService = uiPendingSpaces.getSpaceService();
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            String spaceId = ctx.getRequestParameter("objectId");
            String userId = uiPendingSpaces.getUserId();
            Space space = spaceService.getSpaceById(spaceId);
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManagePendingSpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            try {
                spaceService.revokeRequestJoin(spaceId, userId);
            }
            catch (SpaceException se) {
                uiApp.addMessage(new ApplicationMessage(UIManagePendingSpaces.MSG_ERROR_REVOKE_PENDING, null, 0));
                return;
            }
        }
    }
}

