/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlRootElement;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.service.rest.Util;

@Path(value="social/people")
public class PeopleRestService
implements ResourceContainer {
    private IdentityManager identityManager;
    private static final long SUGGEST_LIMIT = 20L;

    @GET
    @Path(value="suggest.{format}")
    public Response suggestUsernames(@Context UriInfo uriInfo, @QueryParam(value="userName") String name, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        UserNameList nameList = new UserNameList();
        ProfileFilter filter = new ProfileFilter();
        filter.setName(name);
        filter.setCompany("");
        filter.setGender("");
        filter.setPosition("");
        filter.setSkills("");
        List identities = this.getIdentityManager().getIdentitiesByProfileFilter("organization", filter, 0L, 20L);
        for (Identity identity : identities) {
            String userName = identity.getProfile().getFullName();
            nameList.addName(userName);
        }
        return Util.getResponse(nameList, uriInfo, mediaType, Response.Status.OK);
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            PortalContainer portalContainer = (PortalContainer)ExoContainerContext.getCurrentContainer();
            this.identityManager = (IdentityManager)portalContainer.getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlRootElement
    public static class UserNameList {
        private List<String> _names;

        public void setNames(List<String> names) {
            this._names = names;
        }

        public List<String> getNames() {
            return this._names;
        }

        public void addName(String name) {
            if (this._names == null) {
                this._names = new ArrayList<String>();
            }
            this._names.add(name);
        }
    }
}

