/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.jcr.JCRSessionManager;
import org.exoplatform.social.common.jcr.QueryBuilder;
import org.exoplatform.social.common.jcr.SocialDataLocation;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityStorage {
    private static final Log LOG = ExoLogger.getLogger(ActivityStorage.class);
    private static final String PUBLISHED_NODE = "published".intern();
    private static final String NT_UNSTRUCTURED = "nt:unstructured".intern();
    private static final String ACTIVITY_NODETYPE = "exo:activity".intern();
    private static final String BODY = "exo:body".intern();
    private static final String BODY_TEMPLATE = "exo:bodyTemplate".intern();
    private static final String EXTERNAL_ID = "exo:externalId".intern();
    private static final String ID = "exo:id".intern();
    private static final String UPDATED_TIMESTAMP = "exo:updatedTimestamp".intern();
    private static final String POSTED_TIME = "exo:postedTime".intern();
    private static final String PRIORITY = "exo:priority".intern();
    private static final String TITLE = "exo:title".intern();
    private static final String TITLE_TEMPLATE = "exo:titleTemplate".intern();
    private static final String URL = "exo:url".intern();
    private static final String USER_ID = "exo:userId".intern();
    private static final String TYPE = "exo:type".intern();
    private static final String REPLY_TO_ID = "exo:replyToId".intern();
    private static final String HIDDEN = "exo:hidden".intern();
    private static final String LIKE_IDENTITY_IDS = "exo:likeIdentityIds".intern();
    private static final String PARAMS = "exo:params";
    private SocialDataLocation dataLocation;
    private JCRSessionManager sessionManager;
    private Node activityServiceHome;
    private IdentityManager identityManager;

    public ActivityStorage(SocialDataLocation dataLocation, IdentityManager identityManager) {
        this.dataLocation = dataLocation;
        this.identityManager = identityManager;
        this.sessionManager = dataLocation.getSessionManager();
    }

    public void save(Identity owner, Activity activity) {
        this.saveActivity(owner, activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activity saveActivity(Identity owner, Activity activity) {
        Validate.notNull((Object)owner, (String)"owner must not be null.");
        Validate.notNull((Object)activity, (String)"activity must not be null.");
        Validate.notNull((Object)activity.getUpdated(), (String)"Activity.getUpdated() must not be null.");
        Validate.notNull((Object)activity.getPostedTime(), (String)"Activity.getPostedTime() must not be null.");
        Validate.notNull((Object)activity.getTitle(), (String)"Activity.getTitle() must not be null.");
        if (activity.getUserId() == null) {
            activity.setUserId(owner.getId());
        }
        Node activityHomeNode = this.getPublishedActivityServiceHome(owner);
        try {
            Node activityNode;
            Session session = this.sessionManager.getOrOpenSession();
            if (activity.getId() == null) {
                activityNode = activityHomeNode.addNode(ACTIVITY_NODETYPE, ACTIVITY_NODETYPE);
                activityNode.addMixin("mix:referenceable");
            } else {
                activityNode = session.getNodeByUUID(activity.getId());
            }
            this.setStreamInfo(activity, activityNode);
            activityNode.setProperty(TITLE, activity.getTitle());
            if (activity.getTitleId() != null) {
                activityNode.setProperty(TITLE_TEMPLATE, activity.getTitleId());
            }
            activityNode.setProperty(UPDATED_TIMESTAMP, activity.getUpdatedTimestamp().longValue());
            activityNode.setProperty(POSTED_TIME, activity.getPostedTime().longValue());
            if (activity.getBody() != null) {
                activityNode.setProperty(BODY, activity.getBody());
            }
            if (activity.getExternalId() != null) {
                activityNode.setProperty(EXTERNAL_ID, activity.getExternalId());
            }
            if (activity.getPriority() != null) {
                activityNode.setProperty(PRIORITY, (double)activity.getPriority().floatValue());
            }
            if (activity.getTitle() != null) {
                activityNode.setProperty(TITLE, activity.getTitle());
            }
            if (activity.getUserId() != null) {
                activityNode.setProperty(USER_ID, activity.getUserId());
            }
            if (activity.getType() != null) {
                activityNode.setProperty(TYPE, activity.getType());
            }
            if (activity.getReplyToId() != null) {
                activityNode.setProperty(REPLY_TO_ID, activity.getReplyToId());
            }
            if (activity.getUrl() != null) {
                activityNode.setProperty(URL, activity.getUrl());
            }
            activityNode.setProperty(LIKE_IDENTITY_IDS, activity.getLikeIdentityIds());
            activityNode.setProperty(HIDDEN, activity.isHidden());
            activityNode.setProperty(TITLE_TEMPLATE, activity.getTitleId());
            activityNode.setProperty(BODY_TEMPLATE, activity.getBodyId());
            activityNode.setProperty(PARAMS, this.mapToArray(activity.getTemplateParams()));
            if (activity.getId() == null) {
                activityHomeNode.save();
                activity.setId(activityNode.getUUID());
            } else {
                activityNode.save();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to save activity", (Throwable)e);
            Activity activity2 = null;
            return activity2;
        }
        finally {
            this.sessionManager.closeSession();
        }
        return activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteActivity(String activityId) {
        this.deleteActivityComments(activityId);
        Session session = this.sessionManager.getOrOpenSession();
        try {
            Node activityNode = session.getNodeByUUID(activityId);
            if (activityNode != null) {
                activityNode.remove();
                session.save();
            } else {
                LOG.warn((Object)("Failed to delete activityId: " + activityId + ": not found"));
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to delete activity", (Throwable)ex);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    public void deleteActivity(Activity storedActivity) {
        if (storedActivity.getId() == null) {
            LOG.warn((Object)"failed to delete this actvitiy. It is not stored in JCR yet.");
        }
        this.deleteActivity(storedActivity.getId());
    }

    public void saveComment(Activity activity, Activity comment) {
        Validate.notNull((Object)activity, (String)"activity must not be null.");
        Validate.notNull((Object)comment.getUserId(), (String)"comment.getUserId() must not be null.");
        Validate.notNull((Object)comment.getTitle(), (String)"comment.getTitle() must not be null.");
        if (comment.getId() != null) {
            comment.setUpdatedTimestamp(System.currentTimeMillis());
        } else {
            comment.setPostedTime(System.currentTimeMillis());
            comment.setUpdatedTimestamp(System.currentTimeMillis());
        }
        comment.setReplyToId("IS_COMMENT");
        Identity ownerStream = this.identityManager.getIdentity(activity.getUserId());
        comment = this.saveActivity(ownerStream, comment);
        String rawCommentIds = activity.getReplyToId();
        if (rawCommentIds == null) {
            rawCommentIds = "";
        }
        rawCommentIds = rawCommentIds + "," + comment.getId();
        activity.setReplyToId(rawCommentIds);
        this.saveActivity(ownerStream, activity);
    }

    public void deleteComment(String activityId, String commentId) {
        Activity activity = this.getActivity(activityId);
        String rawCommentIds = activity.getReplyToId();
        if (rawCommentIds != null && rawCommentIds.contains(commentId)) {
            Activity comment = this.getActivity(commentId);
            if (comment == null) {
                LOG.warn((Object)("can not find comment with id: " + commentId));
                return;
            }
            try {
                this.deleteActivity(commentId);
                commentId = "," + commentId;
                rawCommentIds = rawCommentIds.replace(commentId, "");
                activity.setReplyToId(rawCommentIds);
                Identity user = this.identityManager.getIdentity(activity.getUserId());
                this.saveActivity(user, activity);
            }
            catch (Exception e) {
                LOG.warn((Object)("failed to delete comment with id: " + commentId));
            }
        } else {
            LOG.warn((Object)("can't not find commentId: " + commentId + " in activity with activityId: " + activityId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activity getActivity(String activityId) {
        Session session = this.sessionManager.getOrOpenSession();
        try {
            Node activityNode = session.getNodeByUUID(activityId);
            if (activityNode != null) {
                Activity activity = this.load(activityNode);
                return activity;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage());
        }
        finally {
            this.sessionManager.closeSession();
        }
        return null;
    }

    public Activity load(String activityId) {
        return this.getActivity(activityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Activity> getActivities(Identity owner, long offset, long limit) {
        Node n = this.getPublishedActivityServiceHome(owner);
        ArrayList<Activity> activities = new ArrayList<Activity>();
        try {
            String path = n.getPath();
            Session session = this.sessionManager.getOrOpenSession();
            List nodes = new QueryBuilder(session).select(ACTIVITY_NODETYPE, offset, limit).like("jcr:path", path + "[%]/exo:activity[%]").and().not().equal(REPLY_TO_ID, "IS_COMMENT").orderBy("exo:updatedTimestamp", "DESC").exec();
            for (Node node : nodes) {
                activities.add(this.load(node));
            }
        }
        catch (RepositoryException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return activities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Activity> getActivities(Identity owner) {
        Node publishingNode = this.getPublishedActivityServiceHome(owner);
        ArrayList<Activity> activities = new ArrayList<Activity>();
        Session session = this.sessionManager.getOrOpenSession();
        try {
            String path = publishingNode.getPath();
            List nodes = new QueryBuilder(session).select(ACTIVITY_NODETYPE).like("jcr:path", path + "[%]/exo:activity[%]").and().not().equal(REPLY_TO_ID, "IS_COMMENT").exec();
            for (Node node : nodes) {
                activities.add(this.load(node));
            }
        }
        catch (RepositoryException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return activities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActivitiesCount(Identity owner) {
        int count = 0;
        Node publishingNode = this.getPublishedActivityServiceHome(owner);
        Session session = this.sessionManager.getOrOpenSession();
        try {
            String path = publishingNode.getPath();
            count = (int)new QueryBuilder(session).select(ACTIVITY_NODETYPE).like("jcr:path", path + "[%]/exo:activity[%]").and().not().equal(REPLY_TO_ID, "IS_COMMENT").count();
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return count;
    }

    private Node getActivityServiceHome(Session session) {
        if (this.activityServiceHome == null) {
            String path = this.dataLocation.getSocialActivitiesHome();
            try {
                this.activityServiceHome = session.getRootNode().getNode(path);
            }
            catch (PathNotFoundException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
            catch (RepositoryException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.activityServiceHome;
    }

    private Node getStreamLocation(Identity owner) {
        String type = owner.getProviderId();
        String id = owner.getRemoteId();
        if (type != null && id != null) {
            return this.getStreamsLocationByType(type, id);
        }
        LOG.warn((Object)("attempting to get a stream for non prefixed owner : " + id));
        return this.getStreamsLocationByType("default", id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getStreamsLocationByType(String type, String username) {
        Session session = this.sessionManager.getOrOpenSession();
        try {
            Node typeHome;
            Node activityHomeNode = this.getActivityServiceHome(session);
            if (activityHomeNode.hasNode(type)) {
                typeHome = activityHomeNode.getNode(type);
            } else {
                typeHome = activityHomeNode.addNode(type, NT_UNSTRUCTURED);
                activityHomeNode.save();
            }
            if (typeHome.hasNode(username)) {
                Node node = typeHome.getNode(username);
                return node;
            }
            Node streamNode = typeHome.addNode(username, NT_UNSTRUCTURED);
            typeHome.save();
            Node node = streamNode;
            return node;
        }
        catch (Exception e) {
            LOG.error((Object)("failed to locate stream owner node for " + username), (Throwable)e);
            Node node = null;
            return node;
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    private Node getPublishedActivityServiceHome(Identity owner) {
        try {
            Node userActivityHomeNode = this.getStreamLocation(owner);
            try {
                return userActivityHomeNode.getNode(PUBLISHED_NODE);
            }
            catch (PathNotFoundException ex) {
                Node appNode = userActivityHomeNode.addNode(PUBLISHED_NODE, NT_UNSTRUCTURED);
                appNode.addMixin("mix:referenceable");
                userActivityHomeNode.save();
                return appNode;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to get published activity service location for " + owner), (Throwable)e);
            return null;
        }
    }

    private void deleteActivityComments(String activityId) {
        Activity activity = this.getActivity(activityId);
        String rawCommentIds = activity.getReplyToId();
        if (rawCommentIds != null) {
            if (rawCommentIds.equals("IS_COMMENT")) {
                return;
            }
            Object[] commentIds = rawCommentIds.split(",");
            for (Object commentId : commentIds = (String[])ArrayUtils.removeElement((Object[])commentIds, (Object)"")) {
                try {
                    this.deleteActivity((String)commentId);
                }
                catch (Exception ex) {
                    LOG.warn((Object)("Failed to delete comment actvity " + (String)commentId + ": " + ex.getMessage()));
                }
            }
        }
    }

    private void setStreamInfo(Activity activity, Node activityNode) throws Exception {
        try {
            activity.setStreamOwner(activityNode.getParent().getParent().getName());
            activity.setStreamId(activityNode.getParent().getUUID());
        }
        catch (UnsupportedRepositoryOperationException e) {
            activityNode.getParent().addMixin("mix:referenceable");
            activity.setStreamId(activityNode.getParent().getUUID());
        }
    }

    private Activity load(Node activityNode) {
        Activity activity = new Activity();
        try {
            activity.setId(activityNode.getUUID());
            this.setStreamInfo(activity, activityNode);
            if (activityNode.hasProperty(BODY)) {
                activity.setBody(activityNode.getProperty(BODY).getString());
            }
            if (activityNode.hasProperty(EXTERNAL_ID)) {
                activity.setExternalId(activityNode.getProperty(EXTERNAL_ID).getString());
            }
            if (activityNode.hasProperty(HIDDEN)) {
                activity.setHidden(activityNode.getProperty(HIDDEN).getBoolean());
            }
            if (activityNode.hasProperty(POSTED_TIME)) {
                activity.setPostedTime(activityNode.getProperty(POSTED_TIME).getLong());
            }
            if (activityNode.hasProperty(PRIORITY)) {
                activity.setPriority((int)activityNode.getProperty(PRIORITY).getLong());
            }
            if (activityNode.hasProperty(TITLE)) {
                activity.setTitle(activityNode.getProperty(TITLE).getString());
            }
            if (activityNode.hasProperty(TYPE)) {
                activity.setType(activityNode.getProperty(TYPE).getString());
            }
            if (activityNode.hasProperty(REPLY_TO_ID)) {
                activity.setReplyToId(activityNode.getProperty(REPLY_TO_ID).getString());
            }
            if (activityNode.hasProperty(UPDATED_TIMESTAMP)) {
                activity.setUpdatedTimestamp(activityNode.getProperty(UPDATED_TIMESTAMP).getLong());
            }
            if (activityNode.hasProperty(URL)) {
                activity.setUrl(activityNode.getProperty(URL).getString());
            }
            if (activityNode.hasProperty(USER_ID)) {
                activity.setUserId(activityNode.getProperty(USER_ID).getString());
            }
            if (activityNode.hasProperty(LIKE_IDENTITY_IDS)) {
                activity.setLikeIdentityIds(this.ValuesToStrings(activityNode.getProperty(LIKE_IDENTITY_IDS).getValues()));
            }
            if (activityNode.hasProperty(PARAMS)) {
                activity.setTemplateParams(this.valuesToMap(activityNode.getProperty(PARAMS).getValues()));
            }
            if (activityNode.hasProperty(TITLE_TEMPLATE)) {
                activity.setTitleId(activityNode.getProperty(TITLE_TEMPLATE).getString());
            }
            if (activityNode.hasProperty(BODY_TEMPLATE)) {
                activity.setBodyId(activityNode.getProperty(BODY_TEMPLATE).getString());
            }
        }
        catch (UnsupportedRepositoryOperationException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        return activity;
    }

    private Map<String, String> valuesToMap(Value[] values) {
        if (values == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Value value : values) {
            try {
                String val = value.getString();
                int equalIndex = val.indexOf("=");
                if (equalIndex <= 0) continue;
                result.put(val.split("=")[0], val.substring(equalIndex + 1));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    private String[] mapToArray(Map<String, String> templateParams) {
        if (templateParams == null) {
            return null;
        }
        Set<String> keys = templateParams.keySet();
        String[] result = new String[keys.size()];
        int i = 0;
        for (String key : keys) {
            result[i++] = key + "=" + templateParams.get(key);
        }
        return result;
    }

    private String[] ValuesToStrings(Value[] Val) throws Exception {
        if (Val.length == 1) {
            return new String[]{Val[0].getString()};
        }
        String[] Str = new String[Val.length];
        for (int i = 0; i < Val.length; ++i) {
            Str[i] = Val[i].getString();
        }
        return Str;
    }
}

