/*
 * Decompiled with CFR 0.152.
 */
package nl.captcha.text.producer;

import java.security.SecureRandom;
import java.util.Random;
import nl.captcha.text.producer.TextProducer;

public class DefaultTextProducer
implements TextProducer {
    private static final Random _gen = new SecureRandom();
    private static final int DEFAULT_LENGTH = 5;
    private static final char[] DEFAULT_CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'k', 'm', 'n', 'p', 'r', 'w', 'x', 'y', '2', '3', '4', '5', '6', '7', '8'};
    private final int _length;
    private final char[] _srcChars;

    public DefaultTextProducer() {
        this(5, DEFAULT_CHARS);
    }

    public DefaultTextProducer(int length) {
        this(length, DEFAULT_CHARS);
    }

    public DefaultTextProducer(int length, char[] srcChars) {
        this._length = length;
        this._srcChars = srcChars != null ? DefaultTextProducer.copyOf(srcChars, srcChars.length) : DEFAULT_CHARS;
    }

    public String getText() {
        int car = this._srcChars.length - 1;
        String capText = "";
        for (int i = 0; i < this._length; ++i) {
            capText = capText + this._srcChars[_gen.nextInt(car) + 1];
        }
        return capText;
    }

    public static char[] copyOf(char[] original, int newLength) {
        char[] copy = new char[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }
}

