/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database.creator;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.database.creator.DBConnectionInfo;
import org.exoplatform.services.database.creator.DBCreatorException;

public class DBCreator {
    public static final String DATABASE_TEMPLATE = "${database}";
    public static final String USERNAME_TEMPLATE = "${username}";
    public static final String PASSWORD_TEMPLATE = "${password}";
    protected final String driver;
    protected final String serverUrl;
    protected final String adminName;
    protected final String adminPwd;
    protected final String internal_logon;
    protected final String dbScript;
    protected final String dbUserName;
    protected final String dbPassword;

    public DBCreator(InitParams params) throws ConfigurationException {
        if (params == null) {
            throw new ConfigurationException("Initializations parameters expected");
        }
        PropertiesParam prop = params.getPropertiesParam("db-connection");
        if (prop != null) {
            this.driver = prop.getProperty("driverClassName");
            if (this.driver == null) {
                throw new ConfigurationException("driverClassName expected in db-connection properties section");
            }
            this.serverUrl = prop.getProperty("url");
            if (this.serverUrl == null) {
                throw new ConfigurationException("url expected in db-connection properties section");
            }
            this.adminName = prop.getProperty("username");
            if (this.adminName == null) {
                throw new ConfigurationException("username expected in db-connection properties section");
            }
            this.adminPwd = prop.getProperty("password");
            if (this.adminPwd == null) {
                throw new ConfigurationException("password expected in db-connection properties section");
            }
        } else {
            throw new ConfigurationException("db-connection properties expected in initializations parameters");
        }
        this.internal_logon = prop.getProperty("internal_logon");
        prop = params.getPropertiesParam("db-creation");
        if (prop != null) {
            String scriptPath = prop.getProperty("scriptPath");
            if (scriptPath != null) {
                try {
                    this.dbScript = this.readScriptResource(scriptPath);
                }
                catch (IOException e) {
                    throw new ConfigurationException("Can't read script resource " + scriptPath, (Throwable)e);
                }
            } else {
                throw new ConfigurationException("scriptPath expected in db-creation properties section");
            }
            this.dbUserName = prop.getProperty("username");
            if (this.dbUserName == null) {
                throw new ConfigurationException("username expected in db-creation properties section");
            }
            this.dbPassword = prop.getProperty("password");
            if (this.dbPassword == null) {
                throw new ConfigurationException("password expected in db-creation properties section");
            }
        } else {
            throw new ConfigurationException("db-creation properties expected in initializations parameters");
        }
    }

    public DBConnectionInfo createDatabase(String dbName) throws DBCreatorException {
        String dbProductName;
        Connection conn = null;
        try {
            Class.forName(this.driver);
            conn = DriverManager.getConnection(this.serverUrl, this.adminName, this.adminPwd);
        }
        catch (SQLException e) {
            throw new DBCreatorException("Can't establish the JDBC connection to database " + this.serverUrl, e);
        }
        catch (ClassNotFoundException e) {
            throw new DBCreatorException("Can't load the JDBC driver " + this.driver, e);
        }
        try {
            dbProductName = conn.getMetaData().getDatabaseProductName();
            if (dbProductName.startsWith("Microsoft SQL Server") || dbProductName.startsWith("Adaptive Server Anywhere") || dbProductName.equals("Sybase SQL Server") || dbProductName.equals("Adaptive Server Enterprise")) {
                this.executeAutoCommitMode(conn, dbName);
            } else {
                this.executeBatchMode(conn, dbName);
            }
        }
        catch (SQLException e) {
            String errorTrace = "";
            while (e != null) {
                errorTrace = errorTrace + e.getMessage() + "; ";
                e = e.getNextException();
            }
            throw new DBCreatorException("Can't execute SQL script " + errorTrace);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new DBCreatorException("Can't close connection", e);
            }
        }
        String dbUrl = this.serverUrl;
        if (dbProductName.startsWith("Microsoft SQL Server")) {
            dbUrl = dbUrl + (dbUrl.endsWith(";") ? "" : ";") + "databaseName=" + dbName + ";";
        } else if (!dbProductName.equals("Oracle")) {
            dbUrl = dbUrl + (dbUrl.endsWith("/") ? "" : "/") + dbName;
        }
        return new DBConnectionInfo(this.driver, dbUrl, this.dbUserName, this.dbPassword);
    }

    private void executeBatchMode(Connection conn, String dbName) throws SQLException {
        Statement statement = conn.createStatement();
        for (String scr : this.dbScript.split(";")) {
            scr = scr.replace(DATABASE_TEMPLATE, dbName);
            scr = scr.replace(USERNAME_TEMPLATE, this.dbUserName);
            String s = this.cleanWhitespaces((scr = scr.replace(PASSWORD_TEMPLATE, this.dbPassword)).trim());
            if (s.length() <= 0) continue;
            statement.addBatch(s);
        }
        statement.executeBatch();
    }

    private void executeAutoCommitMode(Connection conn, String dbName) throws SQLException {
        conn.setAutoCommit(true);
        for (String scr : this.dbScript.split(";")) {
            scr = scr.replace(DATABASE_TEMPLATE, dbName);
            scr = scr.replace(USERNAME_TEMPLATE, this.dbUserName);
            String s = this.cleanWhitespaces((scr = scr.replace(PASSWORD_TEMPLATE, this.dbPassword)).trim());
            if (s.length() <= 0) continue;
            conn.createStatement().executeUpdate(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readScriptResource(String path) throws IOException {
        FileInputStream is = new FileInputStream(path);
        InputStreamReader isr = new InputStreamReader(is);
        try {
            StringBuilder sbuff = new StringBuilder();
            char[] buff = new char[((InputStream)is).available()];
            int r = 0;
            while ((r = isr.read(buff)) > 0) {
                sbuff.append(buff, 0, r);
            }
            String string = sbuff.toString();
            return string;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private String cleanWhitespaces(String string) {
        if (string != null) {
            char[] cc = string.toCharArray();
            for (int ci = cc.length - 1; ci > 0; --ci) {
                if (!Character.isWhitespace(cc[ci])) continue;
                cc[ci] = 32;
            }
            return new String(cc);
        }
        return string;
    }
}

