/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.Weight;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.ChildNodesQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.DescendantSelfAxisQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldSelectors;
import org.exoplatform.services.jcr.impl.core.query.lucene.HierarchyResolver;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexFormatVersion;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrIndexSearcher;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.MatchAllDocsQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.NameQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.hits.AdaptingHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.hits.Hits;
import org.exoplatform.services.jcr.impl.core.query.lucene.hits.ScorerHits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChildAxisQuery
extends Query
implements JcrQuery {
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.ChildAxisQuery");
    private static int CONTEXT_SIZE_THRESHOLD = 10;
    private final ItemDataConsumer itemMgr;
    private Query contextQuery;
    private final InternalQName nameTest;
    private final int position;
    private final IndexFormatVersion version;
    private final NamespaceMappings nsMappings;
    private Scorer contextScorer;
    private Scorer nameTestScorer;

    ChildAxisQuery(ItemDataConsumer itemMgr, Query context, InternalQName nameTest, IndexFormatVersion version, NamespaceMappings nsMappings) {
        this(itemMgr, context, nameTest, -2147483647, version, nsMappings);
    }

    ChildAxisQuery(ItemDataConsumer itemMgr, Query context, InternalQName nameTest, int position, IndexFormatVersion version, NamespaceMappings nsMapping) {
        this.itemMgr = itemMgr;
        this.contextQuery = context;
        this.nameTest = nameTest;
        this.position = position;
        this.version = version;
        this.nsMappings = nsMapping;
    }

    Query getContextQuery() {
        return this.contextQuery;
    }

    boolean matchesAnyChildNode() {
        return this.nameTest == null && this.position == -2147483647;
    }

    InternalQName getNameTest() {
        return this.nameTest;
    }

    int getPosition() {
        return this.position;
    }

    protected Weight createWeight(Searcher searcher) {
        return new ChildAxisWeight(searcher);
    }

    public void extractTerms(Set terms) {
        this.contextQuery.extractTerms(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        DescendantSelfAxisQuery dsaq;
        Query cQuery = this.contextQuery.rewrite(reader);
        if (this.position == -2147483647 && cQuery instanceof DescendantSelfAxisQuery && (dsaq = (DescendantSelfAxisQuery)cQuery).subQueryMatchesAll()) {
            Object sub = this.nameTest == null ? new MatchAllDocsQuery() : new NameQuery(this.nameTest, this.version, this.nsMappings);
            return new DescendantSelfAxisQuery(dsaq.getContextQuery(), (Query)sub, dsaq.getMinLevels() + 1).rewrite(reader);
        }
        if (cQuery == this.contextQuery) {
            return this;
        }
        return new ChildAxisQuery(this.itemMgr, cQuery, this.nameTest, this.position, this.version, this.nsMappings);
    }

    public String toString(String field) {
        StringBuffer sb = new StringBuffer();
        sb.append("ChildAxisQuery(");
        sb.append(this.contextQuery);
        sb.append(", ");
        sb.append(this.nameTest.getAsString());
        if (this.position != -2147483647) {
            sb.append(", ");
            sb.append(this.position);
        }
        sb.append(")");
        return sb.toString();
    }

    public QueryHits execute(JcrIndexSearcher searcher, SessionImpl session, Sort sort) throws IOException {
        if (sort.getSort().length == 0 && this.matchesAnyChildNode()) {
            Query context = this.getContextQuery();
            return new ChildNodesQueryHits(searcher.evaluate(context), session);
        }
        return null;
    }

    private final class HierarchyResolvingChildrenCalculator
    extends ChildrenCalculator {
        private final Set docIds;

        public HierarchyResolvingChildrenCalculator(IndexReader reader, HierarchyResolver hResolver) {
            super(reader, hResolver);
            this.docIds = new HashSet();
        }

        protected void collectContextHit(int doc) {
            this.docIds.add(new Integer(doc));
        }

        public Hits getHits() throws IOException {
            long time = System.currentTimeMillis();
            AdaptingHits childrenHits = new AdaptingHits();
            ScorerHits nameHits = new ScorerHits(ChildAxisQuery.this.nameTestScorer);
            int[] docs = new int[1];
            int h = nameHits.next();
            while (h > -1) {
                if ((docs = this.hResolver.getParents(h, docs)).length == 1) {
                    if (this.docIds.contains(new Integer(docs[0]))) {
                        childrenHits.set(h);
                    }
                } else {
                    for (int i = 0; i < docs.length; ++i) {
                        if (!this.docIds.contains(new Integer(docs[i]))) continue;
                        childrenHits.set(h);
                    }
                }
                h = nameHits.next();
            }
            time = System.currentTimeMillis() - time;
            log.debug("Filtered hits in {} ms.", (Object)new Long(time));
            return childrenHits;
        }
    }

    private final class SimpleChildrenCalculator
    extends ChildrenCalculator {
        private final Hits contextHits;

        public SimpleChildrenCalculator(IndexReader reader, HierarchyResolver hResolver) {
            super(reader, hResolver);
            this.contextHits = new AdaptingHits();
        }

        protected void collectContextHit(int doc) {
            this.contextHits.set(doc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Hits getHits() throws IOException {
            HashMap<Integer, String> uuids = new HashMap<Integer, String>();
            int i = this.contextHits.next();
            while (i > -1) {
                String uuid = this.reader.document(i, FieldSelectors.UUID).get(FieldNames.UUID);
                uuids.put(new Integer(i), uuid);
                i = this.contextHits.next();
            }
            AdaptingHits childrenHits = new AdaptingHits();
            for (String uuid : uuids.values()) {
                try {
                    Iterator<NodeData> entries;
                    long time = System.currentTimeMillis();
                    NodeData state = (NodeData)ChildAxisQuery.this.itemMgr.getItemData(uuid);
                    time = System.currentTimeMillis() - time;
                    log.debug("got NodeState with id {} in {} ms.", (Object)uuid, (Object)new Long(time));
                    if (ChildAxisQuery.this.nameTest != null) {
                        List<NodeData> childs = ChildAxisQuery.this.itemMgr.getChildNodesData(state);
                        ArrayList<NodeData> datas = new ArrayList<NodeData>();
                        if (childs != null) {
                            for (NodeData nodeData : childs) {
                                if (!ChildAxisQuery.this.nameTest.equals((Object)nodeData.getQPath().getName())) continue;
                                datas.add(nodeData);
                            }
                        }
                        entries = datas.iterator();
                    } else {
                        entries = ChildAxisQuery.this.itemMgr.getChildNodesData(state).iterator();
                    }
                    while (entries.hasNext()) {
                        Object var14_14;
                        String childId = entries.next().getIdentifier();
                        Term uuidTerm = new Term(FieldNames.UUID, childId);
                        TermDocs docs = this.reader.termDocs(uuidTerm);
                        try {
                            if (docs.next()) {
                                childrenHits.set(docs.doc());
                            }
                            var14_14 = null;
                        }
                        catch (Throwable throwable) {
                            var14_14 = null;
                            docs.close();
                            throw throwable;
                        }
                        docs.close();
                        {
                        }
                    }
                }
                catch (RepositoryException e) {
                }
            }
            return childrenHits;
        }
    }

    private abstract class ChildrenCalculator {
        protected final IndexReader reader;
        protected final HierarchyResolver hResolver;

        public ChildrenCalculator(IndexReader reader, HierarchyResolver hResolver) {
            this.reader = reader;
            this.hResolver = hResolver;
        }

        protected abstract void collectContextHit(int var1);

        public abstract Hits getHits() throws IOException;
    }

    private class ChildAxisScorer
    extends Scorer {
        private final IndexReader reader;
        private final HierarchyResolver hResolver;
        private int nextDoc;
        private Hits hits;

        protected ChildAxisScorer(Similarity similarity, IndexReader reader, HierarchyResolver hResolver) {
            super(similarity);
            this.nextDoc = -1;
            this.reader = reader;
            this.hResolver = hResolver;
        }

        public boolean next() throws IOException {
            this.calculateChildren();
            do {
                this.nextDoc = this.hits.next();
            } while (this.nextDoc > -1 && !this.indexIsValid(this.nextDoc));
            return this.nextDoc > -1;
        }

        public int doc() {
            return this.nextDoc;
        }

        public float score() throws IOException {
            return 1.0f;
        }

        public boolean skipTo(int target) throws IOException {
            this.calculateChildren();
            this.nextDoc = this.hits.skipTo(target);
            while (this.nextDoc > -1 && !this.indexIsValid(this.nextDoc)) {
                this.next();
            }
            return this.nextDoc > -1;
        }

        public Explanation explain(int doc) throws IOException {
            throw new UnsupportedOperationException();
        }

        private void calculateChildren() throws IOException {
            if (this.hits == null) {
                final ChildrenCalculator[] calc = new ChildrenCalculator[1];
                if (ChildAxisQuery.this.nameTestScorer == null) {
                    calc[0] = new SimpleChildrenCalculator(this.reader, this.hResolver);
                    ChildAxisQuery.this.contextScorer.score(new HitCollector(){

                        public void collect(int doc, float score) {
                            calc[0].collectContextHit(doc);
                        }
                    });
                } else {
                    calc[0] = new SimpleChildrenCalculator(this.reader, this.hResolver);
                    ChildAxisQuery.this.contextScorer.score(new HitCollector(){
                        private List docIds = new ArrayList();

                        public void collect(int doc, float score) {
                            calc[0].collectContextHit(doc);
                            if (this.docIds != null) {
                                this.docIds.add(new Integer(doc));
                                if (this.docIds.size() > CONTEXT_SIZE_THRESHOLD) {
                                    calc[0] = new HierarchyResolvingChildrenCalculator(ChildAxisScorer.this.reader, ChildAxisScorer.this.hResolver);
                                    Iterator it = this.docIds.iterator();
                                    while (it.hasNext()) {
                                        calc[0].collectContextHit((Integer)it.next());
                                    }
                                    this.docIds = null;
                                }
                            }
                        }
                    });
                }
                this.hits = calc[0].getHits();
            }
        }

        private boolean indexIsValid(int i) throws IOException {
            if (ChildAxisQuery.this.position != -2147483647) {
                Document node = this.reader.document(i, FieldSelectors.UUID_AND_PARENT);
                String parentId = node.get(FieldNames.PARENT);
                String id = node.get(FieldNames.UUID);
                try {
                    NodeData state = (NodeData)ChildAxisQuery.this.itemMgr.getItemData(parentId);
                    if (ChildAxisQuery.this.nameTest == null) {
                        if (ChildAxisQuery.this.position == Integer.MIN_VALUE) {
                            List<NodeData> childNodes = ChildAxisQuery.this.itemMgr.getChildNodesData(state);
                            if (childNodes.size() == 0 || !childNodes.get(childNodes.size() - 1).getIdentifier().equals(id)) {
                                return false;
                            }
                        } else {
                            List<NodeData> childNodes = ChildAxisQuery.this.itemMgr.getChildNodesData(state);
                            if (ChildAxisQuery.this.position < 1 || childNodes.size() < ChildAxisQuery.this.position || !childNodes.get(ChildAxisQuery.this.position - 1).getIdentifier().equals(id)) {
                                return false;
                            }
                        }
                    } else if (ChildAxisQuery.this.position == Integer.MIN_VALUE) {
                        if (state == null) {
                            return false;
                        }
                        List<NodeData> childNodes = ChildAxisQuery.this.itemMgr.getChildNodesData(state);
                        if (childNodes.size() == 0 || !childNodes.get(childNodes.size() - 1).getIdentifier().equals(id)) {
                            return false;
                        }
                    } else {
                        NodeData nodeData = (NodeData)ChildAxisQuery.this.itemMgr.getItemData(id);
                        if (nodeData == null) {
                            return false;
                        }
                        if (nodeData.getQPath().getIndex() != ChildAxisQuery.this.position) {
                            return false;
                        }
                    }
                }
                catch (RepositoryException e) {
                    return false;
                }
            }
            return true;
        }
    }

    private class ChildAxisWeight
    implements Weight {
        private final Searcher searcher;

        private ChildAxisWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return ChildAxisQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            ChildAxisQuery.this.contextScorer = ChildAxisQuery.this.contextQuery.weight(this.searcher).scorer(reader);
            if (ChildAxisQuery.this.nameTest != null) {
                ChildAxisQuery.this.nameTestScorer = new NameQuery(ChildAxisQuery.this.nameTest, ChildAxisQuery.this.version, ChildAxisQuery.this.nsMappings).weight(this.searcher).scorer(reader);
            }
            return new ChildAxisScorer(this.searcher.getSimilarity(), reader, (HierarchyResolver)reader);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

