/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.context;

import com.arjuna.ArjunaOTS.ActionControl;
import com.arjuna.ArjunaOTS.ActionControlHelper;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.utils.ThreadUtil;
import com.arjuna.ats.internal.arjuna.thread.ThreadActionData;
import com.arjuna.ats.internal.jts.ControlWrapper;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.OTSImpleManager;
import com.arjuna.ats.internal.jts.orbspecific.ControlImple;
import com.arjuna.ats.internal.jts.orbspecific.TransactionFactoryImple;
import com.arjuna.ats.jts.OTSManager;
import com.arjuna.ats.jts.logging.jtsLogger;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Stack;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.CoordinatorHelper;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.TransactionFactory;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.CurrentHelper;
import org.omg.PortableInterceptor.InvalidSlot;

public class ContextManager {
    private Hashtable otsCurrent = new Hashtable();
    private Current _piCurrent = null;
    private static final String IORTag = "IOR";

    public ContextManager() {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(1L, 4L, 256L, "ContextManager::ContextManager ()");
        }
        try {
            this._piCurrent = CurrentHelper.narrow((Object)ORBManager.getORB().orb().resolve_initial_references("PICurrent"));
        }
        catch (InvalidName ex) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.context.picreffail");
            }
            ex.printStackTrace();
            throw new FatalError("ContextManager " + jtsLogger.logMesg.getString("com.arjuna.ats.internal.jts.context.picreffail") + " " + (java.lang.Object)((java.lang.Object)ex));
        }
        catch (Exception ex) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.context.picreffail");
            }
            ex.printStackTrace();
            throw new FatalError("ContextManager " + jtsLogger.logMesg.getString("com.arjuna.ats.internal.jts.context.picreffail") + " " + ex);
        }
    }

    public ControlWrapper current(String threadId) throws SystemException {
        java.lang.Object arg = this.otsCurrent.get(threadId);
        java.lang.Object wrapper = null;
        if (arg != null) {
            try {
                Stack hier = (Stack)arg;
                return (ControlWrapper)hier.peek();
            }
            catch (EmptyStackException e) {
                // empty catch block
            }
        }
        return null;
    }

    public ControlWrapper current() throws SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ContextManager::current ()");
        }
        java.lang.Object arg = this.otsCurrent.get(ThreadUtil.getThreadId());
        ControlWrapper wrapper = null;
        if (arg != null) {
            try {
                Stack hier = (Stack)arg;
                wrapper = (ControlWrapper)hier.peek();
            }
            catch (EmptyStackException e) {
                e.printStackTrace();
            }
        }
        if (wrapper == null) {
            wrapper = this.currentPIContext();
            try {
                if (wrapper != null) {
                    this.pushAction(wrapper);
                }
            }
            catch (Throwable ex) {
                if (jtsLogger.loggerI18N.isWarnEnabled()) {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.context.genfail", new java.lang.Object[]{"ContextManager.current", ex});
                }
                ex.printStackTrace();
                throw new BAD_OPERATION();
            }
        }
        return wrapper;
    }

    public final ControlWrapper popAction(String threadId) {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ContextManager::popAction ()");
        }
        ControlWrapper action = null;
        java.lang.Object arg = this.otsCurrent.get(threadId);
        if (arg != null) {
            Stack sl = (Stack)arg;
            try {
                action = (ControlWrapper)sl.pop();
            }
            catch (EmptyStackException e) {
                // empty catch block
            }
            if (sl.size() == 0) {
                sl = null;
                this.otsCurrent.remove(threadId);
                this.disassociateContext();
            }
        }
        if (action != null && action.isLocal()) {
            try {
                ThreadActionData.popAction(threadId);
            }
            catch (EmptyStackException e) {
                // empty catch block
            }
        }
        return action;
    }

    public final ControlWrapper popAction() {
        return this.popAction(ThreadUtil.getThreadId());
    }

    public final void purgeActions(String threadId) {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ContextManager::purgeActions ()");
        }
        ControlWrapper ptr = this.popAction(threadId);
        while (ptr != null) {
            ptr = null;
            ptr = this.popAction(threadId);
        }
        while (ptr != null) {
        }
    }

    public final void purgeActions() {
        this.purgeActions(ThreadUtil.getThreadId());
    }

    public void associate() throws SystemException {
        this.current();
    }

    public final boolean addRemoteHierarchy(Control cont) {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ContextManager::addRemoteHierarchy ()");
        }
        boolean isError = false;
        try {
            Coordinator coord = cont.get_coordinator();
            PropagationContext ctx = coord.get_txcontext();
            if (ctx != null) {
                int depth = ctx.parents.length;
                for (int i = depth - 1; i >= 0; --i) {
                    Coordinator tmpCoord = ctx.parents[i].coord;
                    Terminator tmpTerm = ctx.parents[i].term;
                    Control theControl = TransactionFactoryImple.createProxy((Coordinator)tmpCoord, (Terminator)tmpTerm);
                    this.pushAction(new ControlWrapper(theControl));
                }
                ctx = null;
            } else {
                isError = true;
            }
            coord = null;
        }
        catch (Exception e) {
            isError = true;
        }
        return isError;
    }

    public final boolean addActionControlHierarchy(ActionControl cont) {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ContextManager::addActionControlHierarchy ()");
        }
        boolean isError = false;
        try {
            ActionControl actControl = cont;
            Control parentControl = actControl.getParentControl();
            Stack<ControlWrapper> hier = new Stack<ControlWrapper>();
            while (parentControl != null) {
                hier.push(new ControlWrapper(parentControl));
                actControl = ActionControlHelper.narrow((Object)parentControl);
                if (actControl != null) {
                    parentControl = actControl.getParentControl();
                    continue;
                }
                parentControl = null;
            }
            actControl = null;
            try {
                ControlWrapper wrapper = (ControlWrapper)hier.pop();
                while (wrapper != null) {
                    this.pushAction(wrapper);
                    wrapper = null;
                    wrapper = (ControlWrapper)hier.pop();
                }
            }
            catch (EmptyStackException e) {
            }
        }
        catch (Exception e) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.context.genfail", new java.lang.Object[]{"ContextManager.addActionControlHierarchy", e});
            }
            e.printStackTrace();
            isError = true;
        }
        return isError;
    }

    public final boolean addControlImpleHierarchy(ControlImple which) {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ContextManager::addControlImpleHierarchy ()");
        }
        boolean isError = false;
        try {
            Stack<ControlWrapper> hier = new Stack<ControlWrapper>();
            for (ControlImple curr = which.getParentImple(); curr != null; curr = curr.getParentImple()) {
                hier.push(new ControlWrapper(curr));
            }
            try {
                ControlWrapper wrapper = (ControlWrapper)hier.pop();
                while (wrapper != null) {
                    this.pushAction(wrapper);
                    wrapper = null;
                    wrapper = (ControlWrapper)hier.pop();
                }
            }
            catch (EmptyStackException e) {
            }
        }
        catch (Exception e) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.context.genfail", new java.lang.Object[]{"ContextManager.addActionControlImple", e});
            }
            e.printStackTrace();
            isError = true;
        }
        return isError;
    }

    public final void pushAction(ControlWrapper action) {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 256L, "ContextManager::pushAction ()");
        }
        String threadId = ThreadUtil.getThreadId();
        Stack<ControlWrapper> sl = (Stack<ControlWrapper>)this.otsCurrent.get(threadId);
        boolean isNew = false;
        if (sl == null) {
            isNew = true;
            sl = new Stack<ControlWrapper>();
        }
        if (action != null) {
            action.determineLocality();
        }
        sl.push(action);
        if (isNew) {
            this.otsCurrent.put(threadId, sl);
        }
        this.associateContext();
        if (action.isLocal()) {
            ThreadActionData.pushAction((BasicAction)action.getImple().getImplHandle());
        }
    }

    public ControlWrapper currentPIContext() throws SystemException {
        if (this._piCurrent != null) {
            try {
                int slotId = OTSManager.getReceivedSlotId();
                if (slotId == -1) {
                    return null;
                }
                Any ctx = this._piCurrent.get_slot(slotId);
                if (ctx.type().kind().value() != 0) {
                    ControlWrapper control = null;
                    control = ctx.type().kind().value() == 18 ? this.createProxy(ctx) : this.createHierarchy(ctx);
                    Any threadData = ORBManager.getORB().orb().create_any();
                    threadData.insert_string(ThreadUtil.getThreadId());
                    this._piCurrent.set_slot(slotId, threadData);
                    return control;
                }
                return null;
            }
            catch (NullPointerException e) {
                return null;
            }
            catch (InvalidSlot is) {
                throw new INTERNAL();
            }
        }
        return null;
    }

    public final ControlWrapper createProxy(Any ctx) throws SystemException {
        String stringRef = null;
        try {
            stringRef = ctx.extract_string();
            if (stringRef.startsWith(IORTag)) {
                Object obj = ORBManager.getORB().orb().string_to_object(stringRef);
                Coordinator theCoordinator = CoordinatorHelper.narrow((Object)obj);
                if (theCoordinator == null) {
                    throw new BAD_PARAM();
                }
                return new ControlWrapper(TransactionFactoryImple.createProxy((Coordinator)theCoordinator, null));
            }
            return null;
        }
        catch (BAD_PARAM e1) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.context.genfail", new java.lang.Object[]{"ContextManager", stringRef});
            }
            e1.printStackTrace();
        }
        catch (Exception e2) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.context.genfail", new java.lang.Object[]{"ContextManager", e2});
            }
            throw new UNKNOWN(e2.toString());
        }
        return null;
    }

    public final ControlWrapper createHierarchy(Any ctx) throws SystemException {
        if (ctx != null) {
            try {
                PropagationContext theContext = PropagationContextHelper.extract((Any)ctx);
                if (OTSImpleManager.localFactory()) {
                    TransactionFactoryImple theFactory = OTSImpleManager.factory();
                    return new ControlWrapper(theFactory.recreateLocal(theContext));
                }
                TransactionFactory theFactory = OTSImpleManager.get_factory();
                return new ControlWrapper(theFactory.recreate(theContext));
            }
            catch (SystemException ex) {
                if (jtsLogger.loggerI18N.isWarnEnabled()) {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.context.genfail", new java.lang.Object[]{"ContextManager.createHierarchy", ex});
                }
                throw ex;
            }
            catch (Exception e) {
                if (jtsLogger.loggerI18N.isWarnEnabled()) {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.context.genfail", new java.lang.Object[]{"ContextManager.createHierarchy", e});
                }
                e.printStackTrace();
                throw new UNKNOWN();
            }
        }
        return null;
    }

    private final void associateContext() throws SystemException {
        if (this._piCurrent != null) {
            try {
                int slotId = OTSManager.getLocalSlotId();
                if (slotId != -1) {
                    Any localDataAny = ORBManager.getORB().orb().create_any();
                    localDataAny.insert_string(ThreadUtil.getThreadId());
                    this._piCurrent.set_slot(slotId, localDataAny);
                }
            }
            catch (InvalidSlot is) {
                throw new INTERNAL();
            }
        }
    }

    private final void disassociateContext() throws SystemException {
        if (this._piCurrent != null) {
            try {
                int slotId = OTSManager.getLocalSlotId();
                if (slotId != -1) {
                    this._piCurrent.set_slot(slotId, null);
                }
            }
            catch (InvalidSlot is) {
                throw new INTERNAL();
            }
        }
    }
}

