/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.exoplatform.services.rest.ComponentLifecycleScope;
import org.exoplatform.services.rest.ConstructorDescriptor;
import org.exoplatform.services.rest.FieldInjector;
import org.exoplatform.services.rest.impl.ConstructorDescriptorImpl;
import org.exoplatform.services.rest.impl.FieldInjectorImpl;
import org.exoplatform.services.rest.impl.header.MediaTypeHelper;
import org.exoplatform.services.rest.provider.ProviderDescriptor;
import org.exoplatform.services.rest.resource.ResourceDescriptorVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderDescriptorImpl
implements ProviderDescriptor {
    private final Class<?> providerClass;
    private final List<ConstructorDescriptor> constructors;
    private final List<FieldInjector> fields;
    private final List<MediaType> consumes;
    private final List<MediaType> produces;

    public ProviderDescriptorImpl(Class<?> providerClass) {
        this(providerClass, ComponentLifecycleScope.PER_REQUEST);
    }

    public ProviderDescriptorImpl(Object provider) {
        this(provider.getClass(), ComponentLifecycleScope.SINGLETON);
    }

    private ProviderDescriptorImpl(Class<?> providerClass, ComponentLifecycleScope scope) {
        this.providerClass = providerClass;
        this.constructors = new ArrayList<ConstructorDescriptor>();
        this.fields = new ArrayList<FieldInjector>();
        if (scope == ComponentLifecycleScope.PER_REQUEST) {
            for (Constructor<?> constructor : providerClass.getConstructors()) {
                this.constructors.add(new ConstructorDescriptorImpl(providerClass, constructor));
            }
            if (this.constructors.size() == 0) {
                String msg = "Not found accepted constructors for provider class " + providerClass.getName();
                throw new RuntimeException(msg);
            }
            if (this.constructors.size() > 1) {
                Collections.sort(this.constructors, ConstructorDescriptorImpl.CONSTRUCTOR_COMPARATOR);
            }
            for (AccessibleObject accessibleObject : providerClass.getDeclaredFields()) {
                this.fields.add(new FieldInjectorImpl(providerClass, (Field)accessibleObject));
            }
        }
        this.consumes = MediaTypeHelper.createConsumesList(providerClass.getAnnotation(Consumes.class));
        this.produces = MediaTypeHelper.createProducesList(providerClass.getAnnotation(Produces.class));
    }

    @Override
    public void accept(ResourceDescriptorVisitor visitor) {
        visitor.visitProviderDescriptor(this);
    }

    @Override
    public List<MediaType> consumes() {
        return this.consumes;
    }

    @Override
    public List<ConstructorDescriptor> getConstructorDescriptors() {
        return this.constructors;
    }

    @Override
    public List<FieldInjector> getFieldInjectors() {
        return this.fields;
    }

    @Override
    public Class<?> getObjectClass() {
        return this.providerClass;
    }

    @Override
    public List<MediaType> produces() {
        return this.produces;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[ ProviderDescriptorImpl: ");
        sb.append("provider class: " + this.getObjectClass() + "; ").append("produces media type: " + this.produces() + "; ").append("consumes media type: " + this.consumes() + "; ").append(this.getConstructorDescriptors() + "; ").append(this.getFieldInjectors()).append(" ]");
        return sb.toString();
    }
}

