/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application.javascript;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.javascript.JavascriptConfigParser;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.gatein.wci.WebAppEvent;
import org.gatein.wci.WebAppLifeCycleEvent;
import org.gatein.wci.WebAppListener;
import org.gatein.wci.impl.DefaultServletContainerFactory;
import org.picocontainer.Startable;

public class JavascriptDeployer
implements WebAppListener,
Startable {
    private static final String GATEIN_CONFIG_RESOURCE = "/WEB-INF/gatein-resources.xml";
    private static final Log LOG = ExoLogger.getLogger(JavascriptDeployer.class);
    private final JavascriptConfigService javascriptService;
    private final String portalContainerName;

    public JavascriptDeployer(String portalContainerName, JavascriptConfigService javascriptService) {
        this.javascriptService = javascriptService;
        this.portalContainerName = portalContainerName;
    }

    public void start() {
        DefaultServletContainerFactory.getInstance().getServletContainer().addWebAppListener((WebAppListener)this);
    }

    public void stop() {
        DefaultServletContainerFactory.getInstance().getServletContainer().removeWebAppListener((WebAppListener)this);
    }

    public void onEvent(WebAppEvent event) {
        WebAppLifeCycleEvent waEvent;
        if (event instanceof WebAppLifeCycleEvent && (waEvent = (WebAppLifeCycleEvent)event).getType() == 1) {
            ServletContext scontext = null;
            try {
                scontext = event.getWebApp().getServletContext();
                InputStream is = scontext.getResourceAsStream(GATEIN_CONFIG_RESOURCE);
                if (is == null) {
                    return;
                }
                try {
                    is.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                RootContainer.PortalContainerPostInitTask task = new RootContainer.PortalContainerPostInitTask(){

                    public void execute(ServletContext scontext, PortalContainer portalContainer) {
                        JavascriptDeployer.this.register(scontext, portalContainer);
                    }
                };
                PortalContainer.addInitTask((ServletContext)scontext, (RootContainer.PortalContainerInitTask)task, (String)this.portalContainerName);
            }
            catch (Exception ex) {
                LOG.error((Object)("An error occurs while registering 'Javascript in gatein-resources.xml' from the context '" + (scontext == null ? "unknown" : scontext.getServletContextName()) + "'"), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(ServletContext scontext, PortalContainer container) {
        InputStream is = null;
        try {
            is = scontext.getResourceAsStream(GATEIN_CONFIG_RESOURCE);
            JavascriptConfigParser.processConfigResource(is, this.javascriptService, scontext);
        }
        catch (Exception ex) {
            LOG.error((Object)("An error occurs while processing 'Javascript in gatein-resources.xml' from the context '" + scontext.getServletContextName() + "'"), (Throwable)ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

