/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.File;
import java.io.IOException;
import org.exoplatform.services.jcr.config.ContainerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.ValueStorageEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;

public class ValueStorageCleanHelper {
    public void removeWorkspaceValueStorage(WorkspaceEntry wEntry) throws RepositoryConfigurationException, IOException {
        ContainerEntry containerEntry = wEntry.getContainer();
        if (containerEntry.getValueStorages() != null) {
            for (ValueStorageEntry valueStorageEntry : containerEntry.getValueStorages()) {
                String valueStorageDirName = valueStorageEntry.getParameterValue("path");
                File valueStorageDir = new File(valueStorageDirName);
                if (!valueStorageDir.exists()) continue;
                this.removeFolder(valueStorageDir);
            }
        }
    }

    private void removeFolder(File dir) throws IOException {
        if (dir.isDirectory()) {
            for (File subFile : dir.listFiles()) {
                this.removeFolder(subFile);
            }
            if (!dir.delete()) {
                throw new IOException("Value storage folder was not deleted : " + dir.getCanonicalPath());
            }
        } else if (!dir.delete()) {
            throw new IOException("Value storage file was not deleted : " + dir.getCanonicalPath());
        }
    }
}

