/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceListAccess;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.space.UISpaceSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/social/webui/space/UIManageInvitationSpaces.gtmpl", events={@EventConfig(listeners={AcceptActionListener.class}), @EventConfig(listeners={DenyActionListener.class}), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE)})
public class UIManageInvitationSpaces
extends UIContainer {
    private static final String MSG_ERROR_ACCEPT_INVITATION = "UIManageInvitationSpaces.msg.error_accept_invitation";
    private static final String MSG_ERROR_DENY_INVITATION = "UIManageInvitationSpaces.msg.error_deny_invitation";
    private static final String SPACE_DELETED_INFO = "UIManageInvitationSpaces.msg.DeletedInfo";
    private static final String INVITATION_REVOKED_INFO = "UIManageInvitationSpaces.msg.RevokedInfo";
    private static final String INCOMING_STATUS = "incoming";
    public static final Integer LEADER = 1;
    public static final Integer MEMBER = 2;
    private UIPageIterator iterator;
    private final Integer SPACES_PER_PAGE = 4;
    private final String ITERATOR_ID = "UIIteratorInvitationSpaces";
    private SpaceService spaceService = null;
    private String userId = null;
    private List<Space> spaces;
    private UISpaceSearch uiSpaceSearch = (UISpaceSearch)this.createUIComponent(UISpaceSearch.class, null, "UISpaceSearch");
    private static final int FIRST_PAGE = 1;

    public UIManageInvitationSpaces() throws Exception {
        this.uiSpaceSearch.setTypeOfRelation(INCOMING_STATUS);
        this.addChild((UIComponent)this.uiSpaceSearch);
        this.iterator = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UIIteratorInvitationSpaces");
    }

    public UIPageIterator getUIPageIterator() {
        return this.iterator;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private String getUserId() {
        if (this.userId == null) {
            this.userId = Util.getPortalRequestContext().getRemoteUser();
        }
        return this.userId;
    }

    public List<Space> getInvitationSpaces() throws Exception {
        SpaceService spaceService = this.getSpaceService();
        String userId = this.getUserId();
        List userSpaces = spaceService.getInvitedSpaces(userId);
        return SpaceUtils.getOrderedSpaces((List)userSpaces);
    }

    public List<Space> getInvitedSpaces() throws Exception {
        List<Space> listSpace = this.getSpaceList();
        this.uiSpaceSearch.setSpaceNameForAutoSuggest(this.getInvitedSpaceNames());
        return this.getDisplayInvitedSpace(listSpace, this.iterator);
    }

    public int getRole(String spaceId) throws SpaceException {
        String userId;
        SpaceService spaceService = this.getSpaceService();
        if (spaceService.hasEditPermission(spaceId, userId = this.getUserId())) {
            return LEADER;
        }
        return MEMBER;
    }

    public void setSpaces(List<Space> spaces) {
        this.spaces = spaces;
    }

    public List<Space> getSpaces() {
        return this.spaces;
    }

    public String getImageSource(Space space) throws Exception {
        return space.getImageSource();
    }

    private List<String> getInvitedSpaceNames() throws Exception {
        List<Space> invitedSpaces = this.getInvitationSpaces();
        ArrayList<String> invitedSpaceNames = new ArrayList<String>();
        for (Space space : invitedSpaces) {
            invitedSpaceNames.add(space.getName());
        }
        return invitedSpaceNames;
    }

    private String getRestContext() {
        return PortalContainer.getInstance().getRestContextName();
    }

    private String getPortalName() {
        return PortalContainer.getCurrentPortalContainerName();
    }

    private String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    private List<Space> getSpaceList() throws Exception {
        List<Space> spaceList = this.getSpaces();
        List<Space> allInvitationSpace = this.getInvitationSpaces();
        ArrayList<Space> invitedSpaces = new ArrayList<Space>();
        if (allInvitationSpace.size() == 0) {
            return allInvitationSpace;
        }
        if (spaceList != null) {
            block0: for (Space space : spaceList) {
                for (Space invitationSpace : allInvitationSpace) {
                    if (!space.getName().equals(invitationSpace.getName())) continue;
                    invitedSpaces.add(invitationSpace);
                    continue block0;
                }
            }
            return invitedSpaces;
        }
        return allInvitationSpace;
    }

    private List<Space> getDisplayInvitedSpace(List<Space> spaces, UIPageIterator pageIterator_) throws Exception {
        int currentPage = pageIterator_.getCurrentPage();
        LazyPageList pageList = new LazyPageList((ListAccess)new SpaceListAccess(spaces), this.SPACES_PER_PAGE.intValue());
        pageIterator_.setPageList((PageList)pageList);
        if (this.uiSpaceSearch.isNewSearch()) {
            pageIterator_.setCurrentPage(1);
        } else {
            pageIterator_.setCurrentPage(currentPage);
        }
        this.uiSpaceSearch.setNewSearch(false);
        return pageIterator_.getCurrentPageData();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchActionListener
    extends EventListener<UIManageInvitationSpaces> {
        public void execute(Event<UIManageInvitationSpaces> event) throws Exception {
            UIManageInvitationSpaces uiForm = (UIManageInvitationSpaces)((Object)event.getSource());
            UISpaceSearch uiSpaceSearch = (UISpaceSearch)uiForm.getChild(UISpaceSearch.class);
            List<Space> spaceList = uiSpaceSearch.getSpaceList();
            uiForm.setSpaces(spaceList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DenyActionListener
    extends EventListener<UIManageInvitationSpaces> {
        public void execute(Event<UIManageInvitationSpaces> event) throws Exception {
            UIManageInvitationSpaces uiForm = (UIManageInvitationSpaces)((Object)event.getSource());
            SpaceService spaceService = uiForm.getSpaceService();
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            String spaceId = ctx.getRequestParameter("objectId");
            String userId = uiForm.getUserId();
            Space space = spaceService.getSpaceById(spaceId);
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManageInvitationSpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            if (!spaceService.isInvited(space, userId)) {
                uiApp.addMessage(new ApplicationMessage(UIManageInvitationSpaces.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            try {
                spaceService.denyInvitation(spaceId, userId);
            }
            catch (SpaceException se) {
                uiApp.addMessage(new ApplicationMessage(UIManageInvitationSpaces.MSG_ERROR_DENY_INVITATION, null, 0));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AcceptActionListener
    extends EventListener<UIManageInvitationSpaces> {
        public void execute(Event<UIManageInvitationSpaces> event) throws Exception {
            UIManageInvitationSpaces uiForm = (UIManageInvitationSpaces)((Object)event.getSource());
            SpaceService spaceService = uiForm.getSpaceService();
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            String spaceId = ctx.getRequestParameter("objectId");
            String userId = uiForm.getUserId();
            Space space = spaceService.getSpaceById(spaceId);
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManageInvitationSpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            if (!spaceService.isInvited(space, userId)) {
                uiApp.addMessage(new ApplicationMessage(UIManageInvitationSpaces.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            try {
                spaceService.acceptInvitation(spaceId, userId);
            }
            catch (SpaceException se) {
                uiApp.addMessage(new ApplicationMessage(UIManageInvitationSpaces.MSG_ERROR_ACCEPT_INVITATION, null, 0));
                return;
            }
            UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
            UserPortalConfig userPortalConfig = uiPortalApp.getUserPortalConfig();
            List navigations = userPortalConfig.getNavigations();
            PageNavigation spaceNavigation = SpaceUtils.getGroupNavigation((String)space.getGroupId());
            for (PageNavigation navi : navigations) {
                if (!navi.getOwner().equals(spaceNavigation.getOwner())) continue;
                spaceNavigation = navi;
                break;
            }
            SpaceUtils.setNavigation((PageNavigation)spaceNavigation);
            SpaceUtils.updateWorkingWorkSpace();
        }
    }
}

