/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.io.Writer;
import java.util.ResourceBundle;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.bean.BeanDataMapping;
import org.exoplatform.webui.bean.ReflectionDataMapping;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Serialized
public class UIFormInputSet
extends UIContainer {
    private transient BeanDataMapping beanMapping = null;
    private static String selectedCompId = "";

    public UIFormInputSet() {
    }

    public UIFormInputSet(String name) {
        this.setId(name);
    }

    public UIFormInputSet addUIFormInput(UIFormInput input) {
        this.addChild((UIComponent)input);
        return this;
    }

    public UIFormInputSet addUIFormInput(UIFormInputSet input) {
        this.addChild((UIComponent)input);
        return this;
    }

    public String getName() {
        return this.getId();
    }

    public <T extends UIFormInput> T getUIInput(String name) {
        return (T)((UIFormInput)this.findComponentById(name));
    }

    public UIFormStringInput getUIStringInput(String name) {
        return (UIFormStringInput)this.findComponentById(name);
    }

    public String getSelectedComponentId() {
        return selectedCompId;
    }

    public void setSelectedComponent(String renderCompId) {
        selectedCompId = renderCompId;
    }

    public void setSelectedComponent(int index) {
        selectedCompId = this.getChild(index - 1).getId();
    }

    public UIFormCheckBoxInput getUIFormCheckBoxInput(String name) {
        return (UIFormCheckBoxInput)this.findComponentById(name);
    }

    public UIFormSelectBox getUIFormSelectBox(String name) {
        return (UIFormSelectBox)this.findComponentById(name);
    }

    public UIFormInputInfo getUIFormInputInfo(String name) {
        return (UIFormInputInfo)this.findComponentById(name);
    }

    public UIFormTextAreaInput getUIFormTextAreaInput(String name) {
        return (UIFormTextAreaInput)this.findComponentById(name);
    }

    public void reset() {
        for (UIComponent uiChild : this.getChildren()) {
            if (!(uiChild instanceof UIFormInput)) continue;
            ((UIFormInput)uiChild).reset();
        }
    }

    public void invokeGetBindingField(Object bean) throws Exception {
        if (this.beanMapping == null) {
            this.beanMapping = ReflectionDataMapping.getInstance();
        }
        this.beanMapping.mapField(this, bean);
    }

    public void invokeSetBindingField(Object bean) throws Exception {
        if (this.beanMapping == null) {
            this.beanMapping = ReflectionDataMapping.getInstance();
        }
        this.beanMapping.mapBean(bean, this);
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        for (UIComponent child : this.getChildren()) {
            child.processDecode(context);
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.getComponentConfig() != null) {
            super.processRender(context);
            return;
        }
        Writer w = context.getWriter();
        w.write("<div class=\"UIFormInputSet\">");
        w.write("<table class=\"UIFormGrid\">");
        ResourceBundle res = context.getApplicationResourceBundle();
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        for (UIComponent inputEntry : this.getChildren()) {
            if (!inputEntry.isRendered()) continue;
            String label = "";
            boolean hasLabel = false;
            if (inputEntry instanceof UIFormInputBase) {
                UIFormInputBase formInputBase = (UIFormInputBase)inputEntry;
                label = formInputBase.getLabel() != null ? uiForm.getLabel(res, formInputBase.getLabel()) : uiForm.getLabel(res, formInputBase.getId());
                if (formInputBase.getLabel() != null || label != formInputBase.getId()) {
                    hasLabel = true;
                }
            }
            w.write("<tr>");
            w.write("<td class=\"FieldLabel\">");
            if (hasLabel) {
                w.write(label);
            }
            w.write("</td>");
            w.write("<td class=\"FieldComponent\">");
            this.renderUIComponent(inputEntry);
            w.write("</td>");
            w.write("</tr>");
        }
        w.write("</table>");
        w.write("</div>");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectComponentActionListener
    extends EventListener<UIFormInputSet> {
        public void execute(Event<UIFormInputSet> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            String renderTab = context.getRequestParameter("objectId");
            if (renderTab == null) {
                return;
            }
            selectedCompId = renderTab;
            context.setResponseComplete(true);
        }
    }
}

