/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.realm.ldap;

import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.authc.AuthenticationException;
import org.jsecurity.authc.AuthenticationInfo;
import org.jsecurity.authc.AuthenticationToken;
import org.jsecurity.authz.AuthorizationInfo;
import org.jsecurity.realm.AuthorizingRealm;
import org.jsecurity.realm.ldap.DefaultLdapContextFactory;
import org.jsecurity.realm.ldap.LdapContextFactory;
import org.jsecurity.subject.PrincipalCollection;

public abstract class AbstractLdapRealm
extends AuthorizingRealm {
    private static final Log log = LogFactory.getLog(AbstractLdapRealm.class);
    protected String principalSuffix = null;
    protected String searchBase = null;
    protected String url = null;
    protected String systemUsername = null;
    protected String systemPassword = null;
    private LdapContextFactory ldapContextFactory = null;

    public void setPrincipalSuffix(String principalSuffix) {
        this.principalSuffix = principalSuffix;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSystemUsername(String systemUsername) {
        this.systemUsername = systemUsername;
    }

    public void setSystemPassword(String systemPassword) {
        this.systemPassword = systemPassword;
    }

    public void setLdapContextFactory(LdapContextFactory ldapContextFactory) {
        this.ldapContextFactory = ldapContextFactory;
    }

    protected void afterAuthorizationCacheSet() {
        if (this.ldapContextFactory == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No LdapContextFactory is specified, so a default instance is being created.");
            }
            DefaultLdapContextFactory defaultFactory = new DefaultLdapContextFactory();
            defaultFactory.setPrincipalSuffix(this.principalSuffix);
            defaultFactory.setSearchBase(this.searchBase);
            defaultFactory.setUrl(this.url);
            defaultFactory.setSystemUsername(this.systemUsername);
            defaultFactory.setSystemPassword(this.systemPassword);
            this.ldapContextFactory = defaultFactory;
        }
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        AuthenticationInfo info;
        block2: {
            info = null;
            try {
                info = this.queryForAuthenticationInfo(token, this.ldapContextFactory);
            }
            catch (NamingException e) {
                if (!log.isErrorEnabled()) break block2;
                String message = "LDAP naming error while attempting to authenticate user.";
                log.error((Object)"LDAP naming error while attempting to authenticate user.", (Throwable)e);
            }
        }
        return info;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        AuthorizationInfo info;
        block2: {
            info = null;
            try {
                info = this.queryForAuthorizationInfo(principals, this.ldapContextFactory);
            }
            catch (NamingException e) {
                if (!log.isErrorEnabled()) break block2;
                String message = "LDAP naming error while attempting to retrieve authorization for user [" + principals + "].";
                log.error((Object)message, (Throwable)e);
            }
        }
        return info;
    }

    protected abstract AuthenticationInfo queryForAuthenticationInfo(AuthenticationToken var1, LdapContextFactory var2) throws NamingException;

    protected abstract AuthorizationInfo queryForAuthorizationInfo(PrincipalCollection var1, LdapContextFactory var2) throws NamingException;
}

