/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.concurrent.ConcurrentHashMap;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.factories.annotations.NonVolatile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonVolatile
public class RegionRegistry
extends ConcurrentHashMap<Fqn, Region> {
    private static final long serialVersionUID = -2480683437308480252L;
    private volatile int largestFqnLength;

    @Override
    public Region put(Fqn f, Region r) {
        this.largestFqnLength = Math.max(this.largestFqnLength, f.size());
        return super.put(f, r);
    }

    @Override
    public Region putIfAbsent(Fqn f, Region r) {
        Region rV = super.putIfAbsent(f, r);
        if (rV == null) {
            this.largestFqnLength = Math.max(this.largestFqnLength, f.size());
        }
        return rV;
    }

    @Override
    public Region replace(Fqn f, Region r) {
        Region rV = super.replace(f, r);
        if (rV != null) {
            this.largestFqnLength = Math.max(this.largestFqnLength, f.size());
        }
        return rV;
    }

    @Override
    public boolean replace(Fqn f, Region oldR, Region newR) {
        boolean rV = super.replace(f, oldR, newR);
        if (rV) {
            this.largestFqnLength = Math.max(this.largestFqnLength, f.size());
        }
        return rV;
    }

    public int getLargestFqnLength() {
        return this.largestFqnLength;
    }
}

