/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.dataflow;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ItemState
implements Externalizable {
    private static final long serialVersionUID = 7967457831325761318L;
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.ItemState");
    public static final int ADDED = 1;
    public static final int UPDATED = 2;
    public static final int DELETED = 4;
    public static final int UNCHANGED = 8;
    public static final int MIXIN_CHANGED = 16;
    public static final int RENAMED = 32;
    protected ItemData data;
    protected int state;
    private boolean isPersisted = true;
    private transient boolean internallyCreated = false;
    protected transient boolean eventFire;
    private transient QPath ancestorToSave;

    public ItemState(ItemData data, int state, boolean eventFire, QPath ancestorToSave) {
        this(data, state, eventFire, ancestorToSave, false, true);
    }

    public ItemState(ItemData data, int state, boolean eventFire, QPath ancestorToSave, boolean isInternalCreated) {
        this(data, state, eventFire, ancestorToSave, isInternalCreated, true);
    }

    public ItemState(ItemData data, int state, boolean eventFire, QPath ancestorToSave, boolean isInternalCreated, boolean isPersisted) {
        this.data = data;
        this.state = state;
        this.eventFire = eventFire;
        this.ancestorToSave = ancestorToSave == null ? data.getQPath() : ancestorToSave;
        this.internallyCreated = isInternalCreated;
        this.isPersisted = isPersisted;
        if (log.isDebugEnabled()) {
            log.debug((Object)(ItemState.nameFromValue(state) + " " + data.getQPath().getAsString() + ",  " + data.getIdentifier()));
        }
    }

    public boolean isPersisted() {
        return this.isPersisted;
    }

    public ItemData getData() {
        return this.data;
    }

    public int getState() {
        return this.state;
    }

    public boolean isNode() {
        return this.data.isNode();
    }

    public boolean isAdded() {
        return this.state == 1;
    }

    public boolean isUpdated() {
        return this.state == 2;
    }

    public boolean isDeleted() {
        return this.state == 4;
    }

    public boolean isUnchanged() {
        return this.state == 8;
    }

    public boolean isMixinChanged() {
        return this.state == 16;
    }

    public boolean isRenamed() {
        return this.state == 32;
    }

    public boolean isEventFire() {
        return this.eventFire;
    }

    public void eraseEventFire() {
        this.eventFire = false;
    }

    public void makeLogical() {
        this.isPersisted = false;
    }

    public boolean isDescendantOf(QPath relPath) {
        return this.ancestorToSave.isDescendantOf(relPath) || this.ancestorToSave.equals(relPath);
    }

    public QPath getAncestorToSave() {
        return this.ancestorToSave;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ItemState) {
            ItemState other = (ItemState)obj;
            return other.getData().equals(this.data) && other.getState() == this.state;
        }
        return false;
    }

    public boolean isSame(ItemState item) {
        if (this == item) {
            return true;
        }
        return this.getData().getIdentifier().hashCode() == item.getData().getIdentifier().hashCode() && this.getData().getQPath().hashCode() == item.getData().getQPath().hashCode() && this.getState() == item.getState();
    }

    public boolean isSame(String dstIdentifier, QPath dstPath, int dstState) {
        return this.getData().getIdentifier().hashCode() == dstIdentifier.hashCode() && this.getData().getQPath().hashCode() == dstPath.hashCode() && this.getState() == dstState;
    }

    public static ItemState createAddedState(ItemData data) {
        return new ItemState(data, 1, true, null, true);
    }

    public static ItemState createAddedState(ItemData data, boolean isInternalCreated) {
        return new ItemState(data, 1, true, null, isInternalCreated);
    }

    public static ItemState createUpdatedState(ItemData data) {
        return new ItemState(data, 2, true, null);
    }

    public static ItemState createUpdatedState(ItemData data, boolean isInternalCreated) {
        return new ItemState(data, 2, true, null, isInternalCreated);
    }

    public static ItemState createRenamedState(ItemData data) {
        return new ItemState(data, 32, true, null);
    }

    public static ItemState createRenamedState(ItemData data, boolean isInternalCreated) {
        return new ItemState(data, 32, true, null, isInternalCreated);
    }

    public static ItemState createDeletedState(ItemData data) {
        return new ItemState(data, 4, true, null);
    }

    public static ItemState createDeletedState(ItemData data, boolean isInternalCreated) {
        return new ItemState(data, 4, true, null, isInternalCreated);
    }

    public static ItemState createUnchangedState(ItemData data) {
        return new ItemState(data, 8, false, null);
    }

    public static ItemState createUnchangedState(ItemData data, boolean isInternalCreated) {
        return new ItemState(data, 8, false, null, isInternalCreated);
    }

    public static String nameFromValue(int stateValue) {
        switch (stateValue) {
            case 1: {
                return "ADDED";
            }
            case 4: {
                return "DELETED";
            }
            case 2: {
                return "UPDATED";
            }
            case 8: {
                return "UNCHANGED";
            }
            case 16: {
                return "MIXIN_CHANGED";
            }
            case 32: {
                return "RENAMED";
            }
        }
        return "UNDEFINED STATE";
    }

    public boolean isInternallyCreated() {
        return this.internallyCreated;
    }

    public ItemState() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.state);
        out.writeBoolean(this.isPersisted);
        out.writeBoolean(this.eventFire);
        out.writeObject(this.data);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.state = in.readInt();
        this.isPersisted = in.readBoolean();
        this.eventFire = in.readBoolean();
        this.data = (ItemData)in.readObject();
    }
}

