/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.UnknownHostException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.SeqnoTable;

public class SeqnoTableTest
extends TestCase {
    SeqnoTable tab;
    private static Address MBR;

    public SeqnoTableTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.tab.clear();
    }

    public void testInit() {
        this.tab = new SeqnoTable(0L);
        this.tab.add(MBR, 0L);
        SeqnoTableTest.assertEquals((long)0L, (long)this.tab.getHighestReceived(MBR));
        SeqnoTableTest.assertEquals((long)1L, (long)this.tab.getNextToReceive(MBR));
        this.tab.clear();
        this.tab = new SeqnoTable(50L);
        this.tab.add(MBR, 50L);
        SeqnoTableTest.assertEquals((long)50L, (long)this.tab.getHighestReceived(MBR));
        SeqnoTableTest.assertEquals((long)51L, (long)this.tab.getNextToReceive(MBR));
    }

    public void testAdd() {
        this.tab = new SeqnoTable(0L);
        this.tab.add(MBR, 0L);
        this.tab.add(MBR, 1L);
        this.tab.add(MBR, 2L);
        SeqnoTableTest.assertEquals((long)2L, (long)this.tab.getHighestReceived(MBR));
        SeqnoTableTest.assertEquals((long)3L, (long)this.tab.getNextToReceive(MBR));
    }

    public void testAddWithGaps() {
        this.tab = new SeqnoTable(0L);
        boolean rc = this.tab.add(MBR, 0L);
        SeqnoTableTest.assertTrue((boolean)rc);
        rc = this.tab.add(MBR, 1L);
        SeqnoTableTest.assertTrue((boolean)rc);
        rc = this.tab.add(MBR, 2L);
        SeqnoTableTest.assertTrue((boolean)rc);
        rc = this.tab.add(MBR, 4L);
        SeqnoTableTest.assertTrue((boolean)rc);
        rc = this.tab.add(MBR, 5L);
        SeqnoTableTest.assertTrue((boolean)rc);
        System.out.println("tab: " + this.tab);
        SeqnoTableTest.assertEquals((long)5L, (long)this.tab.getHighestReceived(MBR));
        SeqnoTableTest.assertEquals((long)3L, (long)this.tab.getNextToReceive(MBR));
        rc = this.tab.add(MBR, 3L);
        SeqnoTableTest.assertTrue((boolean)rc);
        System.out.println("tab: " + this.tab);
        SeqnoTableTest.assertEquals((long)5L, (long)this.tab.getHighestReceived(MBR));
        SeqnoTableTest.assertEquals((long)6L, (long)this.tab.getNextToReceive(MBR));
    }

    public void testAddWithGaps2() {
        this.tab = new SeqnoTable(0L);
        boolean rc = this.tab.add(MBR, 5L);
        System.out.println("tab: " + this.tab);
        SeqnoTableTest.assertTrue((boolean)rc);
        SeqnoTableTest.assertEquals((long)5L, (long)this.tab.getHighestReceived(MBR));
        SeqnoTableTest.assertEquals((long)0L, (long)this.tab.getNextToReceive(MBR));
        rc = this.tab.add(MBR, 4L);
        System.out.println("tab: " + this.tab);
        SeqnoTableTest.assertTrue((boolean)rc);
        SeqnoTableTest.assertEquals((long)5L, (long)this.tab.getHighestReceived(MBR));
        SeqnoTableTest.assertEquals((long)0L, (long)this.tab.getNextToReceive(MBR));
        rc = this.tab.add(MBR, 3L);
        System.out.println("tab: " + this.tab);
        SeqnoTableTest.assertTrue((boolean)rc);
        SeqnoTableTest.assertEquals((long)5L, (long)this.tab.getHighestReceived(MBR));
        SeqnoTableTest.assertEquals((long)0L, (long)this.tab.getNextToReceive(MBR));
        rc = this.tab.add(MBR, 2L);
        System.out.println("tab: " + this.tab);
        SeqnoTableTest.assertTrue((boolean)rc);
        SeqnoTableTest.assertEquals((long)5L, (long)this.tab.getHighestReceived(MBR));
        SeqnoTableTest.assertEquals((long)0L, (long)this.tab.getNextToReceive(MBR));
        rc = this.tab.add(MBR, 1L);
        System.out.println("tab: " + this.tab);
        SeqnoTableTest.assertTrue((boolean)rc);
        SeqnoTableTest.assertEquals((long)5L, (long)this.tab.getHighestReceived(MBR));
        SeqnoTableTest.assertEquals((long)0L, (long)this.tab.getNextToReceive(MBR));
        rc = this.tab.add(MBR, 0L);
        System.out.println("tab: " + this.tab);
        SeqnoTableTest.assertTrue((boolean)rc);
        SeqnoTableTest.assertEquals((long)5L, (long)this.tab.getHighestReceived(MBR));
        SeqnoTableTest.assertEquals((long)6L, (long)this.tab.getNextToReceive(MBR));
    }

    public void testInsertionOfDuplicates() {
        this.tab = new SeqnoTable(0L);
        boolean rc = this.tab.add(MBR, 0L);
        SeqnoTableTest.assertTrue((boolean)rc);
        rc = this.tab.add(MBR, 0L);
        SeqnoTableTest.assertFalse((boolean)rc);
        rc = this.tab.add(MBR, 1L);
        SeqnoTableTest.assertTrue((boolean)rc);
        rc = this.tab.add(MBR, 2L);
        SeqnoTableTest.assertTrue((boolean)rc);
        rc = this.tab.add(MBR, 4L);
        SeqnoTableTest.assertTrue((boolean)rc);
        rc = this.tab.add(MBR, 5L);
        SeqnoTableTest.assertTrue((boolean)rc);
        System.out.println("tab: " + this.tab);
        rc = this.tab.add(MBR, 2L);
        SeqnoTableTest.assertFalse((boolean)rc);
        rc = this.tab.add(MBR, 3L);
        SeqnoTableTest.assertTrue((boolean)rc);
        rc = this.tab.add(MBR, 3L);
        SeqnoTableTest.assertFalse((boolean)rc);
    }

    public static Test suite() {
        return new TestSuite(SeqnoTableTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SeqnoTableTest.suite());
    }

    static {
        try {
            MBR = new IpAddress("127.0.0.1", 5555);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

