/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.application;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;

public class ProfileUpdatesPublisher
extends ProfileListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(ProfileUpdatesPublisher.class);
    private ActivityManager activityManager;
    private IdentityManager identityManager;

    public ProfileUpdatesPublisher(InitParams params, ActivityManager activityManager, IdentityManager identityManager) {
        this.activityManager = activityManager;
        this.identityManager = identityManager;
    }

    public void avatarUpdated(ProfileLifeCycleEvent event) {
        this.publish(event, "@" + event.getUsername() + " has a new profile picture.");
    }

    public void basicInfoUpdated(ProfileLifeCycleEvent event) {
        this.publish(event, "@" + event.getUsername() + " profile has updated his basic profile info.");
    }

    public void contactSectionUpdated(ProfileLifeCycleEvent event) {
        this.publish(event, "@" + event.getUsername() + " profile has updated his contact info.");
    }

    public void experienceSectionUpdated(ProfileLifeCycleEvent event) {
        this.publish(event, "@" + event.getUsername() + " profile has an updated experience section.");
    }

    public void headerSectionUpdated(ProfileLifeCycleEvent event) {
        this.publish(event, "@" + event.getUsername() + " has updated his header info.");
    }

    private void publish(ProfileLifeCycleEvent event, String message) {
        try {
            Profile profile = event.getProfile();
            Identity identity = profile.getIdentity();
            this.reloadIfNeeded(identity);
            this.activityManager.recordActivity(identity, "exosocial:people", message);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to publish event " + (Object)((Object)event) + ": " + e.getMessage()));
        }
    }

    private void reloadIfNeeded(Identity id1) throws Exception {
        if (id1.getId() == null || id1.getProfile().getFullName().length() == 0) {
            id1 = this.identityManager.getIdentity(id1.getGlobalId().toString(), true);
        }
    }
}

