/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.service;

import org.apache.commons.lang.Validate;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.GlobalId;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.space.model.Space;

public class LinkProvider {
    private static IdentityManager identityManager;
    private static Log LOG;
    private static String DEFAULT_PORTAL_OWNER;

    public static String getSpaceUri(String prettyName) {
        return LinkProvider.buildSpaceUri(prettyName, null, null);
    }

    public static String getProfileUri(String username) {
        return LinkProvider.buildProfileUri(username, null, null);
    }

    public static String getProfileUri(String username, String portalOwner) {
        return LinkProvider.buildProfileUri(username, null, portalOwner);
    }

    public static String getProfileLink(String username) {
        return LinkProvider.getProfileLink(username, null);
    }

    public static String getProfileLink(String username, String portalOwner) {
        Identity identity = LinkProvider.getIdentityManager().getIdentity(GlobalId.create("organization", username).toString(), true);
        Validate.notNull((Object)identity, (String)"Identity must not be null.");
        return "<a href=\"" + LinkProvider.buildProfileUri(identity.getRemoteId(), null, portalOwner) + "\" target=\"_parent\">" + identity.getProfile().getFullName() + "</a>";
    }

    public static String getAbsoluteProfileUrl(String userName, String portalName, String portalOwner, String host) {
        return host + LinkProvider.buildProfileUri(userName, portalName, portalOwner);
    }

    public static String getUserActivityUri(String remoteId) {
        return LinkProvider.getActivityUri("organization", remoteId);
    }

    public static String getUserConnectionsUri(String remoteId) {
        return LinkProvider.getBaseUri(null, null) + "/connections/myConnections/" + remoteId;
    }

    public static String getActivityUri(String providerId, String remoteId) {
        String prefix = LinkProvider.getBaseUri(null, null) + "/";
        if (providerId.equals("organization")) {
            return prefix + "activities/" + remoteId;
        }
        if (providerId.equals("space")) {
            return prefix + remoteId;
        }
        LOG.warn((Object)("Failed to getActivityLink with providerId: " + providerId));
        return null;
    }

    public static String buildAvatarImageUri(AvatarAttachment avatarAttachment) {
        return LinkProvider.buildAvatarImageUri(PortalContainer.getInstance(), avatarAttachment);
    }

    public static String buildAvatarImageUri(Space space) {
        return LinkProvider.buildAvatarImageUri(space.getAvatarAttachment());
    }

    private static String buildAvatarImageUri(PortalContainer container, AvatarAttachment avatarAttachment) {
        String avatarUrl = null;
        try {
            if (avatarAttachment != null) {
                String repository = ((RepositoryService)container.getComponentInstanceOfType(RepositoryService.class)).getCurrentRepository().getConfiguration().getName();
                avatarUrl = "/" + container.getRestContextName() + "/jcr/" + repository + "/" + avatarAttachment.getWorkspace() + avatarAttachment.getDataPath() + "/?upd=" + avatarAttachment.getLastModified();
                avatarUrl = LinkProvider.escapeJCRSpecialCharacters(avatarUrl);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to build avatar url from avatar attachment for: " + e.getMessage()));
        }
        return avatarUrl;
    }

    public static String getAvatarImageSource(PortalContainer portalContainer, Profile profile) {
        AvatarAttachment avatarAttachment = (AvatarAttachment)profile.getProperty("avatar");
        if (avatarAttachment != null) {
            return LinkProvider.buildAvatarImageUri(portalContainer, avatarAttachment);
        }
        return null;
    }

    public static String getAvatarImageSource(Profile profile) {
        String avatarUrl = (String)profile.getProperty("avatarUrl");
        if (avatarUrl != null) {
            return avatarUrl;
        }
        AvatarAttachment avatarAttachment = (AvatarAttachment)profile.getProperty("avatar");
        if (avatarAttachment != null) {
            avatarUrl = LinkProvider.buildAvatarImageUri(avatarAttachment);
            profile.setProperty("avatarUrl", avatarUrl);
            LinkProvider.getIdentityManager().saveProfile(profile);
            return avatarUrl;
        }
        return null;
    }

    private static String buildProfileUri(String userName, String portalName, String portalOwner) {
        return LinkProvider.getBaseUri(portalName, portalOwner) + "/profile/" + userName;
    }

    private static String buildSpaceUri(String prettyName, String portalName, String portalOwner) {
        return LinkProvider.getBaseUri(portalName, portalOwner) + "/" + prettyName;
    }

    private static String getBaseUri(String portalName, String portalOwner) {
        return "/" + LinkProvider.getPortalName(portalName) + "/private/" + LinkProvider.getPortalOwner(portalOwner);
    }

    private static String escapeJCRSpecialCharacters(String string) {
        if (string == null) {
            return null;
        }
        return string.replace("[", "%5B").replace("]", "%5D").replace(":", "%3A");
    }

    private static IdentityManager getIdentityManager() {
        if (identityManager == null) {
            identityManager = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
        }
        return identityManager;
    }

    private static String getPortalOwner(String portalOwner) {
        if (portalOwner == null || "".equals(portalOwner)) {
            try {
                return Util.getPortalRequestContext().getPortalOwner();
            }
            catch (Exception e) {
                return DEFAULT_PORTAL_OWNER;
            }
        }
        return portalOwner;
    }

    private static String getPortalName(String portalName) {
        if (portalName == null || "".equals(portalName)) {
            return PortalContainer.getCurrentPortalContainerName();
        }
        return portalName;
    }

    static {
        LOG = ExoLogger.getLogger(LinkProvider.class);
        DEFAULT_PORTAL_OWNER = "classic";
    }
}

