/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.i18n;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.gatein.common.util.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParentChildResourceBundle
extends ResourceBundle {
    private Locale locale;
    private Map<String, Object> values;

    public ParentChildResourceBundle(ResourceBundle parent, ResourceBundle child) throws IllegalArgumentException {
        Object value;
        String key;
        Enumeration<String> e;
        if (child == null) {
            throw new IllegalArgumentException("Child cannot be null");
        }
        if (child.getLocale() == null) {
            throw new IllegalArgumentException("Child locale must not be null");
        }
        this.locale = child.getLocale();
        this.values = new HashMap<String, Object>();
        if (parent != null) {
            e = parent.getKeys();
            while (e.hasMoreElements()) {
                key = e.nextElement();
                value = parent.getObject(key);
                this.values.put(key, value);
            }
        }
        e = child.getKeys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            value = child.getObject(key);
            this.values.put(key, value);
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    protected Object handleGetObject(String key) {
        return this.values.get(key);
    }

    @Override
    public Enumeration<String> getKeys() {
        return Tools.toEnumeration(this.values.keySet().iterator());
    }
}

