/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.datamodel;

import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;

public abstract class NullItemData
implements ItemData {
    public static final String NULL_ID = "_null_id";
    private final String id;
    private final String parentId;
    private final QPath path;

    public NullItemData(NodeData parentData, QPathEntry name) {
        this.parentId = parentData.getIdentifier();
        this.path = QPath.makeChildPath(parentData.getQPath(), name);
        this.id = NULL_ID;
    }

    public NullItemData(String parentId, QPathEntry name) {
        this.parentId = parentId;
        this.path = null;
        this.id = NULL_ID;
    }

    public NullItemData(String id) {
        this.parentId = null;
        this.path = null;
        this.id = id;
    }

    public void accept(ItemDataVisitor visitor) throws RepositoryException {
    }

    public String getIdentifier() {
        return this.id;
    }

    public String getParentIdentifier() {
        return this.parentId;
    }

    public int getPersistedVersion() {
        return 0;
    }

    public QPath getQPath() {
        return this.path;
    }
}

