/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.BitSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.impl.core.query.lucene.CachingIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.CommittableIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocNumberCache;
import org.exoplatform.services.jcr.impl.core.query.lucene.DynamicPooledExecutor;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingQueue;
import org.exoplatform.services.jcr.impl.core.query.lucene.LazyTextExtractorField;
import org.exoplatform.services.jcr.impl.core.query.lucene.ReadOnlyIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.SharedIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractIndex {
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.AbstractIndex");
    private static final LoggingPrintStream STREAM_LOGGER = new LoggingPrintStream();
    private static final DynamicPooledExecutor EXECUTOR = new DynamicPooledExecutor();
    private IndexWriter indexWriter;
    private CommittableIndexReader indexReader;
    private Directory directory;
    private Analyzer analyzer;
    private final Similarity similarity;
    private boolean useCompoundFile = true;
    private int maxFieldLength = 10000;
    private int termInfosIndexDivisor = 1;
    private DocNumberCache cache;
    private SharedIndexReader sharedReader;
    private ReadOnlyIndexReader readOnlyReader;
    private IndexingQueue indexingQueue;
    private boolean isExisting;

    AbstractIndex(final Analyzer analyzer, Similarity similarity, final Directory directory, DocNumberCache cache, IndexingQueue indexingQueue) throws IOException {
        this.analyzer = analyzer;
        this.similarity = similarity;
        this.directory = directory;
        this.cache = cache;
        this.indexingQueue = indexingQueue;
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                AbstractIndex.this.isExisting = IndexReader.indexExists((Directory)directory);
                if (!AbstractIndex.this.isExisting) {
                    AbstractIndex.this.indexWriter = new IndexWriter(directory, analyzer, IndexWriter.MaxFieldLength.LIMITED);
                    AbstractIndex.this.indexWriter.close();
                    AbstractIndex.this.indexWriter = null;
                }
                return null;
            }
        });
    }

    Directory getDirectory() {
        return this.directory;
    }

    boolean isExisting() {
        return this.isExisting;
    }

    void addDocuments(final Document[] docs) throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                final IndexWriter writer = AbstractIndex.this.getIndexWriter();
                DynamicPooledExecutor.Command[] commands = new DynamicPooledExecutor.Command[docs.length];
                for (int i = 0; i < docs.length; ++i) {
                    final Document doc = AbstractIndex.this.getFinishedDocument(docs[i]);
                    commands[i] = new DynamicPooledExecutor.Command(){

                        public Object call() throws Exception {
                            long time = System.currentTimeMillis();
                            writer.addDocument(doc);
                            return new Long(System.currentTimeMillis() - time);
                        }
                    };
                }
                DynamicPooledExecutor.Result[] results = EXECUTOR.executeAndWait(commands);
                AbstractIndex.this.invalidateSharedReader();
                IOException ex = null;
                for (int i = 0; i < results.length; ++i) {
                    if (results[i].getException() != null) {
                        Throwable cause = results[i].getException().getCause();
                        if (ex == null) {
                            if (cause instanceof IOException) {
                                ex = (IOException)cause;
                                continue;
                            }
                            throw Util.createIOException(cause);
                        }
                        log.warn("Exception while inverting document", cause);
                        continue;
                    }
                    log.debug("Inverted document in {} ms", results[i].get());
                }
                if (ex != null) {
                    throw ex;
                }
                return null;
            }
        });
    }

    int removeDocument(final Term idTerm) throws IOException {
        return (Integer)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return AbstractIndex.this.getIndexReader().deleteDocuments(idTerm);
            }
        });
    }

    protected synchronized CommittableIndexReader getIndexReader() throws IOException {
        return (CommittableIndexReader)((Object)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<CommittableIndexReader>(){

            @Override
            public CommittableIndexReader run() throws Exception {
                if (AbstractIndex.this.indexWriter != null) {
                    AbstractIndex.this.indexWriter.close();
                    log.debug("closing IndexWriter.");
                    AbstractIndex.this.indexWriter = null;
                }
                if (AbstractIndex.this.indexReader == null || !AbstractIndex.this.indexReader.isCurrent()) {
                    IndexReader reader = IndexReader.open((Directory)AbstractIndex.this.getDirectory());
                    reader.setTermInfosIndexDivisor(AbstractIndex.this.termInfosIndexDivisor);
                    AbstractIndex.this.indexReader = new CommittableIndexReader(reader);
                }
                return AbstractIndex.this.indexReader;
            }
        }));
    }

    synchronized ReadOnlyIndexReader getReadOnlyIndexReader(final boolean initCache) throws IOException {
        return (ReadOnlyIndexReader)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<ReadOnlyIndexReader>(){

            @Override
            public ReadOnlyIndexReader run() throws Exception {
                CommittableIndexReader modifiableReader = AbstractIndex.this.getIndexReader();
                long modCount = modifiableReader.getModificationCount();
                if (AbstractIndex.this.readOnlyReader != null) {
                    if (AbstractIndex.this.readOnlyReader.getDeletedDocsVersion() == modCount) {
                        AbstractIndex.this.readOnlyReader.acquire();
                        return AbstractIndex.this.readOnlyReader;
                    }
                    if (AbstractIndex.this.readOnlyReader.getRefCount() == 1) {
                        AbstractIndex.this.readOnlyReader.updateDeletedDocs(modifiableReader);
                        AbstractIndex.this.readOnlyReader.acquire();
                        return AbstractIndex.this.readOnlyReader;
                    }
                    AbstractIndex.this.readOnlyReader.release();
                    AbstractIndex.this.readOnlyReader = null;
                }
                BitSet deleted = new BitSet(modifiableReader.maxDoc());
                for (int i = 0; i < modifiableReader.maxDoc(); ++i) {
                    if (!modifiableReader.isDeleted(i)) continue;
                    deleted.set(i);
                }
                if (AbstractIndex.this.sharedReader == null) {
                    IndexReader reader = IndexReader.open((Directory)AbstractIndex.this.getDirectory(), (boolean)true);
                    reader.setTermInfosIndexDivisor(AbstractIndex.this.termInfosIndexDivisor);
                    CachingIndexReader cr = new CachingIndexReader(reader, AbstractIndex.this.cache, initCache);
                    AbstractIndex.this.sharedReader = new SharedIndexReader(cr);
                }
                AbstractIndex.this.readOnlyReader = new ReadOnlyIndexReader(AbstractIndex.this.sharedReader, deleted, modCount);
                AbstractIndex.this.readOnlyReader.acquire();
                return AbstractIndex.this.readOnlyReader;
            }
        });
    }

    protected ReadOnlyIndexReader getReadOnlyIndexReader() throws IOException {
        return this.getReadOnlyIndexReader(false);
    }

    protected synchronized IndexWriter getIndexWriter() throws IOException {
        return (IndexWriter)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<IndexWriter>(){

            @Override
            public IndexWriter run() throws Exception {
                if (AbstractIndex.this.indexReader != null) {
                    AbstractIndex.this.indexReader.close();
                    log.debug("closing IndexReader.");
                    AbstractIndex.this.indexReader = null;
                }
                if (AbstractIndex.this.indexWriter == null) {
                    AbstractIndex.this.indexWriter = new IndexWriter(AbstractIndex.this.getDirectory(), AbstractIndex.this.analyzer, new IndexWriter.MaxFieldLength(AbstractIndex.this.maxFieldLength));
                    AbstractIndex.this.indexWriter.setSimilarity(AbstractIndex.this.similarity);
                    AbstractIndex.this.indexWriter.setUseCompoundFile(AbstractIndex.this.useCompoundFile);
                    AbstractIndex.this.indexWriter.setInfoStream((PrintStream)STREAM_LOGGER);
                }
                return AbstractIndex.this.indexWriter;
            }
        });
    }

    protected void commit() throws IOException {
        this.commit(false);
    }

    protected synchronized void commit(final boolean optimize) throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                if (AbstractIndex.this.indexReader != null) {
                    log.debug("committing IndexReader.");
                    AbstractIndex.this.indexReader.flush();
                }
                if (AbstractIndex.this.indexWriter != null) {
                    log.debug("committing IndexWriter.");
                    AbstractIndex.this.indexWriter.commit();
                }
                if (optimize) {
                    IndexWriter writer = AbstractIndex.this.getIndexWriter();
                    writer.optimize();
                    writer.close();
                    AbstractIndex.this.indexWriter = null;
                }
                return null;
            }
        });
    }

    synchronized void close() {
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                AbstractIndex.this.releaseWriterAndReaders();
                if (AbstractIndex.this.directory != null) {
                    try {
                        AbstractIndex.this.directory.close();
                    }
                    catch (IOException e) {
                        AbstractIndex.this.directory = null;
                    }
                }
                return null;
            }
        });
    }

    protected void releaseWriterAndReaders() {
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (AbstractIndex.this.indexWriter != null) {
                    try {
                        AbstractIndex.this.indexWriter.close();
                    }
                    catch (IOException e) {
                        log.warn("Exception closing index writer: " + e.toString());
                    }
                    AbstractIndex.this.indexWriter = null;
                }
                if (AbstractIndex.this.indexReader != null) {
                    try {
                        AbstractIndex.this.indexReader.close();
                    }
                    catch (IOException e) {
                        log.warn("Exception closing index reader: " + e.toString());
                    }
                    AbstractIndex.this.indexReader = null;
                }
                if (AbstractIndex.this.readOnlyReader != null) {
                    try {
                        AbstractIndex.this.readOnlyReader.release();
                    }
                    catch (IOException e) {
                        log.warn("Exception closing index reader: " + e.toString());
                    }
                    AbstractIndex.this.readOnlyReader = null;
                }
                if (AbstractIndex.this.sharedReader != null) {
                    try {
                        AbstractIndex.this.sharedReader.release();
                    }
                    catch (IOException e) {
                        log.warn("Exception closing index reader: " + e.toString());
                    }
                    AbstractIndex.this.sharedReader = null;
                }
                return null;
            }
        });
    }

    synchronized long getRamSizeInBytes() {
        if (this.indexWriter != null) {
            return this.indexWriter.ramSizeInBytes();
        }
        return 0L;
    }

    protected synchronized void invalidateSharedReader() throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                if (AbstractIndex.this.readOnlyReader != null) {
                    AbstractIndex.this.readOnlyReader.release();
                    AbstractIndex.this.readOnlyReader = null;
                }
                if (AbstractIndex.this.sharedReader != null) {
                    AbstractIndex.this.sharedReader.release();
                    AbstractIndex.this.sharedReader = null;
                }
                return null;
            }
        });
    }

    private Document getFinishedDocument(Document doc) throws IOException {
        if (!Util.isDocumentReady(doc)) {
            Document copy = new Document();
            copy.add((Fieldable)new Field(FieldNames.REINDEXING_REQUIRED, "", Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
            for (Fieldable f : doc.getFields()) {
                Field field = null;
                Field.TermVector tv = this.getTermVectorParameter(f);
                Field.Store stored = this.getStoreParameter(f);
                Field.Index indexed = this.getIndexParameter(f);
                if (f instanceof LazyTextExtractorField || f.readerValue() != null) {
                    field = new Field(f.name(), (Reader)new StringReader(""), tv);
                } else if (f.stringValue() != null) {
                    field = new Field(f.name(), f.stringValue(), stored, indexed, tv);
                } else if (f.isBinary()) {
                    field = new Field(f.name(), f.binaryValue(), stored);
                }
                if (field == null) continue;
                field.setOmitNorms(f.getOmitNorms());
                copy.add((Fieldable)field);
            }
            Document existing = this.indexingQueue.addDocument(doc);
            if (existing != null) {
                Util.disposeDocument(existing);
            }
            doc = copy;
        }
        return doc;
    }

    void setUseCompoundFile(boolean b) {
        this.useCompoundFile = b;
        if (this.indexWriter != null) {
            this.indexWriter.setUseCompoundFile(b);
        }
    }

    void setMaxFieldLength(int maxFieldLength) {
        this.maxFieldLength = maxFieldLength;
        if (this.indexWriter != null) {
            this.indexWriter.setMaxFieldLength(maxFieldLength);
        }
    }

    public int getTermInfosIndexDivisor() {
        return this.termInfosIndexDivisor;
    }

    public void setTermInfosIndexDivisor(int termInfosIndexDivisor) {
        this.termInfosIndexDivisor = termInfosIndexDivisor;
    }

    private Field.Index getIndexParameter(Fieldable f) {
        if (!f.isIndexed()) {
            return Field.Index.NO;
        }
        if (f.isTokenized()) {
            return Field.Index.ANALYZED;
        }
        return Field.Index.NOT_ANALYZED;
    }

    private Field.Store getStoreParameter(Fieldable f) {
        if (f.isCompressed()) {
            return Field.Store.COMPRESS;
        }
        if (f.isStored()) {
            return Field.Store.YES;
        }
        return Field.Store.NO;
    }

    private Field.TermVector getTermVectorParameter(Fieldable f) {
        if (f.isStorePositionWithTermVector() && f.isStoreOffsetWithTermVector()) {
            return Field.TermVector.WITH_POSITIONS_OFFSETS;
        }
        if (f.isStorePositionWithTermVector()) {
            return Field.TermVector.WITH_POSITIONS;
        }
        if (f.isStoreOffsetWithTermVector()) {
            return Field.TermVector.WITH_OFFSETS;
        }
        if (f.isTermVectorStored()) {
            return Field.TermVector.YES;
        }
        return Field.TermVector.NO;
    }

    private static final class LoggingPrintStream
    extends PrintStream {
        private StringBuffer buffer = new StringBuffer();

        public LoggingPrintStream() {
            super(new OutputStream(){

                public void write(int b) {
                }
            });
        }

        public void print(String s) {
            this.buffer.append(s);
        }

        public void println(String s) {
            this.buffer.append(s);
            log.debug(this.buffer.toString());
            this.buffer.setLength(0);
        }
    }
}

