/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.FilePersistedValueData;
import org.exoplatform.services.jcr.impl.util.io.SpoolFile;
import org.exoplatform.services.jcr.impl.util.io.SwapFile;

public class StreamPersistedValueData
extends FilePersistedValueData {
    protected InputStream stream;
    protected SpoolFile tempFile;

    public StreamPersistedValueData(int orderNumber, InputStream stream) {
        this(orderNumber, stream, null);
    }

    public StreamPersistedValueData(int orderNumber, SpoolFile tempFile) throws FileNotFoundException {
        this(orderNumber, tempFile, null);
    }

    public StreamPersistedValueData(int orderNumber, InputStream stream, File destFile) {
        super(orderNumber, destFile);
        this.tempFile = null;
        this.stream = stream;
    }

    public StreamPersistedValueData(int orderNumber, SpoolFile tempFile, File destFile) throws FileNotFoundException {
        super(orderNumber, destFile);
        this.tempFile = tempFile;
        this.stream = null;
        if (tempFile != null) {
            tempFile.acquire(this);
        }
    }

    public StreamPersistedValueData() {
    }

    public InputStream getStream() throws IOException {
        return this.stream;
    }

    public SpoolFile getTempFile() {
        return this.tempFile;
    }

    public void setPersistedFile(File file) throws FileNotFoundException {
        if (file instanceof SwapFile) {
            ((SwapFile)file).acquire(this);
        }
        this.file = file;
        this.tempFile = null;
        this.stream = null;
    }

    public boolean isPersisted() {
        return this.file != null;
    }

    public InputStream getAsStream() throws IOException {
        return super.getAsStream();
    }

    public long getLength() {
        if (this.file != null) {
            return PrivilegedFileHelper.length((File)this.file);
        }
        if (this.tempFile != null) {
            return PrivilegedFileHelper.length((File)this.tempFile);
        }
        if (this.stream instanceof FileInputStream) {
            try {
                return ((FileInputStream)this.stream).getChannel().size();
            }
            catch (IOException e) {
                return -1L;
            }
        }
        try {
            return this.stream.available();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public TransientValueData createTransientCopy() throws RepositoryException {
        return new TransientValueData(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.file != null && this.file instanceof SwapFile) {
                ((SwapFile)this.file).release(this);
            }
            if (this.tempFile != null) {
                this.tempFile.release(this);
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }
}

