/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.cleaner;

import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.CleanException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DBCleanHelper {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DBCleanHelper");
    private final String SELECT_ITEMS = "select ID from JCR_SITEM where I_CLASS=1 and CONTAINER_NAME=? and PARENT_ID=?";
    private final String REMOVE_ITEMS = "delete from JCR_SITEM where I_CLASS=1 and CONTAINER_NAME=? and PARENT_ID=?";
    protected final String containerName;
    protected final Connection connection;

    public DBCleanHelper(String containerName, Connection connection) {
        this.connection = connection;
        this.containerName = containerName;
    }

    public void clean() throws CleanException {
        try {
            this.connection.setAutoCommit(false);
            this.recursiveClean(Constants.ROOT_PARENT_UUID);
            this.connection.commit();
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException rollbackException) {
                LOG.error((Object)("Can not rollback changes after exception " + e.getMessage()), (Throwable)rollbackException);
            }
            throw new CleanException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recursiveClean(String parentID) throws SQLException {
        ResultSet result;
        Statement removeItems;
        block9: {
            PreparedStatement selectItems = null;
            removeItems = null;
            result = null;
            try {
                selectItems = this.connection.prepareStatement("select ID from JCR_SITEM where I_CLASS=1 and CONTAINER_NAME=? and PARENT_ID=?");
                selectItems.setString(1, this.containerName);
                selectItems.setString(2, parentID);
                final PreparedStatement selectStatement = selectItems;
                result = (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        return selectStatement.executeQuery();
                    }
                });
                if (result.next()) {
                    do {
                        this.recursiveClean(result.getString(1));
                    } while (result.next());
                    removeItems = this.connection.prepareStatement("delete from JCR_SITEM where I_CLASS=1 and CONTAINER_NAME=? and PARENT_ID=?");
                    removeItems.setString(1, this.containerName);
                    removeItems.setString(2, parentID);
                    Statement deleteStatement = removeItems;
                    SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>((PreparedStatement)deleteStatement){
                        final /* synthetic */ PreparedStatement val$deleteStatement;
                        {
                            this.val$deleteStatement = preparedStatement;
                        }

                        @Override
                        public Object run() throws Exception {
                            this.val$deleteStatement.executeUpdate();
                            return null;
                        }
                    });
                }
                Object var8_7 = null;
                if (selectItems == null) break block9;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (selectItems != null) {
                    selectItems.close();
                }
                if (removeItems != null) {
                    removeItems.close();
                }
                if (result != null) {
                    result.close();
                }
                throw throwable;
            }
            selectItems.close();
        }
        if (removeItems != null) {
            removeItems.close();
        }
        if (result != null) {
            result.close();
        }
    }
}

