/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.infinispan;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.config.MappedParametrizedObjectEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.TemplateConfigurationHelper;
import org.exoplatform.services.jcr.infinispan.ISPNCacheHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISPNCacheFactory<K, V> {
    public static final String INFINISPAN_CONFIG = "infinispan-configuration";
    private final TemplateConfigurationHelper configurationHelper;
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.InfinispanCacheFactory");
    private static Map<GlobalConfiguration, EmbeddedCacheManager> CACHE_MANAGERS = new HashMap<GlobalConfiguration, EmbeddedCacheManager>();

    public ISPNCacheFactory(ConfigurationManager configurationManager) {
        this.configurationHelper = new ISPNCacheHelper(configurationManager);
    }

    public Cache<K, V> createCache(final String regionId, MappedParametrizedObjectEntry parameterEntry) throws RepositoryConfigurationException {
        EmbeddedCacheManager manager;
        InputStream configStream;
        String configurationPath = parameterEntry.getParameterValue(INFINISPAN_CONFIG);
        log.info((Object)("Infinispan Cache configuration used: " + configurationPath));
        try {
            configStream = this.configurationHelper.fillTemplate(configurationPath, parameterEntry.getParameters());
        }
        catch (IOException e) {
            throw new RepositoryConfigurationException(e);
        }
        try {
            manager = (EmbeddedCacheManager)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<EmbeddedCacheManager>(){

                @Override
                public EmbeddedCacheManager run() throws IOException {
                    return ISPNCacheFactory.getUniqueInstance(regionId, (EmbeddedCacheManager)new DefaultCacheManager(configStream));
                }
            });
        }
        catch (IOException e) {
            throw new RepositoryConfigurationException(e);
        }
        PrivilegedAction action = new PrivilegedAction<Cache<K, V>>(){

            @Override
            public Cache<K, V> run() {
                return manager.getCache(regionId);
            }
        };
        Cache cache = (Cache)AccessController.doPrivileged(action);
        return cache;
    }

    private static synchronized EmbeddedCacheManager getUniqueInstance(String regionId, EmbeddedCacheManager manager) {
        GlobalConfiguration gc = manager.getGlobalConfiguration();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        gc.setClusterName(gc.getClusterName() + "-" + container.getContext().getName());
        Configuration conf = manager.getDefaultConfiguration();
        if (CACHE_MANAGERS.containsKey(gc)) {
            manager = CACHE_MANAGERS.get(gc);
        } else {
            CACHE_MANAGERS.put(gc, manager);
            if (log.isInfoEnabled()) {
                log.info((Object)("A new JBoss Cache instance has been registered for the region " + regionId + " and the container " + container.getContext().getName()));
            }
        }
        manager.defineConfiguration(regionId, conf);
        if (log.isInfoEnabled()) {
            log.info((Object)("The region " + regionId + " has been registered for the container " + container.getContext().getName()));
        }
        return manager;
    }
}

