/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.application;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class SpaceActivityPublisher
extends SpaceListenerPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(SpaceActivityPublisher.class);
    private ActivityManager activityManager;
    private IdentityManager identityManager;

    public SpaceActivityPublisher(InitParams params, ActivityManager activityManager, IdentityManager identityManager) {
        this.activityManager = activityManager;
        this.identityManager = identityManager;
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String activityMessage = space.getDisplayName() + " was created by @" + event.getTarget() + " .";
        this.recordActivity(event, activityMessage);
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
        LOG.debug((Object)("space " + event.getSpace().getDisplayName() + " was removed!"));
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
        LOG.debug((Object)("application <b>" + event.getTarget() + "</b> was activated in space " + event.getSpace().getDisplayName()));
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
        LOG.debug((Object)("application <b>" + event.getTarget() + "</b> was added in space " + event.getSpace().getDisplayName()));
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
        LOG.debug((Object)("application " + event.getTarget() + " was deactivated in space " + event.getSpace().getDisplayName()));
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
        LOG.debug((Object)("application " + event.getTarget() + " was removed in space " + event.getSpace().getDisplayName()));
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String activityMessage = "@" + event.getTarget() + " was granted manager role.";
        this.recordActivity(event, activityMessage);
        LOG.debug((Object)("user " + event.getTarget() + " was granted manager role of space " + space.getDisplayName()));
    }

    public void joined(SpaceLifeCycleEvent event) {
        String activityMessage = "@" + event.getTarget() + " has joined the space.";
        this.recordActivity(event, activityMessage);
        LOG.debug((Object)("user " + event.getTarget() + " joined space " + event.getSpace().getDisplayName()));
    }

    public void left(SpaceLifeCycleEvent event) {
        String activityMessage = "@" + event.getTarget() + " has left the space.";
        this.recordActivity(event, activityMessage);
        LOG.debug((Object)("user " + event.getTarget() + " has left of space " + event.getSpace().getDisplayName()));
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
        LOG.debug((Object)("user " + event.getTarget() + " was revoked lead privileges of space " + event.getSpace().getDisplayName()));
    }

    private void recordActivity(SpaceLifeCycleEvent event, String activityMessage) {
        Space space = event.getSpace();
        try {
            Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
            this.activityManager.recordActivity(spaceIdentity, "exosocial:spaces", activityMessage);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to record activity: " + activityMessage), (Throwable)e);
        }
    }
}

