/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity.model;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.social.core.identity.model.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profile {
    public static final String GENDER = "gender";
    public static final String USERNAME = "username";
    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";
    public static final String FULL_NAME = "fullName";
    public static final String EMAIL = "email";
    public static final String AVATAR = "avatar";
    public static final String AVATAR_URL = "avatarUrl";
    public static final String EXPERIENCES = "experiences";
    public static final String EXPERIENCES_COMPANY = "company";
    public static final String EXPERIENCES_POSITION = "position";
    public static final String EXPERIENCES_SKILLS = "skills";
    public static final String EXPERIENCES_START_DATE = "startDate";
    public static final String EXPERIENCES_END_DATE = "endDate";
    public static final String EXPERIENCES_IS_CURRENT = "isCurrent";
    public static final String EXPERIENCES_DESCRIPTION = "description";
    public static final String POSITION = "position";
    public static final String URL = "Url";
    public static final String CONTACT_PHONES = "phones";
    public static final String CONTACT_IMS = "ims";
    public static final String CONTACT_URLS = "urls";
    public static final String URL_POSTFIX = "Url";
    public static final String RESIZED_SUBFIX = "RESIZED_";
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private static final Map<UpdateType, String[]> updateTypes = new HashMap<UpdateType, String[]>();
    private final Identity identity;
    private String id;
    private long lastLoaded;
    private boolean hasChanged;
    private UpdateType updateType;

    public Profile(Identity identity) {
        this.identity = identity;
    }

    public final Identity getIdentity() {
        return this.identity;
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final long getLastLoaded() {
        return this.lastLoaded;
    }

    public final void setLastLoaded(long lastLoaded) {
        this.lastLoaded = lastLoaded;
    }

    public final boolean hasChanged() {
        return this.hasChanged;
    }

    public final void clearHasChanged() {
        this.setHasChanged(false);
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    protected void setUpdateType(String updateType) {
        block0: for (UpdateType key : updateTypes.keySet()) {
            String[] updateTypeValues;
            for (String value : updateTypeValues = updateTypes.get((Object)key)) {
                if (!value.equals(updateType)) continue;
                this.updateType = key;
                continue block0;
            }
        }
    }

    private void setHasChanged(boolean hasChanged) {
        this.hasChanged = hasChanged;
    }

    public final Object getProperty(String name) {
        return this.properties.get(name);
    }

    public final void setProperty(String name, Object value) {
        this.properties.put(name, value);
        this.setHasChanged(true);
        this.setUpdateType(name);
    }

    public final boolean contains(String name) {
        return this.properties.containsKey(name);
    }

    public final Map<String, Object> getProperties() {
        return this.properties;
    }

    public final void removeProperty(String name) {
        this.properties.remove(name);
        this.setHasChanged(true);
    }

    public final Object getPropertyValue(String name) {
        return this.getProperty(name);
    }

    public final String getFullName() {
        String first = (String)this.getProperty(FIRST_NAME);
        String last = (String)this.getProperty(LAST_NAME);
        String all = first != null ? first : "";
        all = all + (last != null ? " " + last : "");
        return all;
    }

    public final String getUrl() {
        return (String)this.getProperty("Url");
    }

    public final void addOrModifyProperties(Map<String, Object> props) {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String key = entry.getKey();
            if (key.contains(":")) continue;
            this.setProperty(key, entry.getValue());
        }
        this.setHasChanged(true);
    }

    public final String getAvatarImageSource() {
        return (String)this.getProperty(AVATAR_URL);
    }

    public final String getAvatarUrl() {
        return (String)this.getProperty(AVATAR_URL);
    }

    public final String getPosition() {
        return (String)this.getProperty("position");
    }

    public final String toString() {
        return "[uuid : " + this.id + " identity : " + this.identity.getId() + " properties: " + this.properties;
    }

    static {
        updateTypes.put(UpdateType.POSITION, new String[]{"position"});
        updateTypes.put(UpdateType.BASIC_INFOR, new String[]{FIRST_NAME, LAST_NAME, EMAIL});
        updateTypes.put(UpdateType.CONTACT, new String[]{GENDER, CONTACT_PHONES, CONTACT_IMS, CONTACT_URLS});
        updateTypes.put(UpdateType.EXPERIENCES, new String[]{EXPERIENCES});
        updateTypes.put(UpdateType.AVATAR, new String[]{AVATAR, AVATAR_URL});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpdateType {
        POSITION,
        BASIC_INFOR,
        CONTACT,
        EXPERIENCES,
        AVATAR;

    }
}

