/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity.provider;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.service.LinkProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizationIdentityProvider
extends IdentityProvider<User> {
    private static final Log LOG = ExoLogger.getLogger((String)"organization");
    private OrganizationService organizationService;
    public static final String NAME = "organization";

    public OrganizationIdentityProvider(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> getAllUserId() {
        try {
            ListAccess allUsers = this.organizationService.getUserHandler().findAllUsers();
            int MAX_USERS = 500;
            User[] users = (User[])allUsers.load(0, allUsers.getSize() >= 500 ? 500 : allUsers.getSize());
            ArrayList<String> userIds = new ArrayList<String>();
            for (User user : users) {
                userIds.add(user.getUserName());
            }
            return userIds;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load all users");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User findByRemoteId(String remoteId) {
        User user;
        try {
            RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)this.organizationService));
            UserHandler userHandler = this.organizationService.getUserHandler();
            user = userHandler.findUserByName(remoteId);
        }
        catch (Exception e) {
            User user2 = null;
            return user2;
        }
        finally {
            RequestLifeCycle.end();
        }
        return user;
    }

    @Override
    public Identity createIdentity(User user) {
        Identity identity = new Identity(NAME, user.getUserName());
        return identity;
    }

    @Override
    public void populateProfile(Profile profile, User user) {
        profile.setProperty("firstName", user.getFirstName());
        profile.setProperty("lastName", user.getLastName());
        profile.setProperty("fullName", user.getFullName());
        profile.setProperty("username", user.getUserName());
        profile.setProperty("email", user.getEmail());
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        LinkProvider lp = (LinkProvider)container.getComponentInstanceOfType(LinkProvider.class);
        profile.setProperty("Url", LinkProvider.getProfileUri(user.getUserName()));
    }

    @Override
    public void onUpdateProfile(Profile profile) {
        Profile.UpdateType updateType = profile.getUpdateType();
        String userName = (String)profile.getProperty("username");
        if (updateType == Profile.UpdateType.BASIC_INFOR) {
            try {
                String firstName = (String)profile.getProperty("firstName");
                String lastName = (String)profile.getProperty("lastName");
                String email = (String)profile.getProperty("email");
                User foundUser = this.organizationService.getUserHandler().findUserByName(userName);
                if (!foundUser.getFirstName().equals(firstName)) {
                    foundUser.setFirstName(firstName);
                }
                if (!foundUser.getLastName().equals(lastName)) {
                    foundUser.setLastName(lastName);
                }
                if (!foundUser.getEmail().equals(email)) {
                    foundUser.setEmail(email);
                }
                this.organizationService.getUserHandler().saveUser(foundUser, true);
            }
            catch (Exception e) {
                LOG.warn((Object)"Failed to update user by profile", (Throwable)e);
            }
        }
    }
}

