/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.pom.config.Utils;
import org.exoplatform.portal.pom.spi.gadget.Gadget;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.PortletBuilder;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceApplicationConfigPlugin;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceApplicationHandler;
import org.exoplatform.social.core.space.spi.SpaceService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSpaceApplicationHandler
implements SpaceApplicationHandler {
    private static final Log LOG = ExoLogger.getLogger(DefaultSpaceApplicationHandler.class);
    public static final String NAME = "classic";
    public static final String SPACE_TEMPLATE_PAGE_ID = "portal::classic::spacetemplate";
    public static final String APPLICATION_CONTAINER = "Application";
    private static final String SPACE_DEFAULT_ICON = "SpaceDefaultIcon";
    private static final String GROUP_ID_PREFERENCE = "{groupId}";
    private static final String MODIFIED_GROUP_ID_PREFERENCE = "{modifiedGroupId}";
    private static final String PAGE_NAME_PREFERENCE = "{pageName}";
    private static final String PAGE_URL_PREFERENCE = "{pageUrl}";
    private static final String SPACE_URL_PREFERENCE = "{spaceUrl}";
    private PortalContainer container = PortalContainer.getInstance();
    private DataStorage dataStorage = null;
    private SpaceService spaceService;
    private static Map<ApplicationCategory, List<Application>> appStoreCache = null;
    private static List<Application> appCache = new ArrayList<Application>();

    public DefaultSpaceApplicationHandler(DataStorage dataStorage) {
        this.dataStorage = dataStorage;
    }

    @Override
    public void initApps(Space space, SpaceApplicationConfigPlugin spaceApplicationConfigPlugin) throws SpaceException {
        try {
            PageNavigation spaceNav = SpaceUtils.createGroupNavigation(space.getGroupId());
            PageNode homeNode = this.createPageNodeFromApplication(space, spaceApplicationConfigPlugin.getHomeApplication(), null, true);
            SpaceService spaceService = this.getSpaceService();
            ArrayList<PageNode> childNodes = homeNode.getChildren();
            if (childNodes == null) {
                childNodes = new ArrayList<PageNode>();
            }
            for (SpaceApplicationConfigPlugin.SpaceApplication spaceApplication : spaceApplicationConfigPlugin.getSpaceApplicationList()) {
                PageNode appNode = this.createPageNodeFromApplication(space, spaceApplication, null, false);
                childNodes.add(appNode);
                spaceService.installApplication(space, spaceApplication.getPortletName());
            }
            spaceNav.addNode(homeNode);
            this.dataStorage.save(spaceNav);
            SpaceUtils.setNavigation(spaceNav);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_INIT_APP, (Throwable)e);
        }
    }

    @Override
    public void deInitApp(Space space) throws SpaceException {
        try {
            String groupId = space.getGroupId();
            PageNavigation spaceNav = SpaceUtils.getGroupNavigation(groupId);
            if (spaceNav == null) {
                return;
            }
            ArrayList spaceNodes = spaceNav.getNodes();
            for (PageNode spaceNode : spaceNodes) {
                String pageId = spaceNode.getPageReference();
                Page page = this.dataStorage.getPage(pageId);
                this.dataStorage.remove(page);
            }
            SpaceUtils.removeGroupNavigation(groupId);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_DEINIT_APP, (Throwable)e);
        }
    }

    @Override
    public void activateApplication(Space space, String appId, String appName) throws SpaceException {
        this.activateApplicationClassic(space, appId, appName);
    }

    @Override
    public void deactiveApplication(Space space, String appId) throws SpaceException {
        this.deactivateApplicationClassic(space, appId);
    }

    @Override
    public void installApplication(Space space, String appId) throws SpaceException {
    }

    @Override
    public void removeApplication(Space space, String appId, String appName) throws SpaceException {
        this.removeApplicationClassic(space, appId, appName);
    }

    @Override
    public void removeApplications(Space space) throws SpaceException {
        try {
            String[] apps = space.getApp().split(",");
            String[] appPart = null;
            for (int i = 0; i < apps.length; ++i) {
                appPart = apps[i].split(":");
                this.removeApplication(space, appPart[0], appPart[1]);
            }
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_APPLICATIONS, (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void activateApplicationClassic(Space space, String appId, String appName) throws SpaceException {
        PageNavigation nav = SpaceUtils.createGroupNavigation(space.getGroupId());
        SpaceApplicationConfigPlugin.SpaceApplication spaceApplication = new SpaceApplicationConfigPlugin.SpaceApplication();
        spaceApplication.setPortletName(appId);
        PageNode pageNode = this.createPageNodeFromApplication(space, spaceApplication, appName, false);
        UIPortal uiPortal = Util.getUIPortal();
        PageNode selectedNode = null;
        try {
            selectedNode = uiPortal.getSelectedNode();
        }
        catch (Exception e2) {
            LOG.warn((Object)"Failed to activateApplicationClassic", (Throwable)e2);
        }
        try {
            PageNode homeNode = SpaceUtils.getHomeNode(nav, space.getUrl());
            if (homeNode == null) {
                throw new Exception("homeNode is null!");
            }
            ArrayList<PageNode> childNodes = homeNode.getChildren();
            if (childNodes == null) {
                childNodes = new ArrayList<PageNode>();
            }
            childNodes.add(pageNode);
            this.dataStorage.save(nav);
            uiPortal.setSelectedNode(selectedNode);
            uiPortal.setSelectedNavigation(nav);
            SpaceUtils.setNavigation(nav);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_ADD_APPLICATION, (Throwable)e);
        }
    }

    private void deactivateApplicationClassic(Space space, String appId) {
    }

    private void removeApplicationClassic(Space space, String appId, String appName) throws SpaceException {
        try {
            String groupId = space.getGroupId();
            PageNavigation nav = this.dataStorage.getPageNavigation("group", groupId);
            if (nav == null) {
                return;
            }
            PageNode homeNode = SpaceUtils.getHomeNode(nav, space.getUrl());
            if (homeNode == null) {
                throw new Exception("homeNode is null!");
            }
            List childNodes = homeNode.getChildren();
            String nodeName = appName;
            PageNode childNode = homeNode.getChild(nodeName);
            if (childNode == null) {
                for (PageNode pageNode : homeNode.getChildren()) {
                    if (!pageNode.getPageReference().contains(appId)) continue;
                    childNode = pageNode;
                    break;
                }
            }
            if (childNode == null) {
                nodeName = space.getDisplayName() + nodeName;
                childNode = homeNode.getChild(nodeName);
            }
            childNodes.remove(childNode);
            this.dataStorage.save(nav);
            SpaceUtils.setNavigation(nav);
            String pageId = childNode.getPageReference();
            Page page = this.dataStorage.getPage(pageId);
            this.dataStorage.remove(page);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_APPLICATION, (Throwable)e);
        }
    }

    private Application getApplication(List<Application> apps, String appId) {
        for (Application app : apps) {
            if (!app.getApplicationName().equals(appId)) continue;
            return app;
        }
        return null;
    }

    private PageNode createPageNodeFromApplication(Space space, SpaceApplicationConfigPlugin.SpaceApplication spaceApplication, String appName, boolean isRoot) throws SpaceException {
        String appId = spaceApplication.getPortletName();
        Application app = this.getApplication(space, appId);
        String contentId = app.getContentId();
        if (contentId == null) {
            contentId = app.getCategoryName() + "/" + app.getApplicationName();
        }
        String appInstanceId = "group#" + space.getGroupId() + ":/" + contentId + "/" + app.getApplicationName() + System.currentTimeMillis();
        org.exoplatform.portal.config.model.Application gadgetApplication = null;
        org.exoplatform.portal.config.model.Application<Portlet> portletApplication = null;
        if (app.getType() == ApplicationType.GADGET) {
            TransientApplicationState gadgetState = new TransientApplicationState(app.getApplicationName());
            gadgetApplication = org.exoplatform.portal.config.model.Application.createGadgetApplication();
            gadgetApplication.setState((ApplicationState)gadgetState);
            gadgetApplication.setAccessPermissions(new String[]{"*:" + space.getGroupId()});
            gadgetApplication.setShowInfoBar(false);
        } else {
            portletApplication = this.createPortletApplication(appInstanceId, space, isRoot);
            portletApplication.setAccessPermissions(new String[]{"*:" + space.getGroupId()});
            portletApplication.setShowInfoBar(false);
        }
        String pageTitle = space.getDisplayName() + " - " + app.getDisplayName();
        String pageName = app.getApplicationName();
        if (SpaceUtils.isInstalledApp(space, appId) && appName != null) {
            pageName = appName;
        }
        UserPortalConfigService userPortalConfigService = this.getUserPortalConfigService();
        Page page = null;
        try {
            page = userPortalConfigService.createPageTemplate("space", "group", space.getGroupId());
            page.setName(pageName);
            page.setTitle(pageTitle);
            page.setModifiable(true);
            this.dataStorage.create(page);
            page = this.dataStorage.getPage(page.getPageId());
            this.setPage(space, app, (org.exoplatform.portal.config.model.Application<Gadget>)gadgetApplication, portletApplication, page);
            this.dataStorage.save(page);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        PageNode pageNode = new PageNode();
        String label = SpaceUtils.getDisplayAppName(app.getDisplayName());
        if (spaceApplication.getAppTitle() != null && !spaceApplication.getAppTitle().isEmpty()) {
            label = spaceApplication.getAppTitle();
        }
        if (isRoot) {
            pageName = space.getUrl();
            label = space.getDisplayName();
            pageNode.setUri(pageName);
        } else {
            if (spaceApplication.getUri() != null && !spaceApplication.getUri().isEmpty()) {
                pageName = spaceApplication.getUri();
            }
            pageNode.setUri(space.getUrl() + "/" + pageName);
        }
        pageNode.setName(pageName);
        if (spaceApplication.getIcon() != null && !spaceApplication.getIcon().isEmpty()) {
            pageNode.setIcon(spaceApplication.getIcon());
        }
        pageNode.setLabel(label);
        pageNode.setPageReference(page.getPageId());
        pageNode.setModifiable(true);
        return pageNode;
    }

    private Application getApplication(Space space, String appId) throws SpaceException {
        Application app = this.getApplication(appCache, appId);
        if (app == null) {
            try {
                if (appStoreCache == null) {
                    appStoreCache = SpaceUtils.getAppStore(space);
                }
                if ((app = this.getApplication(appStoreCache, appId)) == null && (app = this.getApplication(appStoreCache = SpaceUtils.getAppStore(space), appId)) == null && (app = SpaceUtils.getAppFromPortalContainer(appId)) == null) {
                    throw new Exception("app is null!");
                }
                appCache.add(app);
            }
            catch (Exception e) {
                throw new SpaceException(SpaceException.Code.UNABLE_TO_LIST_AVAILABLE_APPLICATIONS, (Throwable)e);
            }
        }
        return app;
    }

    private void setPage(Space space, Application app, org.exoplatform.portal.config.model.Application<Gadget> gadgetApplication, org.exoplatform.portal.config.model.Application<Portlet> portletApplication, Page page) {
        String visibility = space.getVisibility();
        if (visibility.equals("public")) {
            page.setAccessPermissions(new String[]{"Everyone"});
        } else {
            page.setAccessPermissions(new String[]{"*:" + space.getGroupId()});
        }
        page.setEditPermission("manager:" + space.getGroupId());
        ArrayList<ModelObject> pageChilds = page.getChildren();
        Container menuContainer = SpaceUtils.findContainerById(pageChilds, "Menu");
        org.exoplatform.portal.config.model.Application menuPortlet = (org.exoplatform.portal.config.model.Application)menuContainer.getChildren().get(0);
        ApplicationState state = menuPortlet.getState();
        try {
            Portlet portletPreference = (Portlet)this.dataStorage.load(state, ApplicationType.PORTLET);
            if (portletPreference == null) {
                portletPreference = new PortletBuilder().add("SPACE_URL", space.getUrl()).build();
            } else {
                portletPreference.setValue("SPACE_URL", space.getUrl());
            }
            this.dataStorage.save(state, (Object)portletPreference);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to setPage", (Throwable)e);
        }
        Container container = SpaceUtils.findContainerById(pageChilds, APPLICATION_CONTAINER);
        ArrayList children = container.getChildren();
        if (app.getType() == ApplicationType.GADGET) {
            children.add(gadgetApplication);
        } else {
            children.add(portletApplication);
        }
        container.setChildren(children);
        pageChilds = this.setContainerById(pageChilds, container);
        page.setChildren(pageChilds);
        this.setPermissionForPage(page.getChildren(), "*:" + space.getGroupId());
    }

    private Application getApplication(Map<ApplicationCategory, List<Application>> appStore, String appId) {
        for (ApplicationCategory category : appStore.keySet()) {
            List appList = category.getApplications();
            for (Application app : appList) {
                if (!app.getApplicationName().equals(appId)) continue;
                return app;
            }
        }
        return null;
    }

    private void setPermissionForPage(ArrayList<ModelObject> children, String perm) {
        for (ModelObject modelObject : children) {
            if (modelObject instanceof org.exoplatform.portal.config.model.Application) {
                ((org.exoplatform.portal.config.model.Application)modelObject).setAccessPermissions(new String[]{perm});
                continue;
            }
            if (!(modelObject instanceof Container)) continue;
            ((Container)modelObject).setAccessPermissions(new String[]{perm});
            this.setPermissionForPage(((Container)modelObject).getChildren(), perm);
        }
    }

    private ArrayList<ModelObject> setContainerById(ArrayList<ModelObject> childs, Container container) {
        ArrayList<ModelObject> result = childs;
        int index = result.indexOf(container);
        if (index != -1) {
            result.set(index, (ModelObject)container);
        } else {
            for (int i = 0; i < result.size(); ++i) {
                ModelObject obj = result.get(i);
                if (org.exoplatform.portal.config.model.Application.class.isInstance(obj)) continue;
                Container objContainer = (Container)obj;
                ArrayList<ModelObject> tmp = this.setContainerById(objContainer.getChildren(), container);
                objContainer.setChildren(tmp);
                result.set(i, (ModelObject)objContainer);
            }
        }
        return result;
    }

    private org.exoplatform.portal.config.model.Application<Portlet> createPortletApplication(String instanceId, Space space, boolean isRoot) {
        String[] appNames;
        int i0 = instanceId.indexOf("#");
        int i1 = instanceId.indexOf(":/", i0 + 1);
        String ownerType = instanceId.substring(0, i0);
        String ownerId = instanceId.substring(i0 + 1, i1);
        String persistenceid = instanceId.substring(i1 + 2);
        String[] persistenceChunks = Utils.split((String)"/", (String)persistenceid);
        PortletBuilder pb = new PortletBuilder();
        SpaceService spaceSrv = this.getSpaceService();
        for (String appName : appNames = spaceSrv.getPortletsPrefsRequired()) {
            if (!instanceId.contains(appName)) continue;
            pb.add("SPACE_URL", space.getUrl());
            break;
        }
        List<SpaceApplicationConfigPlugin.SpaceApplication> spaceApplicationList = this.spaceService.getSpaceApplicationConfigPlugin().getSpaceApplicationList();
        SpaceApplicationConfigPlugin.SpaceApplication spaceApplication = null;
        Iterator<SpaceApplicationConfigPlugin.SpaceApplication> iterator = spaceApplicationList.iterator();
        while (iterator.hasNext() && spaceApplication == null) {
            SpaceApplicationConfigPlugin.SpaceApplication tmpSpaceApplication = iterator.next();
            if (!instanceId.contains(tmpSpaceApplication.getPortletName())) continue;
            spaceApplication = tmpSpaceApplication;
        }
        if (spaceApplication != null && spaceApplication.getPreferences() != null) {
            Set<Map.Entry<String, String>> entrySet = spaceApplication.getPreferences().entrySet();
            try {
                for (Map.Entry<String, String> preference : entrySet) {
                    pb.add(preference.getKey(), this.getSubstituteValueFromPattern(space, spaceApplication, preference.getValue()));
                }
            }
            catch (Exception exception) {
                LOG.warn((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        TransientApplicationState portletState = new TransientApplicationState(persistenceChunks[0] + "/" + persistenceChunks[1], (Object)pb.build(), ownerType, ownerId, persistenceChunks[2]);
        org.exoplatform.portal.config.model.Application portletApp = org.exoplatform.portal.config.model.Application.createPortletApplication();
        portletApp.setState((ApplicationState)portletState);
        return portletApp;
    }

    private String getSubstituteValueFromPattern(Space space, SpaceApplicationConfigPlugin.SpaceApplication spaceApplication, String pattern) {
        if (!pattern.contains("{") || !pattern.contains("}")) {
            return pattern;
        }
        if (pattern.contains(SPACE_URL_PREFERENCE)) {
            pattern = pattern.replace(SPACE_URL_PREFERENCE, space.getUrl());
        } else if (pattern.contains(GROUP_ID_PREFERENCE)) {
            pattern = pattern.replace(GROUP_ID_PREFERENCE, space.getGroupId());
        } else if (pattern.contains(MODIFIED_GROUP_ID_PREFERENCE)) {
            String modifiedGroupId = space.getGroupId().replace("/", ".");
            pattern = pattern.replace(MODIFIED_GROUP_ID_PREFERENCE, modifiedGroupId);
        } else if (pattern.contains(PAGE_NAME_PREFERENCE)) {
            pattern = pattern.replace(PAGE_NAME_PREFERENCE, spaceApplication.getAppTitle());
        } else if (pattern.contains(PAGE_URL_PREFERENCE)) {
            pattern = pattern.replace(PAGE_URL_PREFERENCE, spaceApplication.getUri());
        }
        return pattern;
    }

    private UserPortalConfigService getUserPortalConfigService() {
        return (UserPortalConfigService)this.container.getComponentInstanceOfType(UserPortalConfigService.class);
    }

    private SpaceService getSpaceService() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)container.getComponentInstance(SpaceService.class);
        }
        return this.spaceService;
    }
}

