/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.application.PortletPreferenceRequiredPlugin;
import org.exoplatform.social.core.space.SpaceApplicationConfigPlugin;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceLifecycle;
import org.exoplatform.social.core.space.SpaceListAccess;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.impl.DefaultSpaceApplicationHandler;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceApplicationHandler;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleListener;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.SpaceStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceServiceImpl
implements SpaceService {
    private static final Log LOG = ExoLogger.getLogger((String)SpaceServiceImpl.class.getName());
    public static final String MEMBER = "member";
    public static final String MANAGER = "manager";
    private SpaceStorage storage;
    private OrganizationService orgService = null;
    private UserACL userACL = null;
    private Map<String, SpaceApplicationHandler> spaceApplicationHandlers = null;
    private SpaceLifecycle spaceLifeCycle = new SpaceLifecycle();
    List<String> portletPrefsRequired = null;
    private SpaceApplicationConfigPlugin spaceApplicationConfigPlugin;
    private static final int OFFSET = 0;
    private static final int LIMIT = 200;

    public SpaceServiceImpl(InitParams params, SpaceStorage spaceStorage) throws Exception {
        this.storage = spaceStorage;
        if (params != null) {
            LOG.warn((Object)"The SpaceService configuration you attempt to use is deprecated, please update it byusing external-component-plugins configuration");
            this.spaceApplicationConfigPlugin = new SpaceApplicationConfigPlugin();
            Iterator it = params.getValuesParamIterator();
            while (it.hasNext()) {
                ValuesParam param = (ValuesParam)it.next();
                String name = param.getName();
                if (name.endsWith("homeNodeApp")) {
                    String homeNodeApp = param.getValue();
                    SpaceApplicationConfigPlugin.SpaceApplication spaceHomeApplication = new SpaceApplicationConfigPlugin.SpaceApplication();
                    spaceHomeApplication.setPortletName(homeNodeApp);
                    spaceHomeApplication.setAppTitle(homeNodeApp);
                    spaceHomeApplication.setIcon("SpaceHomeIcon");
                    this.spaceApplicationConfigPlugin.setHomeApplication(spaceHomeApplication);
                }
                if (!name.endsWith("apps")) continue;
                ArrayList apps = param.getValues();
                for (String app : apps) {
                    boolean isRemovable;
                    String appName;
                    String[] splitedString = app.trim().split(":");
                    if (splitedString.length >= 2) {
                        appName = splitedString[0];
                        isRemovable = Boolean.getBoolean(splitedString[1]);
                    } else {
                        appName = app;
                        isRemovable = false;
                    }
                    SpaceApplicationConfigPlugin.SpaceApplication spaceApplication = new SpaceApplicationConfigPlugin.SpaceApplication();
                    spaceApplication.setPortletName(appName);
                    spaceApplication.isRemovable(isRemovable);
                    this.spaceApplicationConfigPlugin.addToSpaceApplicationList(spaceApplication);
                }
            }
        }
    }

    @Override
    public List<Space> getAllSpaces() throws SpaceException {
        try {
            return Arrays.asList(this.getAllSpacesWithListAccess().load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    @Override
    public ListAccess<Space> getAllSpacesWithListAccess() {
        return new SpaceListAccess(this.storage, SpaceListAccess.Type.ALL);
    }

    @Override
    public Space getSpaceByDisplayName(String spaceDisplayName) {
        return this.storage.getSpaceByDisplayName(spaceDisplayName);
    }

    @Override
    public Space getSpaceByName(String spaceName) {
        return this.getSpaceByPrettyName(spaceName);
    }

    @Override
    public Space getSpaceByPrettyName(String spacePrettyName) {
        return this.storage.getSpaceByPrettyName(spacePrettyName);
    }

    @Override
    public List<Space> getSpacesByFirstCharacterOfName(String firstCharacterOfName) throws SpaceException {
        try {
            return Arrays.asList(this.getAllSpacesByFilter(new SpaceFilter(firstCharacterOfName.charAt(0))).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    @Override
    public List<Space> getSpacesBySearchCondition(String searchCondition) throws SpaceException {
        try {
            return Arrays.asList(this.getAllSpacesByFilter(new SpaceFilter(searchCondition)).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    @Override
    public Space getSpaceByGroupId(String groupId) {
        return this.storage.getSpaceByGroupId(groupId);
    }

    @Override
    public Space getSpaceById(String id) {
        return this.storage.getSpaceById(id);
    }

    @Override
    public Space getSpaceByUrl(String url) {
        return this.storage.getSpaceByUrl(url);
    }

    @Override
    public List<Space> getSpaces(String userId) throws SpaceException {
        try {
            return Arrays.asList(this.getMemberSpaces(userId).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    @Override
    public List<Space> getAccessibleSpaces(String userId) throws SpaceException {
        try {
            return Arrays.asList(this.getAccessibleSpacesWithListAccess(userId).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    public SpaceListAccess getAccessibleSpacesWithListAccess(String userId) {
        if (userId.equals(this.getUserACL().getSuperUser())) {
            return new SpaceListAccess(this.storage, SpaceListAccess.Type.ALL);
        }
        return new SpaceListAccess(this.storage, userId, SpaceListAccess.Type.ACCESSIBLE);
    }

    @Override
    public List<Space> getEditableSpaces(String userId) throws SpaceException {
        try {
            return Arrays.asList(this.getSettingableSpaces(userId).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    @Override
    public List<Space> getInvitedSpaces(String userId) throws SpaceException {
        try {
            return Arrays.asList(this.getInvitedSpacesWithListAccess(userId).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    @Override
    public List<Space> getPublicSpaces(String userId) throws SpaceException {
        try {
            return Arrays.asList(this.getPublicSpacesWithListAccess(userId).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    public SpaceListAccess getPublicSpacesWithListAccess(String userId) {
        if (userId.equals(this.getUserACL().getSuperUser())) {
            return new SpaceListAccess(this.storage, SpaceListAccess.Type.PUBLIC_SUPER_USER);
        }
        return new SpaceListAccess(this.storage, userId, SpaceListAccess.Type.PUBLIC);
    }

    @Override
    public List<Space> getPendingSpaces(String userId) throws SpaceException {
        try {
            return Arrays.asList(this.getPendingSpacesWithListAccess(userId).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    public SpaceListAccess getPendingSpacesWithListAccess(String userId) {
        return new SpaceListAccess(this.storage, userId, SpaceListAccess.Type.PENDING);
    }

    @Override
    public Space createSpace(Space space, String creator) {
        return this.createSpace(space, creator, null);
    }

    @Override
    public Space createSpace(Space space, String creator, String invitedGroupId) {
        String groupId = null;
        try {
            groupId = SpaceUtils.createGroup(space.getDisplayName(), creator);
        }
        catch (SpaceException e) {
            LOG.error((Object)"Error while creating group", (Throwable)e);
        }
        if (invitedGroupId != null) {
            OrganizationService org = this.getOrgService();
            try {
                PageList groupMembersAccess = org.getUserHandler().findUsersByGroup(invitedGroupId);
                List users = groupMembersAccess.getAll();
                for (User user : users) {
                    Object[] invitedUsers;
                    String userId = user.getUserName();
                    if (userId.equals(creator) || ArrayUtils.contains((Object[])(invitedUsers = space.getInvitedUsers()), (Object)userId)) continue;
                    invitedUsers = (String[])ArrayUtils.add((Object[])invitedUsers, (Object)userId);
                    space.setInvitedUsers((String[])invitedUsers);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to invite users from group " + invitedGroupId), (Throwable)e);
            }
        }
        String[] managers = new String[]{creator};
        String[] members = new String[]{creator};
        space.setManagers(managers);
        space.setMembers(members);
        space.setCreator(creator);
        space.setGroupId(groupId);
        space.setUrl(space.getPrettyName());
        this.saveSpace(space, true);
        this.spaceLifeCycle.spaceCreated(space, creator);
        try {
            SpaceApplicationHandler spaceApplicationHandler = this.getSpaceApplicationHandler(space);
            spaceApplicationHandler.initApps(space, this.getSpaceApplicationConfigPlugin());
            for (SpaceApplicationConfigPlugin.SpaceApplication spaceApplication : this.getSpaceApplicationConfigPlugin().getSpaceApplicationList()) {
                this.setApp(space, spaceApplication.getPortletName(), spaceApplication.getAppTitle(), spaceApplication.isRemovable(), "active");
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to init apps", (Throwable)e);
        }
        return space;
    }

    @Override
    public void saveSpace(Space space, boolean isNew) {
        this.storage.saveSpace(space, isNew);
    }

    @Override
    public void deleteSpace(Space space) {
        try {
            this.storage.deleteSpace(space.getId());
            OrganizationService orgService = this.getOrgService();
            UserACL acl = this.getUserACL();
            GroupHandler groupHandler = orgService.getGroupHandler();
            Group deletedGroup = groupHandler.findGroupById(space.getGroupId());
            List mandatories = acl.getMandatoryGroups();
            if (deletedGroup != null) {
                if (!this.isMandatory(groupHandler, deletedGroup, mandatories)) {
                    SpaceUtils.removeGroup(space);
                }
            } else {
                LOG.warn((Object)"deletedGroup is null");
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unable delete space", (Throwable)e);
        }
        this.spaceLifeCycle.spaceRemoved(space, null);
    }

    @Override
    public void deleteSpace(String spaceId) {
        this.deleteSpace(this.getSpaceById(spaceId));
    }

    @Override
    public void initApp(Space space) throws SpaceException {
        LOG.warn((Object)"Does nothing, just for compatible. It will be removed at 1.3.x");
    }

    @Override
    public void initApps(Space space) throws SpaceException {
        LOG.warn((Object)"Does nothing, just for compatible. It will be removed at 1.3.x");
    }

    @Override
    public void deInitApps(Space space) throws SpaceException {
        LOG.warn((Object)"Does nothing, just for compatible. It will be removed at 1.3.x");
    }

    @Override
    public void addMember(Space space, String userId) {
        Object[] members = space.getMembers();
        space = this.removeInvited(space, userId);
        space = this.removePending(space, userId);
        if (!ArrayUtils.contains((Object[])members, (Object)userId)) {
            members = (String[])ArrayUtils.add((Object[])members, (Object)userId);
            space.setMembers((String[])members);
            SpaceUtils.addUserToGroupWithMemberMembership(userId, space.getGroupId());
            this.updateSpace(space);
            this.spaceLifeCycle.memberJoined(space, userId);
        }
    }

    @Override
    public void addMember(String spaceId, String userId) {
        this.addMember(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void removeMember(Space space, String userId) {
        Object[] members = space.getMembers();
        if (ArrayUtils.contains((Object[])members, (Object)userId)) {
            members = (String[])ArrayUtils.removeElement((Object[])members, (Object)userId);
            SpaceUtils.removeUserFromGroupWithMemberMembership(userId, space.getGroupId());
            space.setMembers((String[])members);
            this.updateSpace(space);
            this.spaceLifeCycle.memberLeft(space, userId);
        }
    }

    @Override
    public void removeMember(String spaceId, String userId) {
        this.removeMember(this.getSpaceById(spaceId), userId);
    }

    private Space addPending(Space space, String userId) {
        Object[] pendingUsers = space.getPendingUsers();
        if (!ArrayUtils.contains((Object[])pendingUsers, (Object)userId)) {
            pendingUsers = (String[])ArrayUtils.add((Object[])pendingUsers, (Object)userId);
            space.setPendingUsers((String[])pendingUsers);
        }
        return space;
    }

    private Space removePending(Space space, String userId) {
        Object[] pendingUsers = space.getPendingUsers();
        if (ArrayUtils.contains((Object[])pendingUsers, (Object)userId)) {
            pendingUsers = (String[])ArrayUtils.removeElement((Object[])pendingUsers, (Object)userId);
            space.setPendingUsers((String[])pendingUsers);
        }
        return space;
    }

    private Space addInvited(Space space, String userId) {
        Object[] invitedUsers = space.getInvitedUsers();
        if (!ArrayUtils.contains((Object[])invitedUsers, (Object)userId)) {
            invitedUsers = (String[])ArrayUtils.add((Object[])invitedUsers, (Object)userId);
            space.setInvitedUsers((String[])invitedUsers);
        }
        return space;
    }

    private Space removeInvited(Space space, String userId) {
        Object[] invitedUsers = space.getInvitedUsers();
        if (ArrayUtils.contains((Object[])invitedUsers, (Object)userId)) {
            invitedUsers = (String[])ArrayUtils.removeElement((Object[])invitedUsers, (Object)userId);
            space.setInvitedUsers((String[])invitedUsers);
        }
        return space;
    }

    @Override
    public List<String> getMembers(Space space) {
        if (space.getMembers() != null) {
            return Arrays.asList(space.getMembers());
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> getMembers(String spaceId) {
        return this.getMembers(this.getSpaceById(spaceId));
    }

    @Override
    public void setLeader(Space space, String userId, boolean isLeader) {
        this.setManager(space, userId, isLeader);
    }

    @Override
    public void setLeader(String spaceId, String userId, boolean isLeader) {
        this.setManager(this.getSpaceById(spaceId), userId, isLeader);
    }

    @Override
    public boolean isLeader(Space space, String userId) {
        return this.isManager(space, userId);
    }

    @Override
    public boolean isLeader(String spaceId, String userId) {
        return this.isManager(this.getSpaceById(spaceId), userId);
    }

    @Override
    public boolean isOnlyLeader(Space space, String userId) {
        return this.isOnlyManager(space, userId);
    }

    @Override
    public boolean isOnlyLeader(String spaceId, String userId) {
        return this.isOnlyManager(this.getSpaceById(spaceId), userId);
    }

    @Override
    public boolean isMember(Space space, String userId) {
        return ArrayUtils.contains((Object[])space.getMembers(), (Object)userId);
    }

    @Override
    public boolean isMember(String spaceId, String userId) {
        return this.isMember(this.getSpaceById(spaceId), userId);
    }

    @Override
    public boolean hasAccessPermission(Space space, String userId) {
        return userId.equals(this.getUserACL().getSuperUser()) || ArrayUtils.contains((Object[])space.getMembers(), (Object)userId) || ArrayUtils.contains((Object[])space.getManagers(), (Object)userId);
    }

    @Override
    public boolean hasAccessPermission(String spaceId, String userId) {
        return this.hasAccessPermission(this.getSpaceById(spaceId), userId);
    }

    @Override
    public boolean hasEditPermission(Space space, String userId) {
        return this.hasSettingPermission(space, userId);
    }

    @Override
    public boolean hasEditPermission(String spaceId, String userId) {
        return this.hasSettingPermission(this.getSpaceById(spaceId), userId);
    }

    @Override
    public boolean isInvited(Space space, String userId) {
        return this.isInvitedUser(space, userId);
    }

    @Override
    public boolean isInvited(String spaceId, String userId) {
        return this.isInvitedUser(this.getSpaceById(spaceId), userId);
    }

    @Override
    public boolean isPending(Space space, String userId) {
        return this.isPendingUser(space, userId);
    }

    @Override
    public boolean isPending(String spaceId, String userId) {
        return this.isPendingUser(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void installApplication(String spaceId, String appId) throws SpaceException {
        this.installApplication(this.getSpaceById(spaceId), appId);
    }

    @Override
    public void installApplication(Space space, String appId) throws SpaceException {
        this.spaceLifeCycle.addApplication(space, appId);
    }

    @Override
    public void activateApplication(Space space, String appId) throws SpaceException {
        String appName = null;
        appName = SpaceUtils.isInstalledApp(space, appId) ? appId + System.currentTimeMillis() : appId;
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
        this.setApp(space, appId, appName, SpaceUtils.isRemovableApp(space, appId), "active");
        appHandler.activateApplication(space, appId, appName);
        this.spaceLifeCycle.activateApplication(space, appId);
    }

    @Override
    public void activateApplication(String spaceId, String appId) throws SpaceException {
        this.activateApplication(this.getSpaceById(spaceId), appId);
    }

    @Override
    public void deactivateApplication(Space space, String appId) throws SpaceException {
        String appStatus = SpaceUtils.getAppStatus(space, appId);
        if (appStatus == null) {
            LOG.warn((Object)"appStatus is null!");
            return;
        }
        if (appStatus.equals("deactive")) {
            return;
        }
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
        appHandler.deactiveApplication(space, appId);
        this.setApp(space, appId, appId, SpaceUtils.isRemovableApp(space, appId), "deactive");
        this.spaceLifeCycle.deactivateApplication(space, appId);
    }

    @Override
    public void deactivateApplication(String spaceId, String appId) throws SpaceException {
        this.deactivateApplication(this.getSpaceById(spaceId), appId);
    }

    @Override
    public void removeApplication(Space space, String appId, String appName) throws SpaceException {
        String appStatus = SpaceUtils.getAppStatus(space, appId);
        if (appStatus == null) {
            return;
        }
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
        appHandler.removeApplication(space, appId, appName);
        this.removeApp(space, appId, appName);
        this.spaceLifeCycle.removeApplication(space, appId);
    }

    @Override
    public void removeApplication(String spaceId, String appId, String appName) throws SpaceException {
        this.removeApplication(this.getSpaceById(spaceId), appId, appName);
    }

    @Override
    public void requestJoin(String spaceId, String userId) {
        this.addPendingUser(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void requestJoin(Space space, String userId) {
        this.addPendingUser(space, userId);
    }

    @Override
    public void revokeRequestJoin(Space space, String userId) {
        this.removePendingUser(space, userId);
    }

    @Override
    public void revokeRequestJoin(String spaceId, String userId) {
        this.removePending(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void inviteMember(Space space, String userId) {
        this.addInvitedUser(space, userId);
    }

    @Override
    public void inviteMember(String spaceId, String userId) {
        this.addInvitedUser(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void revokeInvitation(Space space, String userId) {
        this.removeInvitedUser(space, userId);
    }

    @Override
    public void revokeInvitation(String spaceId, String userId) {
        this.removeInvitedUser(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void acceptInvitation(Space space, String userId) throws SpaceException {
        this.addMember(space, userId);
    }

    @Override
    public void acceptInvitation(String spaceId, String userId) throws SpaceException {
        this.addMember(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void denyInvitation(String spaceId, String userId) {
        this.removeInvitedUser(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void denyInvitation(Space space, String userId) {
        this.removeInvitedUser(space, userId);
    }

    @Override
    public void validateRequest(Space space, String userId) {
        this.addMember(space, userId);
    }

    @Override
    public void validateRequest(String spaceId, String userId) {
        this.addMember(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void declineRequest(Space space, String userId) {
        this.removePendingUser(space, userId);
    }

    @Override
    public void declineRequest(String spaceId, String userId) {
        this.removePendingUser(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void registerSpaceLifeCycleListener(SpaceLifeCycleListener listener) {
        this.spaceLifeCycle.addListener(listener);
    }

    @Override
    public void unregisterSpaceLifeCycleListener(SpaceLifeCycleListener listener) {
        this.spaceLifeCycle.removeListener(listener);
    }

    public void addSpaceListener(SpaceListenerPlugin plugin) {
        this.registerSpaceLifeCycleListener(plugin);
    }

    @Override
    public void setPortletsPrefsRequired(PortletPreferenceRequiredPlugin portletPrefsRequiredPlugin) {
        List<String> portletPrefs = portletPrefsRequiredPlugin.getPortletPrefs();
        if (this.portletPrefsRequired == null) {
            this.portletPrefsRequired = new ArrayList<String>();
        }
        this.portletPrefsRequired.addAll(portletPrefs);
    }

    @Override
    public String[] getPortletsPrefsRequired() {
        return this.portletPrefsRequired.toArray(new String[this.portletPrefsRequired.size()]);
    }

    @Override
    public void setSpaceApplicationConfigPlugin(SpaceApplicationConfigPlugin spaceApplicationConfigPlugin) {
        if (spaceApplicationConfigPlugin.getHomeApplication() == null) {
            spaceApplicationConfigPlugin.setHomeApplication(spaceApplicationConfigPlugin.getHomeApplication());
        }
        this.spaceApplicationConfigPlugin = spaceApplicationConfigPlugin;
    }

    @Override
    public SpaceApplicationConfigPlugin getSpaceApplicationConfigPlugin() {
        return this.spaceApplicationConfigPlugin;
    }

    private OrganizationService getOrgService() {
        if (this.orgService == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.orgService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        }
        return this.orgService;
    }

    private UserACL getUserACL() {
        if (this.userACL == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            return (UserACL)container.getComponentInstanceOfType(UserACL.class);
        }
        return this.userACL;
    }

    private Map<String, SpaceApplicationHandler> getSpaceApplicationHandlers() {
        if (this.spaceApplicationHandlers == null) {
            this.spaceApplicationHandlers = new HashMap<String, SpaceApplicationHandler>();
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            DefaultSpaceApplicationHandler appHandler = (DefaultSpaceApplicationHandler)container.getComponentInstanceOfType(DefaultSpaceApplicationHandler.class);
            this.spaceApplicationHandlers.put(appHandler.getName(), appHandler);
        }
        return this.spaceApplicationHandlers;
    }

    private SpaceApplicationHandler getSpaceApplicationHandler(Space space) throws SpaceException {
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandlers().get(space.getType());
        if (appHandler == null) {
            throw new SpaceException(SpaceException.Code.UNKNOWN_SPACE_TYPE);
        }
        return appHandler;
    }

    public void setApp(Space space, String appId, String appName, boolean isRemovable, String status) throws SpaceException {
        String apps = space.getApp();
        String applicationStatus = appId + ":" + appName;
        applicationStatus = isRemovable ? applicationStatus + ":true" : applicationStatus + ":false";
        applicationStatus = applicationStatus + ":" + status;
        apps = apps == null ? applicationStatus : apps + "," + applicationStatus;
        space.setApp(apps);
        this.saveSpace(space, false);
    }

    private void removeApp(Space space, String appId, String appName) throws SpaceException {
        String apps = space.getApp();
        StringBuffer remainApp = new StringBuffer();
        String[] listApp = apps.split(",");
        for (int idx = 0; idx < listApp.length; ++idx) {
            String app = listApp[idx];
            String[] appPart = app.split(":");
            if (appPart[1].equals(appName)) continue;
            if (remainApp.length() != 0) {
                remainApp.append(",");
            }
            remainApp.append(app);
        }
        space.setApp(remainApp.toString());
        this.saveSpace(space, false);
    }

    private boolean isMandatory(GroupHandler groupHandler, Group group, List<String> mandatories) throws Exception {
        if (mandatories.contains(group.getId())) {
            return true;
        }
        Collection children = groupHandler.findGroups(group);
        for (Group g : children) {
            if (!this.isMandatory(groupHandler, g, mandatories)) continue;
            return true;
        }
        return false;
    }

    public SpaceStorage getStorage() {
        return this.storage;
    }

    public void setStorage(SpaceStorage storage) {
        this.storage = storage;
    }

    @Override
    public void addInvitedUser(Space space, String userId) {
        if (ArrayUtils.contains((Object[])space.getInvitedUsers(), (Object)userId)) {
            LOG.warn((Object)"User already invited");
            return;
        }
        if (ArrayUtils.contains((Object[])space.getMembers(), (Object)userId) && !userId.equals(this.getUserACL().getSuperUser())) {
            LOG.warn((Object)"User already member");
            return;
        }
        if (this.isPending(space, userId)) {
            space = this.removePending(space, userId);
            this.addMember(space, userId);
        } else {
            space = this.addInvited(space, userId);
        }
        this.updateSpace(space);
    }

    @Override
    public void addPendingUser(Space space, String userId) {
        if (ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)userId)) {
            this.addMember(space, userId);
            space = this.removeInvited(space, userId);
            this.updateSpace(space);
            return;
        }
        String registration = space.getRegistration();
        String visibility = space.getVisibility();
        if (visibility.equals("hidden")) {
            LOG.warn((Object)"Unable request to join hidden");
            return;
        }
        if (registration.equals("open")) {
            this.addMember(space, userId);
        } else if (registration.equals("validation")) {
            space = this.addPending(space, userId);
            this.saveSpace(space, false);
        } else {
            LOG.warn((Object)"Unable request to join");
        }
    }

    @Override
    public ListAccess<Space> getAccessibleSpacesByFilter(String userId, SpaceFilter spaceFilter) {
        if (userId.equals(this.getUserACL().getSuperUser())) {
            return new SpaceListAccess(this.storage, spaceFilter, SpaceListAccess.Type.ALL_FILTER);
        }
        return new SpaceListAccess(this.storage, userId, spaceFilter, SpaceListAccess.Type.ACCESSIBLE_FILTER);
    }

    @Override
    public ListAccess<Space> getAllSpacesByFilter(SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.storage, spaceFilter, SpaceListAccess.Type.ALL_FILTER);
    }

    @Override
    public ListAccess<Space> getInvitedSpacesByFilter(String userId, SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.storage, userId, spaceFilter, SpaceListAccess.Type.INVITED_FILTER);
    }

    @Override
    public ListAccess<Space> getMemberSpaces(String userId) {
        return new SpaceListAccess(this.storage, userId, SpaceListAccess.Type.MEMBER);
    }

    @Override
    public ListAccess<Space> getMemberSpacesByFilter(String userId, SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.storage, userId, spaceFilter, SpaceListAccess.Type.MEMBER_FILTER);
    }

    @Override
    public ListAccess<Space> getPendingSpacesByFilter(String userId, SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.storage, userId, spaceFilter, SpaceListAccess.Type.PENDING_FILTER);
    }

    @Override
    public ListAccess<Space> getPublicSpacesByFilter(String userId, SpaceFilter spaceFilter) {
        if (userId.equals(this.getUserACL().getSuperUser())) {
            return new SpaceListAccess(this.storage, SpaceListAccess.Type.PUBLIC_SUPER_USER);
        }
        return new SpaceListAccess(this.storage, userId, spaceFilter, SpaceListAccess.Type.PUBLIC_FILTER);
    }

    @Override
    public ListAccess<Space> getSettingableSpaces(String userId) {
        if (userId.equals(this.getUserACL().getSuperUser())) {
            return new SpaceListAccess(this.storage, SpaceListAccess.Type.ALL);
        }
        return new SpaceListAccess(this.storage, userId, SpaceListAccess.Type.SETTING);
    }

    @Override
    public ListAccess<Space> getSettingabledSpacesByFilter(String userId, SpaceFilter spaceFilter) {
        if (userId.equals(this.getUserACL().getSuperUser())) {
            return new SpaceListAccess(this.storage, spaceFilter, SpaceListAccess.Type.ALL_FILTER);
        }
        return new SpaceListAccess(this.storage, userId, spaceFilter, SpaceListAccess.Type.SETTING_FILTER);
    }

    @Override
    public boolean hasSettingPermission(Space space, String userId) {
        return userId.equals(this.getUserACL().getSuperUser()) || ArrayUtils.contains((Object[])space.getManagers(), (Object)userId);
    }

    @Override
    public boolean isInvitedUser(Space space, String userId) {
        return ArrayUtils.contains((Object[])space.getInvitedUsers(), (Object)userId);
    }

    @Override
    public boolean isManager(Space space, String userId) {
        return ArrayUtils.contains((Object[])space.getManagers(), (Object)userId);
    }

    @Override
    public boolean isOnlyManager(Space space, String userId) {
        return space.getManagers() != null && space.getManagers().length == 1 && ArrayUtils.contains((Object[])space.getManagers(), (Object)userId);
    }

    @Override
    public boolean isPendingUser(Space space, String userId) {
        return ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)userId);
    }

    @Override
    public void registerSpaceListenerPlugin(SpaceListenerPlugin spaceListenerPlugin) {
        this.spaceLifeCycle.addListener(spaceListenerPlugin);
    }

    @Override
    public void removeInvitedUser(Space space, String userId) {
        if (ArrayUtils.contains((Object[])space.getInvitedUsers(), (Object)userId)) {
            space = this.removeInvited(space, userId);
            this.updateSpace(space);
        }
    }

    @Override
    public void removePendingUser(Space space, String userId) {
        if (ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)userId)) {
            space = this.removePending(space, userId);
            this.updateSpace(space);
        }
    }

    @Override
    public void setManager(Space space, String userId, boolean isManager) {
        Object[] managers = space.getManagers();
        if (isManager) {
            if (!ArrayUtils.contains((Object[])managers, (Object)userId)) {
                managers = (String[])ArrayUtils.add((Object[])managers, (Object)userId);
                space.setManagers((String[])managers);
                SpaceUtils.addUserToGroupWithManagerMembership(userId, space.getGroupId());
                this.updateSpace(space);
                this.spaceLifeCycle.grantedLead(space, userId);
            }
        } else if (ArrayUtils.contains((Object[])managers, (Object)userId)) {
            managers = (String[])ArrayUtils.removeElement((Object[])managers, (Object)userId);
            space.setManagers((String[])managers);
            SpaceUtils.removeUserFromGroupWithManagerMembership(userId, space.getGroupId());
            this.updateSpace(space);
            this.spaceLifeCycle.revokedLead(space, userId);
        }
    }

    @Override
    public void unregisterSpaceListenerPlugin(SpaceListenerPlugin spaceListenerPlugin) {
        this.spaceLifeCycle.removeListener(spaceListenerPlugin);
    }

    @Override
    public Space updateSpace(Space existingSpace) {
        this.storage.saveSpace(existingSpace, false);
        return existingSpace;
    }

    @Override
    public ListAccess<Space> getInvitedSpacesWithListAccess(String userId) {
        return new SpaceListAccess(this.storage, userId, SpaceListAccess.Type.INVITED);
    }
}

