/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.core.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class Tools {
    public static <N> List<N> list(Iterator<N> iterable) {
        ArrayList<N> set = new ArrayList<N>();
        while (iterable.hasNext()) {
            set.add(iterable.next());
        }
        return set;
    }

    public static <N> Set<N> set(Iterable<N> iterable) {
        HashSet<N> set = new HashSet<N>();
        for (N n : iterable) {
            set.add(n);
        }
        return set;
    }

    public static <N> Set<N> set(Iterator<N> iterator) {
        HashSet<N> set = new HashSet<N>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static <N> Set<N> set() {
        return new HashSet();
    }

    public static <N> Set<N> set(N object) {
        HashSet<N> set = new HashSet<N>();
        set.add(object);
        return set;
    }

    public static <N> Set<N> set(N ... objects) throws NullPointerException {
        if (objects == null) {
            throw new NullPointerException();
        }
        HashSet<N> set = new HashSet<N>();
        for (N object : objects) {
            set.add(object);
        }
        return set;
    }

    public static int max(int value, int ... values) {
        int max = value;
        for (int v : values) {
            if (v <= max) continue;
            max = v;
        }
        return max;
    }

    public static <E> Iterator<E> iterator(final Iterator<? extends E> ... iterators) {
        return new Iterator<E>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                while (this.index < iterators.length) {
                    if (iterators[this.index].hasNext()) {
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }

            @Override
            public E next() {
                while (this.index < iterators.length) {
                    if (iterators[this.index].hasNext()) {
                        return iterators[this.index].next();
                    }
                    ++this.index;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

