/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.navigation.UINavigationManagement;
import org.exoplatform.portal.webui.navigation.UINavigationNodeSelector;
import org.exoplatform.portal.webui.page.UIPageNodeForm;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.space.UISpaceSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/social/webui/space/UIManageMySpaces.gtmpl", events={@EventConfig(listeners={EditSpaceActionListener.class}), @EventConfig(listeners={DeleteSpaceActionListener.class}, confirm="UIManageMySpaces.msg.confirm_space_delete"), @EventConfig(listeners={LeaveSpaceActionListener.class})})
public class UIManageMySpaces
extends UIContainer {
    private static final String MSG_WARNING_LEAVE_SPACE = "UIManageMySpaces.msg.warning_leave_space";
    private static final String MSG_ERROR_LEAVE_SPACE = "UIManageMySpaces.msg.error_leave_space";
    private static final String MSG_ERROR_DELETE_SPACE = "UIManageMySpaces.msg.error_delete_space";
    private static final Integer LEADER = 1;
    private static final Integer MEMBER = 2;
    private static final String SPACE_DELETED_INFO = "UIManageMySpaces.msg.DeletedInfo";
    private static final String MEMBERSHIP_REMOVED_INFO = "UIManageMySpaces.msg.MemberShipRemovedInfo";
    private static final String NAVIGATION_REMOVED_INFO = "UIManageMySpaces.msg.NavigationRemovedInfo";
    private static final String CONFIRMED_STATUS = "confirmed";
    private static final String SEARCH_ALL = "All";
    private static final int FIRST_PAGE = 1;
    private UIPageIterator iterator;
    private final Integer SPACES_PER_PAGE = 4;
    private final String ITERATOR_ID = "UIIteratorMySpaces";
    private SpaceService spaceService = null;
    private String userId = null;
    private List<PageNavigation> navigations;
    private PageNavigation selectedNavigation;
    private List<Space> spaces;
    private UISpaceSearch uiSpaceSearch = (UISpaceSearch)this.createUIComponent(UISpaceSearch.class, null, "UISpaceSearch");

    public UIManageMySpaces() throws Exception {
        this.uiSpaceSearch.setTypeOfRelation(CONFIRMED_STATUS);
        this.addChild((UIComponent)this.uiSpaceSearch);
        this.iterator = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UIIteratorMySpaces");
    }

    public UIPageIterator getMySpacesUIPageIterator() {
        return this.iterator;
    }

    public List<Space> getAllUserSpaces() throws Exception {
        SpaceService spaceService = this.getSpaceService();
        String userId = this.getUserId();
        List userSpaces = spaceService.getAccessibleSpaces(userId);
        SpaceUtils.reloadNavigation();
        return SpaceUtils.getOrderedSpaces((List)userSpaces);
    }

    public PageNavigation getSelectedNavigation() {
        return this.selectedNavigation;
    }

    public void setSelectedNavigation(PageNavigation navigation) {
        this.selectedNavigation = navigation;
    }

    public List<Space> getUserSpaces() throws Exception {
        this.uiSpaceSearch.setSpaceNameForAutoSuggest(this.getAllMySpaceNames());
        return this.getDisplayMySpace(this.iterator);
    }

    public int getRole(String spaceId) throws SpaceException {
        String userId;
        Space space;
        SpaceService spaceService = this.getSpaceService();
        if (spaceService.hasSettingPermission(space = spaceService.getSpaceById(spaceId), userId = this.getUserId())) {
            return LEADER;
        }
        return MEMBER;
    }

    public boolean hasMembership(String spaceId) throws SpaceException {
        SpaceService spaceService = this.getSpaceService();
        String userId = this.getUserId();
        Space space = spaceService.getSpaceById(spaceId);
        return spaceService.isMember(space, userId);
    }

    public void setSpaces(List<Space> spaces) {
        this.spaces = spaces;
    }

    public List<Space> getSpaces() {
        return this.spaces;
    }

    public String getImageSource(Space space) throws Exception {
        return space.getAvatarUrl();
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private String getUserId() {
        if (this.userId == null) {
            this.userId = Util.getPortalRequestContext().getRemoteUser();
        }
        return this.userId;
    }

    private List<Space> getDisplayMySpace(UIPageIterator pageIterator_) throws Exception {
        int currentPage = pageIterator_.getCurrentPage();
        String selectedChar = this.uiSpaceSearch.getSelectedChar();
        String spaceNameSearch = this.uiSpaceSearch.getSpaceNameSearch();
        LazyPageList pageList = null;
        if (selectedChar == null && spaceNameSearch == null || selectedChar != null && selectedChar.equals(SEARCH_ALL)) {
            pageList = new LazyPageList(this.spaceService.getAccessibleSpacesWithListAccess(this.userId), this.SPACES_PER_PAGE.intValue());
        } else {
            SpaceFilter spaceFilter = null;
            spaceFilter = selectedChar != null ? new SpaceFilter(selectedChar.charAt(0)) : new SpaceFilter(spaceNameSearch);
            pageList = new LazyPageList(this.spaceService.getAccessibleSpacesByFilter(this.userId, spaceFilter), this.SPACES_PER_PAGE.intValue());
        }
        pageIterator_.setPageList((PageList)pageList);
        int availablePage = pageIterator_.getAvailablePage();
        if (this.uiSpaceSearch.isNewSearch()) {
            pageIterator_.setCurrentPage(1);
        } else if (currentPage > availablePage) {
            pageIterator_.setCurrentPage(availablePage);
        } else {
            pageIterator_.setCurrentPage(currentPage);
        }
        this.uiSpaceSearch.setNewSearch(false);
        return pageIterator_.getCurrentPageData();
    }

    private List<String> getAllMySpaceNames() throws Exception {
        List<Space> allSpaces = this.getAllUserSpaces();
        ArrayList<String> allSpacesNames = new ArrayList<String>();
        for (Space space : allSpaces) {
            allSpacesNames.add(space.getDisplayName());
        }
        return allSpacesNames;
    }

    private String getNodeUri(Space space, String appId) throws SpaceException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
        try {
            String groupId = space.getGroupId();
            PageNavigation nav = dataStorage.getPageNavigation("group", groupId);
            if (nav == null) {
                return null;
            }
            PageNode homeNode = SpaceUtils.getHomeNode((PageNavigation)nav, (String)space.getUrl());
            if (homeNode == null) {
                throw new Exception("homeNode is null!");
            }
            String nodeName = SpaceUtils.getAppNodeName((Space)space, (String)appId);
            PageNode childNode = homeNode.getChild(nodeName);
            if (childNode != null) {
                return childNode.getUri();
            }
            List pageNodes = homeNode.getChildren();
            for (PageNode pageNode : pageNodes) {
                String pageReference = pageNode.getPageReference();
                if (!pageReference.contains(nodeName)) continue;
                return pageNode.getUri();
            }
            return null;
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_APPLICATION, (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LeaveSpaceActionListener
    extends EventListener<UIManageMySpaces> {
        public void execute(Event<UIManageMySpaces> event) throws Exception {
            UIManageMySpaces uiMySpaces = (UIManageMySpaces)((Object)event.getSource());
            SpaceService spaceService = uiMySpaces.getSpaceService();
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            String spaceId = ctx.getRequestParameter("objectId");
            String userId = uiMySpaces.getUserId();
            Space space = spaceService.getSpaceById(spaceId);
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManageMySpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            if (!spaceService.isMember(space, userId) && !spaceService.hasSettingPermission(space, userId)) {
                uiApp.addMessage(new ApplicationMessage(UIManageMySpaces.MEMBERSHIP_REMOVED_INFO, null, 2));
                return;
            }
            if (spaceService.isOnlyManager(space, userId)) {
                uiApp.addMessage(new ApplicationMessage(UIManageMySpaces.MSG_WARNING_LEAVE_SPACE, null, 1));
                return;
            }
            spaceService.removeMember(space, userId);
            spaceService.setManager(space, userId, false);
            SpaceUtils.updateWorkingWorkSpace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteSpaceActionListener
    extends EventListener<UIManageMySpaces> {
        public void execute(Event<UIManageMySpaces> event) throws Exception {
            UIManageMySpaces uiMySpaces = (UIManageMySpaces)((Object)event.getSource());
            SpaceService spaceService = uiMySpaces.getSpaceService();
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            String spaceId = ctx.getRequestParameter("objectId");
            Space space = spaceService.getSpaceById(spaceId);
            String userId = uiMySpaces.getUserId();
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManageMySpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            if (!spaceService.isMember(space, userId) && !spaceService.hasSettingPermission(space, userId)) {
                uiApp.addMessage(new ApplicationMessage(UIManageMySpaces.MEMBERSHIP_REMOVED_INFO, null, 2));
                return;
            }
            spaceService.deleteSpace(space);
            SpaceUtils.updateWorkingWorkSpace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BackActionListener
    extends EventListener<UIPageNodeForm> {
        public void execute(Event<UIPageNodeForm> event) throws Exception {
            UIPageNodeForm uiPageNode = (UIPageNodeForm)event.getSource();
            PageNavigation contextNavigation = uiPageNode.getContextPageNavigation();
            UIManageMySpaces uiMySpaces = (UIManageMySpaces)uiPageNode.getAncestorOfType(UIManageMySpaces.class);
            UIPopupWindow uiPopup = (UIPopupWindow)uiMySpaces.getChild(UIPopupWindow.class);
            UINavigationManagement navigationManager = (UINavigationManagement)uiMySpaces.createUIComponent(UINavigationManagement.class, null, null);
            navigationManager.setOwner(contextNavigation.getOwnerId());
            navigationManager.setOwnerType(contextNavigation.getOwnerType());
            UINavigationNodeSelector selector = (UINavigationNodeSelector)navigationManager.getChild(UINavigationNodeSelector.class);
            selector.setEdittedNavigation(contextNavigation);
            selector.initTreeData();
            uiPopup.setUIComponent((UIComponent)navigationManager);
            uiPopup.setWindowSize(400, 400);
            uiPopup.setRendered(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMySpaces);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditSpaceActionListener
    extends EventListener<UIManageMySpaces> {
        public void execute(Event<UIManageMySpaces> event) throws Exception {
            OrganizationService organizationService;
            Group group;
            UIManageMySpaces uiMySpaces = (UIManageMySpaces)((Object)event.getSource());
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            SpaceService spaceService = uiMySpaces.getSpaceService();
            Space space = spaceService.getSpaceById(ctx.getRequestParameter("objectId"));
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage("UIManageMySpaces.msg.warning_space_not_available", null, 1));
            }
            if ((group = (organizationService = SpaceUtils.getOrganizationService()).getGroupHandler().findGroupById(space.getGroupId())) == null) {
                uiApp.addMessage(new ApplicationMessage("UIManageMySpaces.msg.group_unable_to_retrieve", null, 0));
                return;
            }
            String spaceUrl = Util.getPortalRequestContext().getPortalURI();
            String spaceSettingUri = uiMySpaces.getNodeUri(space, "SpaceSettingPortlet");
            String spaceSettingUrl = spaceUrl + spaceSettingUri;
            PortalRequestContext prContext = Util.getPortalRequestContext();
            prContext.setResponseComplete(true);
            prContext.getResponse().sendRedirect(spaceSettingUrl);
        }
    }
}

