/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.ComponentLifecycleScope;
import org.exoplatform.services.rest.FilterDescriptor;
import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.ObjectFactory;
import org.exoplatform.services.rest.RequestFilter;
import org.exoplatform.services.rest.ResponseFilter;
import org.exoplatform.services.rest.SingletonObjectFactory;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.rest.impl.ApplicationProviders;
import org.exoplatform.services.rest.impl.ProviderBinder;
import org.exoplatform.services.rest.impl.ProvidersRegistry;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.rest.impl.header.HeaderHelper;
import org.exoplatform.services.rest.impl.header.MediaTypeHelper;
import org.exoplatform.services.rest.impl.method.MethodInvokerFactory;
import org.exoplatform.services.rest.impl.resource.AbstractResourceDescriptorImpl;
import org.exoplatform.services.rest.impl.resource.ApplicationResource;
import org.exoplatform.services.rest.method.MethodInvoker;
import org.exoplatform.services.rest.method.MethodInvokerFilter;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;
import org.exoplatform.services.rest.resource.ResourceMethodDescriptor;
import org.exoplatform.services.rest.resource.ResourceMethodMap;
import org.exoplatform.services.rest.resource.SubResourceLocatorDescriptor;
import org.exoplatform.services.rest.resource.SubResourceLocatorMap;
import org.exoplatform.services.rest.resource.SubResourceMethodDescriptor;
import org.exoplatform.services.rest.resource.SubResourceMethodMap;
import org.exoplatform.services.rest.uri.UriPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestDispatcher {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.rest.core.RequestDispatcher");
    protected final ResourceBinder resourceBinder;
    protected final MethodInvokerFactory invokerFactory;
    protected final ProvidersRegistry providersRegistry;

    public RequestDispatcher(ResourceBinder resourceBinder, ProvidersRegistry providersRegistry, MethodInvokerFactory invokerFactory) {
        this.resourceBinder = resourceBinder;
        this.providersRegistry = providersRegistry;
        this.invokerFactory = invokerFactory;
    }

    public RequestDispatcher(ResourceBinder resourceBinder, ProvidersRegistry providers) {
        this(resourceBinder, providers, null);
    }

    @Deprecated
    public RequestDispatcher(ResourceBinder resourceBinder, MethodInvokerFactory invokerFactory) {
        this(resourceBinder, null, invokerFactory);
    }

    @Deprecated
    public RequestDispatcher(ResourceBinder resourceBinder) {
        this(resourceBinder, null, null);
    }

    public void dispatch(GenericContainerRequest request, GenericContainerResponse response) {
        ApplicationContext context = ApplicationContextImpl.getCurrent();
        String requestPath = context.getPath(false);
        List<String> parameterValues = context.getParameterValues();
        ObjectFactory<AbstractResourceDescriptor> resourceFactory = this.getRootResourse(parameterValues, requestPath);
        AbstractResourceDescriptor resourceDescriptor = resourceFactory.getObjectModel();
        if (this.providersRegistry != null) {
            String applicationId = null;
            if (resourceDescriptor instanceof ApplicationResource) {
                applicationId = ((ApplicationResource)resourceDescriptor).getApplication();
            }
            ApplicationProviders applicationProviders = this.providersRegistry.getProviders(applicationId);
            ((ApplicationContextImpl)context).setProviders(new ProvidersAdapter(applicationProviders, ProviderBinder.getInstance()));
        } else {
            LOG.warn((Object)"ProvidersRegistry must set. ");
        }
        for (ObjectFactory<FilterDescriptor> factory : context.getProviders().getRequestFilters(context.getPath())) {
            RequestFilter f = (RequestFilter)factory.getInstance(context);
            f.doFilter(request);
        }
        String newRequestPath = RequestDispatcher.getPathTail(parameterValues);
        context.addMatchedURI(requestPath.substring(0, requestPath.lastIndexOf(newRequestPath)));
        context.setParameterNames(resourceFactory.getObjectModel().getUriPattern().getParameterNames());
        Object resource = resourceFactory.getInstance(context);
        this.dispatch(request, response, context, resourceFactory, resource, newRequestPath);
        for (ObjectFactory<FilterDescriptor> factory : context.getProviders().getResponseFilters(context.getPath())) {
            ResponseFilter f = (ResponseFilter)factory.getInstance(context);
            f.doFilter(response);
        }
    }

    private static String getPathTail(List<String> parameterValues) {
        int i = parameterValues.size() - 1;
        return parameterValues.get(i) != null ? parameterValues.get(i) : "";
    }

    private void dispatch(GenericContainerRequest request, GenericContainerResponse response, ApplicationContext context, ObjectFactory<AbstractResourceDescriptor> resourceFactory, Object resource, String requestPath) {
        List<String> parameterValues = context.getParameterValues();
        int len = parameterValues.size();
        ResourceMethodMap<ResourceMethodDescriptor> rmm = resourceFactory.getObjectModel().getResourceMethods();
        SubResourceMethodMap srmm = resourceFactory.getObjectModel().getSubResourceMethods();
        SubResourceLocatorMap srlm = resourceFactory.getObjectModel().getSubResourceLocators();
        if ((parameterValues.get(len - 1) == null || "/".equals(parameterValues.get(len - 1))) && rmm.size() > 0) {
            ArrayList methods = new ArrayList();
            boolean match = RequestDispatcher.processResourceMethod(rmm, request, response, methods);
            if (!match) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Not found resource method for method " + request.getMethod()));
                }
                return;
            }
            this.invokeResourceMethod((ResourceMethodDescriptor)methods.get(0), resource, context, request, response);
        } else {
            ArrayList<SubResourceMethodDescriptor> methods = new ArrayList<SubResourceMethodDescriptor>();
            boolean match = RequestDispatcher.processSubResourceMethod(srmm, requestPath, request, response, parameterValues, methods);
            ArrayList<SubResourceLocatorDescriptor> locators = new ArrayList<SubResourceLocatorDescriptor>();
            boolean hasAcceptableLocator = RequestDispatcher.processSubResourceLocator(srlm, requestPath, parameterValues, locators);
            if (!match && !hasAcceptableLocator) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Not found sub-resource methods nor sub-resource locators for path " + requestPath + " and method " + request.getMethod()));
                }
                return;
            }
            if (!hasAcceptableLocator && match || hasAcceptableLocator && match && this.compareSubResources((SubResourceMethodDescriptor)methods.get(0), (SubResourceLocatorDescriptor)locators.get(0)) < 0) {
                this.invokeSubResourceMethod(requestPath, (SubResourceMethodDescriptor)methods.get(0), resource, context, request, response);
            } else if (hasAcceptableLocator && !match || hasAcceptableLocator && match && this.compareSubResources((SubResourceMethodDescriptor)methods.get(0), (SubResourceLocatorDescriptor)locators.get(0)) > 0) {
                this.invokeSuResourceLocator(requestPath, (SubResourceLocatorDescriptor)locators.get(0), resource, context, request, response);
            }
        }
    }

    private void invokeResourceMethod(ResourceMethodDescriptor rmd, Object resource, ApplicationContext context, GenericContainerRequest request, GenericContainerResponse response) {
        context.addMatchedResource(resource);
        Class<?> returnType = rmd.getResponseType();
        MethodInvoker invoker = rmd.getMethodInvoker();
        Object o = invoker.invokeMethod(resource, rmd, context);
        RequestDispatcher.processResponse(o, returnType, request, response, rmd.produces());
    }

    private void invokeSubResourceMethod(String requestPath, SubResourceMethodDescriptor srmd, Object resource, ApplicationContext context, GenericContainerRequest request, GenericContainerResponse response) {
        context.addMatchedResource(resource);
        context.addMatchedURI(requestPath);
        context.setParameterNames(srmd.getUriPattern().getParameterNames());
        Class<?> returnType = srmd.getResponseType();
        MethodInvoker invoker = srmd.getMethodInvoker();
        Object o = invoker.invokeMethod(resource, srmd, context);
        RequestDispatcher.processResponse(o, returnType, request, response, srmd.produces());
    }

    private void invokeSuResourceLocator(String requestPath, SubResourceLocatorDescriptor srld, Object resource, ApplicationContext context, GenericContainerRequest request, GenericContainerResponse response) {
        context.addMatchedResource(resource);
        String newRequestPath = RequestDispatcher.getPathTail(context.getParameterValues());
        context.addMatchedURI(requestPath.substring(0, requestPath.lastIndexOf(newRequestPath)));
        context.setParameterNames(srld.getUriPattern().getParameterNames());
        MethodInvoker invoker = srld.getMethodInvoker();
        resource = invoker.invokeMethod(resource, srld, context);
        AbstractResourceDescriptorImpl descriptor = new AbstractResourceDescriptorImpl(resource, this.invokerFactory);
        SingletonObjectFactory<AbstractResourceDescriptor> locResource = new SingletonObjectFactory<AbstractResourceDescriptor>(descriptor, resource);
        this.dispatch(request, response, context, locResource, resource, newRequestPath);
    }

    private int compareSubResources(SubResourceMethodDescriptor srmd, SubResourceLocatorDescriptor srld) {
        int r = UriPattern.URIPATTERN_COMPARATOR.compare(srmd.getUriPattern(), srld.getUriPattern());
        if (r == 0) {
            return -1;
        }
        return r;
    }

    private static void processResponse(Object o, Class<?> returnType, GenericContainerRequest request, GenericContainerResponse response, List<MediaType> produces) {
        MediaType contentType = request.getAcceptableMediaType(produces);
        if (returnType == Void.TYPE || o == null) {
            response.setResponse(Response.noContent().build());
        } else if (Response.class.isAssignableFrom(returnType)) {
            Response r = (Response)o;
            if (r.getMetadata().getFirst((Object)"Content-Type") == null && r.getEntity() != null) {
                r.getMetadata().putSingle((Object)"Content-Type", (Object)contentType);
            }
            response.setResponse(r);
        } else if (GenericEntity.class.isAssignableFrom(returnType)) {
            response.setResponse(Response.ok((Object)o, (MediaType)contentType).build());
        } else {
            response.setResponse(Response.ok((Object)o, (MediaType)contentType).build());
        }
    }

    private static <T extends ResourceMethodDescriptor> boolean processResourceMethod(ResourceMethodMap<T> rmm, GenericContainerRequest request, GenericContainerResponse response, List<T> methods) {
        List<T> rmds = rmm.getList(request.getMethod());
        if (rmds == null || rmds.size() == 0) {
            response.setResponse(Response.status((int)405).header("Allow", (Object)HeaderHelper.convertToString(rmm.getAllow())).entity((Object)"Method not allowed.").type("text/plain").build());
            return false;
        }
        MediaType contentType = request.getMediaType();
        if (contentType == null) {
            methods.addAll(rmds);
        } else {
            for (ResourceMethodDescriptor rmd : rmds) {
                if (!MediaTypeHelper.isConsume(rmd.consumes(), contentType)) continue;
                methods.add(rmd);
            }
        }
        if (methods.isEmpty()) {
            response.setResponse(Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).entity((Object)("Media type " + contentType + " is not supported.")).type("text/plain").build());
            return false;
        }
        List acceptable = request.getAcceptableMediaTypes();
        float previousQValue = 0.0f;
        int n = 0;
        int p = 0;
        ListIterator<T> i = methods.listIterator();
        while (i.hasNext()) {
            n = i.nextIndex();
            ResourceMethodDescriptor rmd = (ResourceMethodDescriptor)i.next();
            float qValue = MediaTypeHelper.processQuality(acceptable, rmd.produces());
            if (qValue > previousQValue) {
                previousQValue = qValue;
                p = n;
                continue;
            }
            i.remove();
        }
        if (!methods.isEmpty()) {
            if (methods.size() > 1) {
                n = 0;
                i = methods.listIterator();
                while (i.hasNext()) {
                    i.next();
                    if (n == p) break;
                    i.remove();
                    ++n;
                }
            }
            return true;
        }
        response.setResponse(Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)"Not Acceptable").type("text/plain").build());
        return false;
    }

    private static boolean processSubResourceMethod(SubResourceMethodMap srmm, String requestedPath, GenericContainerRequest request, GenericContainerResponse response, List<String> capturingValues, List<SubResourceMethodDescriptor> methods) {
        ResourceMethodMap rmm = null;
        for (Map.Entry e : srmm.entrySet()) {
            int len;
            if (!((UriPattern)e.getKey()).match(requestedPath, capturingValues) || capturingValues.get((len = capturingValues.size()) - 1) != null && !"/".equals(capturingValues.get(len - 1))) continue;
            rmm = (ResourceMethodMap)e.getValue();
            break;
        }
        if (rmm == null) {
            response.setResponse(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("There is no any resources matched to request path " + requestedPath)).type("text/plain").build());
            return false;
        }
        ArrayList l = new ArrayList();
        boolean match = RequestDispatcher.processResourceMethod(rmm, request, response, l);
        if (match) {
            Iterator i = l.iterator();
            while (i.hasNext()) {
                methods.add((SubResourceMethodDescriptor)i.next());
            }
        }
        return match;
    }

    private static boolean processSubResourceLocator(SubResourceLocatorMap srlm, String requestedPath, List<String> capturingValues, List<SubResourceLocatorDescriptor> locators) {
        for (Map.Entry e : srlm.entrySet()) {
            if (!((UriPattern)e.getKey()).match(requestedPath, capturingValues)) continue;
            locators.add((SubResourceLocatorDescriptor)e.getValue());
        }
        return !locators.isEmpty();
    }

    protected ObjectFactory<AbstractResourceDescriptor> getRootResourse(List<String> parameterValues, String requestPath) {
        ObjectFactory<AbstractResourceDescriptor> resourceFactory = this.resourceBinder.getMatchedResource(requestPath, parameterValues);
        if (resourceFactory == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Root resource not found for " + requestPath));
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("There is no any resources matched to request path " + requestPath)).type("text/plain").build());
        }
        return resourceFactory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProvidersAdapter
    extends ProviderBinder {
        private ProviderBinder applicationProviders;
        private ProviderBinder defaultProviders;

        private ProvidersAdapter(ProviderBinder applicationProviders, ProviderBinder defaultProviders) {
            this.applicationProviders = applicationProviders;
            this.defaultProviders = defaultProviders;
        }

        @Override
        protected void init() {
        }

        @Override
        public void addContextResolver(Class<? extends ContextResolver> clazz, ContextResolver instance, ComponentLifecycleScope scope) {
            if (this.applicationProviders == null) {
                throw new UnsupportedOperationException("addContextResolver");
            }
            this.applicationProviders.addContextResolver(clazz, instance, scope);
        }

        @Override
        public void addContextResolver(Class<? extends ContextResolver> clazz) {
            if (this.applicationProviders == null) {
                throw new UnsupportedOperationException("addContextResolver");
            }
            this.applicationProviders.addContextResolver(clazz);
        }

        @Override
        public void addContextResolver(ContextResolver instance) {
            if (this.applicationProviders == null) {
                throw new UnsupportedOperationException("addContextResolver");
            }
            this.applicationProviders.addContextResolver(instance);
        }

        @Override
        public void addExceptionMapper(Class<? extends ExceptionMapper> clazz, ExceptionMapper instance, ComponentLifecycleScope scope) {
            if (this.applicationProviders == null) {
                throw new UnsupportedOperationException("addExceptionMapper");
            }
            this.applicationProviders.addExceptionMapper(clazz, instance, scope);
        }

        @Override
        public void addExceptionMapper(Class<? extends ExceptionMapper> clazz) {
            if (this.applicationProviders == null) {
                throw new UnsupportedOperationException("addExceptionMapper");
            }
            this.applicationProviders.addExceptionMapper(clazz);
        }

        @Override
        public void addExceptionMapper(ExceptionMapper instance) {
            if (this.applicationProviders == null) {
                throw new UnsupportedOperationException("addExceptionMapper");
            }
            this.applicationProviders.addExceptionMapper(instance);
        }

        @Override
        public void addMessageBodyReader(Class<? extends MessageBodyReader> clazz, MessageBodyReader instance, ComponentLifecycleScope scope) {
            if (this.applicationProviders == null) {
                throw new UnsupportedOperationException("addMessageBodyReader");
            }
            this.applicationProviders.addMessageBodyReader(clazz, instance, scope);
        }

        @Override
        public void addMessageBodyReader(Class<? extends MessageBodyReader> clazz) {
            if (this.applicationProviders == null) {
                throw new UnsupportedOperationException("addMessageBodyReader");
            }
            this.applicationProviders.addMessageBodyReader(clazz);
        }

        @Override
        public void addMessageBodyReader(MessageBodyReader instance) {
            if (this.applicationProviders == null) {
                throw new UnsupportedOperationException("addMessageBodyReader");
            }
            this.applicationProviders.addMessageBodyReader(instance);
        }

        @Override
        public void addMessageBodyWriter(Class<? extends MessageBodyWriter> clazz, MessageBodyWriter instance, ComponentLifecycleScope scope) {
            if (this.applicationProviders == null) {
                throw new UnsupportedOperationException("addMessageBodyWriter");
            }
            this.applicationProviders.addMessageBodyWriter(clazz, instance, scope);
        }

        @Override
        public void addMessageBodyWriter(Class<? extends MessageBodyWriter> clazz) {
            if (this.applicationProviders == null) {
                throw new UnsupportedOperationException("addMessageBodyWriter");
            }
            this.applicationProviders.addMessageBodyWriter(clazz);
        }

        @Override
        public void addMessageBodyWriter(MessageBodyWriter instance) {
            if (this.applicationProviders == null) {
                throw new UnsupportedOperationException("addMessageBodyWriter");
            }
            this.applicationProviders.addMessageBodyWriter(instance);
        }

        @Override
        public void addMethodInvokerFilter(Class<? extends MethodInvokerFilter> clazz, MethodInvokerFilter instance, ComponentLifecycleScope scope) {
            if (this.applicationProviders == null) {
                throw new UnsupportedOperationException("addMethodInvokerFilter");
            }
            this.applicationProviders.addMethodInvokerFilter(clazz, instance, scope);
        }

        @Override
        public void addMethodInvokerFilter(Class<? extends MethodInvokerFilter> clazz) {
            if (this.applicationProviders == null) {
                throw new UnsupportedOperationException("addMethodInvokerFilter");
            }
            this.applicationProviders.addMethodInvokerFilter(clazz);
        }

        @Override
        public void addMethodInvokerFilter(MethodInvokerFilter instance) {
            if (this.applicationProviders == null) {
                throw new UnsupportedOperationException("addMethodInvokerFilter");
            }
            this.applicationProviders.addMethodInvokerFilter(instance);
        }

        @Override
        public void addRequestFilter(Class<? extends RequestFilter> clazz, RequestFilter instance, ComponentLifecycleScope scope) {
            if (this.applicationProviders == null) {
                throw new UnsupportedOperationException("addRequestFilter");
            }
            this.applicationProviders.addRequestFilter(clazz, instance, scope);
        }

        @Override
        public void addRequestFilter(Class<? extends RequestFilter> clazz) {
            if (this.applicationProviders == null) {
                throw new UnsupportedOperationException("addRequestFilter");
            }
            this.applicationProviders.addRequestFilter(clazz);
        }

        @Override
        public void addRequestFilter(RequestFilter instance) {
            if (this.applicationProviders == null) {
                throw new UnsupportedOperationException("addRequestFilter");
            }
            this.applicationProviders.addRequestFilter(instance);
        }

        @Override
        public void addResponseFilter(Class<? extends ResponseFilter> clazz, ResponseFilter instance, ComponentLifecycleScope scope) {
            if (this.applicationProviders == null) {
                throw new UnsupportedOperationException("addResponseFilter");
            }
            this.applicationProviders.addResponseFilter(clazz, instance, scope);
        }

        @Override
        public void addResponseFilter(Class<? extends ResponseFilter> clazz) {
            if (this.applicationProviders == null) {
                throw new UnsupportedOperationException("addResponseFilter");
            }
            this.applicationProviders.addResponseFilter(clazz);
        }

        @Override
        public void addResponseFilter(ResponseFilter instance) {
            if (this.applicationProviders == null) {
                throw new UnsupportedOperationException("addResponseFilter");
            }
            this.applicationProviders.addResponseFilter(instance);
        }

        @Override
        public List<MediaType> getAcceptableWriterMediaTypes(Class<?> type, Type genericType, Annotation[] annotations) {
            List<MediaType> mediaTypes = null;
            if (this.applicationProviders != null) {
                mediaTypes = this.applicationProviders.getAcceptableWriterMediaTypes(type, genericType, annotations);
            }
            if (mediaTypes != null) {
                mediaTypes.addAll(this.defaultProviders.getAcceptableWriterMediaTypes(type, genericType, annotations));
                return mediaTypes;
            }
            return this.defaultProviders.getAcceptableWriterMediaTypes(type, genericType, annotations);
        }

        @Override
        public <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
            ContextResolver<T> resolver = null;
            if (this.applicationProviders != null) {
                resolver = this.applicationProviders.getContextResolver(contextType, mediaType);
            }
            if (resolver == null) {
                resolver = this.defaultProviders.getContextResolver(contextType, mediaType);
            }
            return resolver;
        }

        @Override
        public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> type) {
            ExceptionMapper<T> mapper = null;
            if (this.applicationProviders != null) {
                mapper = this.applicationProviders.getExceptionMapper(type);
            }
            if (mapper == null) {
                mapper = this.defaultProviders.getExceptionMapper(type);
            }
            return mapper;
        }

        @Override
        public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            MessageBodyReader<T> reader = null;
            if (this.applicationProviders != null) {
                reader = this.applicationProviders.getMessageBodyReader(type, genericType, annotations, mediaType);
            }
            if (reader == null) {
                reader = this.defaultProviders.getMessageBodyReader(type, genericType, annotations, mediaType);
            }
            return reader;
        }

        @Override
        public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            MessageBodyWriter<T> writer = null;
            if (this.applicationProviders != null) {
                writer = this.applicationProviders.getMessageBodyWriter(type, genericType, annotations, mediaType);
            }
            if (writer == null) {
                writer = this.defaultProviders.getMessageBodyWriter(type, genericType, annotations, mediaType);
            }
            return writer;
        }

        @Override
        public List<ObjectFactory<FilterDescriptor>> getMethodInvokerFilters(String path) {
            List<ObjectFactory<FilterDescriptor>> filters = this.defaultProviders.getMethodInvokerFilters(path);
            if (this.applicationProviders != null) {
                filters.addAll(this.applicationProviders.getMethodInvokerFilters(path));
            }
            return filters;
        }

        @Override
        public List<ObjectFactory<FilterDescriptor>> getRequestFilters(String path) {
            if (this.applicationProviders == null) {
                return Collections.emptyList();
            }
            return this.applicationProviders.getRequestFilters(path);
        }

        @Override
        public List<ObjectFactory<FilterDescriptor>> getResponseFilters(String path) {
            if (this.applicationProviders == null) {
                return Collections.emptyList();
            }
            return this.applicationProviders.getResponseFilters(path);
        }
    }
}

