/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.debug;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.Vector;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Util;

public class ProtocolTester {
    Protocol harness = null;
    Protocol top;
    Protocol bottom;
    String props = null;
    Configurator config = null;
    protected final Log log = LogFactory.getLog(this.getClass());

    public ProtocolTester(String prot_spec, Protocol harness) throws Exception {
        if (prot_spec == null || harness == null) {
            throw new Exception("ProtocolTester(): prot_spec or harness is null");
        }
        this.props = prot_spec;
        this.harness = harness;
        this.props = "LOOPBACK:" + this.props;
        this.config = new Configurator();
        JChannel mock_channel = new JChannel(){};
        ProtocolStack stack = new ProtocolStack(mock_channel);
        stack.setup(Configurator.parseConfigurations(this.props));
        stack.insertProtocol(harness, 1, (Class<? extends Protocol>)stack.getTopProtocol().getClass());
        this.bottom = stack.getBottomProtocol();
    }

    public Vector<Protocol> getProtocols() {
        Vector<Protocol> retval = new Vector<Protocol>();
        for (Protocol tmp = this.top; tmp != null; tmp = tmp.getDownProtocol()) {
            retval.add(tmp);
        }
        return retval;
    }

    public String getProtocolSpec() {
        return this.props;
    }

    public Protocol getBottom() {
        return this.bottom;
    }

    public Protocol getTop() {
        return this.top;
    }

    public void start() throws Exception {
        block3: {
            block2: {
                if (this.harness == null) break block2;
                for (Protocol p = this.harness; p != null; p = p.getDownProtocol()) {
                    p.start();
                }
                break block3;
            }
            if (this.top == null) break block3;
            for (Protocol p = this.top; p != null; p = p.getDownProtocol()) {
                p.start();
            }
        }
    }

    public void stop() {
        block5: {
            Protocol p;
            block4: {
                Protocol p2;
                if (this.harness == null) break block4;
                LinkedList<Protocol> protocols = new LinkedList<Protocol>();
                for (p2 = this.harness; p2 != null; p2 = p2.getDownProtocol()) {
                    protocols.add(p2);
                    p2.stop();
                }
                for (p2 = this.harness; p2 != null; p2 = p2.getDownProtocol()) {
                    p2.destroy();
                }
                break block5;
            }
            if (this.top == null) break block5;
            LinkedList<Protocol> protocols = new LinkedList<Protocol>();
            for (p = this.top; p != null; p = p.getDownProtocol()) {
                protocols.add(p);
                p.stop();
            }
            for (p = this.top; p != null; p = p.getDownProtocol()) {
                p.destroy();
            }
        }
    }

    private final Protocol getBottomProtocol(Protocol top) {
        if (top == null) {
            return null;
        }
        Protocol tmp = top;
        while (tmp.getDownProtocol() != null) {
            tmp = tmp.getDownProtocol();
        }
        return tmp;
    }

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            System.out.println("ProtocolTester <protocol stack spec> [-trace]");
            return;
        }
        String props = args[0];
        try {
            Harness h = new Harness();
            ProtocolTester t = new ProtocolTester(props, h);
            System.out.println("protocol specification is " + t.getProtocolSpec());
            h.down(new Event(16));
            for (int i = 0; i < 5; ++i) {
                System.out.println("Sending msg #" + i);
                h.down(new Event(1, new Message(null, null, (Serializable)((Object)("Hello world #" + i)))));
            }
            Util.sleep(500L);
            t.stop();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    private static class Harness
    extends Protocol {
        private Harness() {
        }

        @Override
        public String getName() {
            return "Harness";
        }

        @Override
        public Object up(Event evt) {
            System.out.println("Harness.up(): " + evt);
            return null;
        }
    }
}

