/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Arrays;
import java.util.List;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.TimeoutException;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.util.Promise;
import org.jgroups.util.UUID;

@DeprecatedProperty(names={"gossip_host", "gossip_port", "gossip_refresh", "port_range", "socket_conn_timeout", "socket_read_timeout", "discovery_timeout"})
public class PING
extends Discovery {
    @Property(description="Time (in ms) to wait for our own discovery message to be received. 0 means don't wait. If the discovery message is not received within discovery_timeout ms, a warning will be logged")
    private long discovery_timeout = 0L;
    protected final Promise<Boolean> discovery_reception = new Promise();

    @Override
    public void stop() {
        super.stop();
        this.discovery_reception.reset();
    }

    @Override
    public void sendGetMembersRequest(String cluster_name, Promise promise, boolean return_views_only) throws Exception {
        PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, this.local_addr));
        List<PhysicalAddress> physical_addrs = Arrays.asList(physical_addr);
        PingData data = new PingData(this.local_addr, null, false, UUID.get(this.local_addr), physical_addrs);
        PingHeader hdr = new PingHeader(1, data, cluster_name);
        hdr.return_view_only = return_views_only;
        Message msg = new Message(null);
        msg.setFlag((byte)1);
        msg.putHeader(this.id, hdr);
        this.sendMcastDiscoveryRequest(msg);
    }

    @Override
    public Object up(Event evt) {
        Message msg;
        PingHeader hdr;
        if (evt.getType() == 1 && (hdr = (PingHeader)(msg = (Message)evt.getArg()).getHeader(this.id)) != null && hdr.type == 1 && msg.getSrc().equals(this.local_addr)) {
            this.discovery_reception.setResult(true);
        }
        return super.up(evt);
    }

    void sendMcastDiscoveryRequest(Message discovery_request) {
        this.discovery_reception.reset();
        this.down_prot.down(new Event(1, discovery_request));
        this.waitForDiscoveryRequestReception();
    }

    protected void waitForDiscoveryRequestReception() {
        block3: {
            if (this.discovery_timeout > 0L) {
                try {
                    this.discovery_reception.getResultWithTimeout(this.discovery_timeout);
                }
                catch (TimeoutException e) {
                    if (!this.log.isWarnEnabled()) break block3;
                    this.log.warn("didn't receive my own discovery request - multicast socket might not be configured correctly");
                }
            }
        }
    }
}

