/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Global;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.ThreadManagerThreadPoolExecutor;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@Experimental
@MBean(description="Implementation of scopes (concurrent delivery of messages from the same sender)")
public class SCOPE
extends Protocol {
    protected int thread_pool_min_threads = 2;
    protected int thread_pool_max_threads = 10;
    protected long thread_pool_keep_alive_time = 30000L;
    @Property(description="Thread naming pattern for threads in this channel. Default is cl")
    protected String thread_naming_pattern = "cl";
    @Property(description="Time in milliseconds after which an expired scope will get removed. An expired scope is one to which no messages have been added in max_expiration_time milliseconds. 0 never expires scopes")
    protected long expiration_time = 30000L;
    @Property(description="Interval in milliseconds at which the expiry task tries to remove expired scopes")
    protected long expiration_interval = 60000L;
    protected Future<?> expiry_task = null;
    protected final ConcurrentMap<Address, ConcurrentMap<Short, MessageQueue>> queues = Util.createConcurrentMap();
    protected String cluster_name;
    protected Address local_addr;
    protected Executor thread_pool;
    protected ThreadGroup thread_group;
    protected ThreadFactory thread_factory;
    protected TimeScheduler timer;

    @ManagedAttribute(description="Number of scopes in queues")
    public int getNumberOfReceiverScopes() {
        int retval = 0;
        for (ConcurrentMap map : this.queues.values()) {
            retval += map.keySet().size();
        }
        return retval;
    }

    @ManagedAttribute(description="Total number of messages in all queues")
    public int getNumberOfMessages() {
        int retval = 0;
        for (ConcurrentMap map : this.queues.values()) {
            for (MessageQueue queue : map.values()) {
                retval += queue.size();
            }
        }
        return retval;
    }

    @Property(name="thread_pool.min_threads", description="Minimum thread pool size for the regular thread pool")
    public void setThreadPoolMinThreads(int size) {
        this.thread_pool_min_threads = size;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setCorePoolSize(size);
        }
    }

    public int getThreadPoolMinThreads() {
        return this.thread_pool_min_threads;
    }

    @Property(name="thread_pool.max_threads", description="Maximum thread pool size for the regular thread pool")
    public void setThreadPoolMaxThreads(int size) {
        this.thread_pool_max_threads = size;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setMaximumPoolSize(size);
        }
    }

    public int getThreadPoolMaxThreads() {
        return this.thread_pool_max_threads;
    }

    @Property(name="thread_pool.keep_alive_time", description="Timeout in milliseconds to remove idle thread from regular pool")
    public void setThreadPoolKeepAliveTime(long time) {
        this.thread_pool_keep_alive_time = time;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setKeepAliveTime(time, TimeUnit.MILLISECONDS);
        }
    }

    public long getThreadPoolKeepAliveTime() {
        return this.thread_pool_keep_alive_time;
    }

    @Experimental
    @ManagedOperation(description="Removes all queues and scopes - only used for testing, might get removed any time !")
    public void removeAllQueues() {
        this.queues.clear();
    }

    @ManagedOperation(description="Expires the given scope around the cluster")
    public void expire(short scope) {
        ScopeHeader hdr = ScopeHeader.createExpireHeader(scope);
        Message expiry_msg = new Message();
        expiry_msg.putHeader(Global.SCOPE_ID, hdr);
        expiry_msg.setFlag((byte)16);
        this.down_prot.down(new Event(1, expiry_msg));
    }

    public void removeScope(Address member, short scope) {
        MessageQueue queue;
        if (member == null) {
            return;
        }
        ConcurrentMap val = (ConcurrentMap)this.queues.get(member);
        if (val != null && (queue = (MessageQueue)val.remove(scope)) != null) {
            queue.clear();
        }
    }

    @ManagedOperation(description="Dumps all scopes associated with members")
    public String dumpScopes() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.queues.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(new TreeSet(((ConcurrentMap)entry.getValue()).keySet())).append("\n");
        }
        return sb.toString();
    }

    @ManagedAttribute(description="Number of active thread in the pool")
    public int getNumActiveThreads() {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.thread_pool).getActiveCount();
        }
        return 0;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.timer = this.getTransport().getTimer();
        this.thread_group = new ThreadGroup(this.getTransport().getPoolThreadGroup(), "SCOPE Threads");
        this.thread_factory = new DefaultThreadFactory(this.thread_group, "SCOPE", false, true);
        this.setInAllThreadFactories(this.cluster_name, this.local_addr, this.thread_naming_pattern);
        if (this.expiration_interval > 0L && this.expiration_time <= 0L || this.expiration_interval <= 0L && this.expiration_time > 0L) {
            throw new IllegalArgumentException("expiration_interval (" + this.expiration_interval + ") and expiration_time (" + this.expiration_time + ") don't match");
        }
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.thread_pool = SCOPE.createThreadPool(this.thread_pool_min_threads, this.thread_pool_max_threads, this.thread_pool_keep_alive_time, this.thread_factory);
        if (this.expiration_interval > 0L && this.expiration_time > 0L) {
            this.startExpiryTask();
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.stopExpiryTask();
        SCOPE.shutdownThreadPool(this.thread_pool);
        for (ConcurrentMap map : this.queues.values()) {
            for (MessageQueue queue : map.values()) {
                queue.release();
            }
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: {
                this.handleView((View)evt.getArg());
                break;
            }
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.cluster_name = (String)evt.getArg();
                this.setInAllThreadFactories(this.cluster_name, this.local_addr, this.thread_naming_pattern);
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                if (!msg.isFlagSet((byte)16) || msg.isFlagSet((byte)1)) break;
                ScopeHeader hdr = (ScopeHeader)msg.getHeader(this.id);
                if (hdr == null) {
                    throw new IllegalStateException("message doesn't have a ScopeHeader attached");
                }
                if (hdr.type == 2) {
                    this.removeScope(msg.getSrc(), hdr.scope);
                    return null;
                }
                MessageQueue queue = this.getOrCreateQueue(msg.getSrc(), hdr.scope);
                queue.add(msg);
                if (!queue.acquire()) {
                    return null;
                }
                QueueThread thread = new QueueThread(queue);
                this.thread_pool.execute(thread);
                return null;
            }
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    protected MessageQueue getOrCreateQueue(Address sender, short scope) {
        MessageQueue queue;
        ConcurrentMap tmp;
        ConcurrentMap<Short, MessageQueue> val = (ConcurrentMap<Short, MessageQueue>)this.queues.get(sender);
        if (val == null && (tmp = this.queues.putIfAbsent(sender, val = Util.createConcurrentMap())) != null) {
            val = tmp;
        }
        if ((queue = (MessageQueue)val.get(scope)) == null) {
            queue = new MessageQueue();
            MessageQueue old = val.putIfAbsent(scope, queue);
            if (old != null) {
                queue = old;
            }
        }
        return queue;
    }

    protected synchronized void startExpiryTask() {
        if (this.expiry_task == null || this.expiry_task.isDone()) {
            this.expiry_task = this.timer.scheduleWithFixedDelay(new ExpiryTask(), this.expiration_interval, this.expiration_interval, TimeUnit.MILLISECONDS);
        }
    }

    protected synchronized void stopExpiryTask() {
        if (this.expiry_task != null) {
            this.expiry_task.cancel(true);
            this.expiry_task = null;
        }
    }

    protected static ExecutorService createThreadPool(int min_threads, int max_threads, long keep_alive_time, ThreadFactory factory) {
        ThreadManagerThreadPoolExecutor pool = new ThreadManagerThreadPoolExecutor(min_threads, max_threads, keep_alive_time, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
        pool.setThreadFactory(factory);
        pool.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        return pool;
    }

    protected static void shutdownThreadPool(Executor thread_pool) {
        if (thread_pool instanceof ExecutorService) {
            ExecutorService service = (ExecutorService)thread_pool;
            service.shutdownNow();
            try {
                service.awaitTermination(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void setInAllThreadFactories(String cluster_name, Address local_address, String pattern) {
        ThreadFactory[] factories;
        for (ThreadFactory factory : factories = new ThreadFactory[]{this.thread_factory}) {
            if (pattern != null) {
                factory.setPattern(pattern);
            }
            if (cluster_name != null) {
                factory.setClusterName(cluster_name);
            }
            if (local_address == null) continue;
            factory.setAddress(local_address.toString());
        }
    }

    private void handleView(View view) {
        Vector<Address> members = view.getMembers();
        HashSet keys = new HashSet(this.queues.keySet());
        keys.removeAll(members);
        for (Address key : keys) {
            this.clearQueue(key);
        }
    }

    public void clearQueue(Address member) {
        ConcurrentMap val = (ConcurrentMap)this.queues.remove(member);
        if (val != null) {
            Collection values = val.values();
            for (MessageQueue queue : values) {
                queue.clear();
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("removed " + member + " from receiver_table");
        }
    }

    public static class ScopeHeader
    extends Header {
        public static final byte MSG = 1;
        public static final byte EXPIRE = 2;
        byte type;
        short scope = 0;

        public static ScopeHeader createMessageHeader(short scope) {
            return new ScopeHeader(1, scope);
        }

        public static ScopeHeader createExpireHeader(short scope) {
            return new ScopeHeader(2, scope);
        }

        public ScopeHeader() {
        }

        private ScopeHeader(byte type, short scope) {
            this.type = type;
            this.scope = scope;
        }

        public short getScope() {
            return this.scope;
        }

        @Override
        public int size() {
            switch (this.type) {
                case 1: 
                case 2: {
                    return 3;
                }
            }
            throw new IllegalStateException("type has to be MSG or EXPIRE");
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            switch (this.type) {
                case 1: 
                case 2: {
                    out.writeShort(this.scope);
                    break;
                }
                default: {
                    throw new IllegalStateException("type has to be MSG or EXPIRE");
                }
            }
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            switch (this.type) {
                case 1: 
                case 2: {
                    this.scope = in.readShort();
                    break;
                }
                default: {
                    throw new IllegalStateException("type has to be MSG or EXPIRE");
                }
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(ScopeHeader.typeToString(this.type));
            switch (this.type) {
                case 1: 
                case 2: {
                    sb.append(": scope=").append(this.scope);
                    break;
                }
                default: {
                    sb.append("n/a");
                }
            }
            return sb.toString();
        }

        public static String typeToString(byte type) {
            switch (type) {
                case 1: {
                    return "MSG";
                }
                case 2: {
                    return "EXPIRE";
                }
            }
            return "n/a";
        }
    }

    protected class ExpiryTask
    implements Runnable {
        protected ExpiryTask() {
        }

        @Override
        public void run() {
            try {
                this._run();
            }
            catch (Throwable t) {
                SCOPE.this.log.error("failed expiring old scopes", t);
            }
        }

        protected void _run() {
            long current_time = System.currentTimeMillis();
            for (Map.Entry entry : SCOPE.this.queues.entrySet()) {
                ConcurrentMap map = (ConcurrentMap)entry.getValue();
                Iterator it = map.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry2 = it.next();
                    Short scope = (Short)entry2.getKey();
                    MessageQueue queue = (MessageQueue)entry2.getValue();
                    long diff = current_time - queue.getLastUpdate();
                    if (diff < SCOPE.this.expiration_time || queue.size() != 0) continue;
                    it.remove();
                    if (!SCOPE.this.log.isTraceEnabled()) continue;
                    SCOPE.this.log.trace("expired scope " + entry.getKey() + "::" + scope + " (" + diff + " ms old)");
                }
            }
        }
    }

    protected class QueueThread
    implements Runnable {
        protected final MessageQueue queue;
        protected boolean first = true;

        public QueueThread(MessageQueue queue) {
            this.queue = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            do {
                if (this.first) {
                    this.first = false;
                } else if (!this.queue.acquire()) {
                    return;
                }
                try {
                    Message msg_to_deliver;
                    while ((msg_to_deliver = this.queue.remove()) != null) {
                        try {
                            SCOPE.this.up_prot.up(new Event(1, msg_to_deliver));
                        }
                        catch (Throwable t) {
                            SCOPE.this.log.error("couldn't deliver message " + msg_to_deliver, t);
                        }
                    }
                }
                finally {
                    this.queue.release();
                }
            } while (this.queue.size() != 0);
        }
    }

    protected static class MessageQueue {
        private final Queue<Message> queue = new ConcurrentLinkedQueue<Message>();
        private final AtomicBoolean processing = new AtomicBoolean(false);
        private long last_update = System.currentTimeMillis();

        protected MessageQueue() {
        }

        public boolean acquire() {
            return this.processing.compareAndSet(false, true);
        }

        public boolean release() {
            boolean result = this.processing.compareAndSet(true, false);
            if (result) {
                this.last_update = System.currentTimeMillis();
            }
            return result;
        }

        public void add(Message msg) {
            this.queue.add(msg);
        }

        public Message remove() {
            return this.queue.poll();
        }

        public void clear() {
            this.queue.clear();
        }

        public int size() {
            return this.queue.size();
        }

        public long getLastUpdate() {
            return this.last_update;
        }
    }
}

