/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Digest;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@MBean(description="Computes the broadcast messages that are stable")
@DeprecatedProperty(names={"digest_timeout", "max_gossip_runs", "max_suspend_time"})
public class STABLE
extends Protocol {
    private static final long MAX_SUSPEND_TIME = 200000L;
    @Property(description="Average time to send a STABLE message. Default is 20000 msec")
    private long desired_avg_gossip = 20000L;
    @Property(description="Delay before stability message is sent. Default is 6000 msec")
    private long stability_delay = 6000L;
    @Property(description="Maximum number of bytes received in all messages before sending a STABLE message is triggered. Default is 0 (disabled)")
    private long max_bytes = 0L;
    private int num_stable_msgs_sent = 0;
    private int num_stable_msgs_received = 0;
    private int num_stability_msgs_sent = 0;
    private int num_stability_msgs_received = 0;
    private Address local_addr = null;
    private final Set<Address> mbrs = new LinkedHashSet<Address>();
    private final MutableDigest digest = new MutableDigest(10);
    private final Set<Address> votes = new HashSet<Address>();
    private final Lock lock = new ReentrantLock();
    private Future<?> stability_task_future = null;
    private final Lock stability_lock = new ReentrantLock();
    private Future<?> stable_task_future = null;
    private final Lock stable_task_lock = new ReentrantLock();
    private TimeScheduler timer = null;
    private long num_bytes_received = 0L;
    private final Lock received = new ReentrantLock();
    private boolean suspended = false;
    private boolean initialized = false;
    private Future<?> resume_task_future = null;
    private final Object resume_task_mutex = new Object();

    public long getDesiredAverageGossip() {
        return this.desired_avg_gossip;
    }

    public void setDesiredAverageGossip(long gossip_interval) {
        this.desired_avg_gossip = gossip_interval;
    }

    public long getMaxBytes() {
        return this.max_bytes;
    }

    public void setMaxBytes(long max_bytes) {
        this.max_bytes = max_bytes;
    }

    @ManagedAttribute(name="BytesReceived")
    public long getBytes() {
        return this.num_bytes_received;
    }

    @ManagedAttribute
    public int getStableSent() {
        return this.num_stable_msgs_sent;
    }

    @ManagedAttribute
    public int getStableReceived() {
        return this.num_stable_msgs_received;
    }

    @ManagedAttribute
    public int getStabilitySent() {
        return this.num_stability_msgs_sent;
    }

    @ManagedAttribute
    public int getStabilityReceived() {
        return this.num_stability_msgs_received;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute
    public boolean getStableTaskRunning() {
        this.stable_task_lock.lock();
        try {
            boolean bl = this.stable_task_future != null && !this.stable_task_future.isDone() && !this.stable_task_future.isCancelled();
            return bl;
        }
        finally {
            this.stable_task_lock.unlock();
        }
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_stable_msgs_received = 0;
        this.num_stable_msgs_sent = 0;
        this.num_stability_msgs_sent = 0;
        this.num_stability_msgs_received = 0;
    }

    @Override
    public Vector<Integer> requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(39);
        return retval;
    }

    private void suspend(long timeout) {
        if (!this.suspended) {
            this.suspended = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug("suspending message garbage collection");
            }
        }
        this.startResumeTask(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume() {
        this.lock.lock();
        try {
            this.resetDigest();
            this.suspended = false;
        }
        finally {
            this.lock.unlock();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("resuming message garbage collection");
        }
        this.stopResumeTask();
    }

    @Override
    public void init() throws Exception {
        super.init();
    }

    @Override
    public void start() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer cannot be retrieved");
        }
        if (this.desired_avg_gossip > 0L) {
            this.startStableTask();
        }
    }

    @Override
    public void stop() {
        this.stopStableTask();
    }

    @Override
    public Object up(Event evt) {
        int type = evt.getType();
        switch (type) {
            case 1: {
                Message msg = (Message)evt.getArg();
                StableHeader hdr = (StableHeader)msg.getHeader(this.id);
                if (hdr == null) {
                    this.handleRegularMessage(msg);
                    return this.up_prot.up(evt);
                }
                switch (hdr.type) {
                    case 1: {
                        this.handleStableMessage(msg.getSrc(), hdr.stableDigest);
                        break;
                    }
                    case 2: {
                        this.handleStabilityMessage(hdr.stableDigest, msg.getSrc());
                        break;
                    }
                    default: {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error("StableHeader type " + hdr.type + " not known");
                    }
                }
                return null;
            }
            case 6: {
                Object retval = this.up_prot.up(evt);
                View view = (View)evt.getArg();
                this.handleViewChange(view);
                return retval;
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRegularMessage(Message msg) {
        if (this.max_bytes <= 0L) {
            return;
        }
        Address dest = msg.getDest();
        if (dest == null || dest.isMulticastAddress()) {
            boolean send_stable_msg = false;
            this.received.lock();
            try {
                this.num_bytes_received += (long)msg.getLength();
                if (this.num_bytes_received >= this.max_bytes) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(new StringBuilder("max_bytes has been reached (").append(this.max_bytes).append(", bytes received=").append(this.num_bytes_received).append("): triggers stable msg"));
                    }
                    this.num_bytes_received = 0L;
                    send_stable_msg = true;
                }
            }
            finally {
                this.received.unlock();
            }
            if (send_stable_msg) {
                Digest my_digest = this.getDigest();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("setting latest_local_digest from NAKACK: " + my_digest.printHighestDeliveredSeqnos());
                }
                this.sendStableMessage(my_digest);
            }
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                Object retval = this.down_prot.down(evt);
                View v = (View)evt.getArg();
                this.handleViewChange(v);
                return retval;
            }
            case 65: {
                long timeout = 0L;
                Object t = evt.getArg();
                if (t != null && t instanceof Long) {
                    timeout = (Long)t;
                }
                this.suspend(timeout);
                break;
            }
            case 66: {
                this.resume();
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    @ManagedOperation
    public void runMessageGarbageCollection() {
        Digest copy = this.getDigest();
        this.sendStableMessage(copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleViewChange(View v) {
        Vector<Address> tmp = v.getMembers();
        Set<Address> set = this.mbrs;
        synchronized (set) {
            this.mbrs.clear();
            this.mbrs.addAll(tmp);
        }
        this.lock.lock();
        try {
            this.resetDigest();
            if (!this.initialized) {
                this.initialized = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean updateLocalDigest(Digest d, Address sender) {
        if (d == null || d.size() == 0) {
            return false;
        }
        if (!this.initialized) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("STABLE message will not be handled as I'm not yet initialized");
            }
            return false;
        }
        if (!this.digest.sameSenders(d)) {
            this.resetDigest();
            return false;
        }
        StringBuilder sb = null;
        if (this.log.isTraceEnabled()) {
            sb = new StringBuilder().append(this.local_addr).append(": handling digest from ").append(sender).append(" (").append(this.votes.size()).append(" votes):\nmine:   ").append(this.digest.printHighestDeliveredSeqnos()).append("\nother:  ").append(d.printHighestDeliveredSeqnos());
        }
        for (Map.Entry<Address, Digest.Entry> entry : d.getSenders().entrySet()) {
            Address mbr = entry.getKey();
            Digest.Entry val = entry.getValue();
            long low = val.getLow();
            long highest_seqno = val.getHighestDeliveredSeqno();
            long highest_seen_seqno = val.getHighestReceivedSeqno();
            long my_low = this.digest.lowSeqnoAt(mbr);
            long new_low = Math.min(my_low, low);
            long my_highest_seqno = this.digest.highestDeliveredSeqnoAt(mbr);
            long my_highest_seen_seqno = this.digest.highestReceivedSeqnoAt(mbr);
            long new_highest_seqno = Math.min(my_highest_seqno, highest_seqno);
            long new_highest_seen_seqno = Math.max(my_highest_seen_seqno, highest_seen_seqno);
            this.digest.setHighestDeliveredAndSeenSeqnos(mbr, new_low, new_highest_seqno, new_highest_seen_seqno);
        }
        if (this.log.isTraceEnabled()) {
            sb.append("\nresult: ").append(this.digest.printHighestDeliveredSeqnos()).append("\n");
            this.log.trace(sb);
        }
        return true;
    }

    private void resetDigest() {
        Digest tmp = this.getDigest();
        this.digest.replace(tmp);
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": resetting digest from NAKACK: " + this.digest.printHighestDeliveredSeqnos());
        }
        this.votes.clear();
    }

    private boolean addVote(Address mbr) {
        boolean added = this.votes.add(mbr);
        return added && this.allVotesReceived(this.votes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean allVotesReceived(Set<Address> votes) {
        Set<Address> set = this.mbrs;
        synchronized (set) {
            return ((Object)votes).equals(this.mbrs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startStableTask() {
        this.stable_task_lock.lock();
        try {
            if (this.stable_task_future == null || this.stable_task_future.isDone()) {
                StableTask stable_task = new StableTask();
                this.stable_task_future = this.timer.scheduleWithDynamicInterval(stable_task);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("stable task started");
                }
            }
        }
        finally {
            this.stable_task_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopStableTask() {
        this.stable_task_lock.lock();
        try {
            if (this.stable_task_future != null) {
                this.stable_task_future.cancel(false);
                this.stable_task_future = null;
            }
        }
        finally {
            this.stable_task_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startResumeTask(long max_suspend_time) {
        if ((max_suspend_time = (long)((double)max_suspend_time * 1.1)) <= 0L) {
            max_suspend_time = 200000L;
        }
        Object object = this.resume_task_mutex;
        synchronized (object) {
            if (this.resume_task_future == null || this.resume_task_future.isDone()) {
                ResumeTask resume_task = new ResumeTask();
                this.resume_task_future = this.timer.schedule(resume_task, max_suspend_time, TimeUnit.MILLISECONDS);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("resume task started, max_suspend_time=" + max_suspend_time);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopResumeTask() {
        Object object = this.resume_task_mutex;
        synchronized (object) {
            if (this.resume_task_future != null) {
                this.resume_task_future.cancel(false);
                this.resume_task_future = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startStabilityTask(Digest d, long delay) {
        this.stability_lock.lock();
        try {
            if (this.stability_task_future == null || this.stability_task_future.isDone()) {
                StabilitySendTask stability_task = new StabilitySendTask(d);
                this.stability_task_future = this.timer.schedule(stability_task, delay, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.stability_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopStabilityTask() {
        this.stability_lock.lock();
        try {
            if (this.stability_task_future != null) {
                this.stability_task_future.cancel(false);
                this.stability_task_future = null;
            }
        }
        finally {
            this.stability_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStableMessage(Address sender, Digest d) {
        if (d == null || sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("digest or sender is null");
            }
            return;
        }
        if (!this.initialized) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("STABLE message will not be handled as I'm not yet initialized");
            }
            return;
        }
        if (this.suspended) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("STABLE message will not be handled as I'm suspended");
            }
            return;
        }
        Digest copy = null;
        this.lock.lock();
        try {
            if (this.votes.contains(sender)) {
                return;
            }
            ++this.num_stable_msgs_received;
            boolean success = this.updateLocalDigest(d, sender);
            if (!success) {
                return;
            }
            boolean all_votes_received = this.addVote(sender);
            if (all_votes_received) {
                copy = this.digest.copy();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (copy != null) {
            this.sendStabilityMessage(copy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStabilityMessage(Digest stable_digest, Address sender) {
        if (stable_digest == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("stability digest is null");
            }
            return;
        }
        if (!this.initialized) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("STABLE message will not be handled as I'm not yet initialized");
            }
            return;
        }
        if (this.suspended) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("stability message will not be handled as I'm suspended");
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder(this.local_addr + ": received stability msg from ").append(sender).append(": ").append(stable_digest.printHighestDeliveredSeqnos()));
        }
        this.stopStabilityTask();
        this.lock.lock();
        try {
            if (!this.digest.sameSenders(stable_digest)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(this.local_addr + ": received digest from " + sender + " (digest=" + stable_digest + ") which does not match my own digest (" + this.digest + "): ignoring digest and re-initializing own digest");
                }
                this.resetDigest();
                return;
            }
            ++this.num_stability_msgs_received;
            this.resetDigest();
        }
        finally {
            this.lock.unlock();
        }
        this.down_prot.down(new Event(30, stable_digest));
    }

    private void sendStableMessage(Digest d) {
        if (this.suspended) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("will not send STABLE message as I'm suspended");
            }
            return;
        }
        if (d != null && d.size() > 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": sending stable msg " + d.printHighestDeliveredSeqnos());
            }
            ++this.num_stable_msgs_sent;
            final Message msg = new Message();
            msg.setFlag((byte)1);
            StableHeader hdr = new StableHeader(1, d);
            msg.putHeader(this.id, hdr);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    STABLE.this.down_prot.down(new Event(1, msg));
                }
            };
            this.timer.execute(r);
        }
    }

    private void sendStabilityMessage(Digest tmp) {
        if (this.suspended) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("STABILITY message will not be sent as I'm suspended");
            }
            return;
        }
        long delay = Util.random(this.stability_delay);
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": sending stability msg (in " + delay + " ms) " + tmp.printHighestDeliveredSeqnos() + " (copy=" + tmp.hashCode() + ")");
        }
        this.startStabilityTask(tmp, delay);
    }

    private Digest getDigest() {
        return (Digest)this.down_prot.down(Event.GET_DIGEST_EVT);
    }

    private class ResumeTask
    implements Runnable {
        ResumeTask() {
        }

        @Override
        public void run() {
            if (STABLE.this.suspended) {
                STABLE.this.log.warn("ResumeTask resumed message garbage collection - this should be done by a RESUME_STABLE event; check why this event was not received (or increase max_suspend_time for large state transfers)");
            }
            STABLE.this.resume();
        }
    }

    private class StabilitySendTask
    implements Runnable {
        Digest stability_digest = null;

        StabilitySendTask(Digest d) {
            this.stability_digest = d;
        }

        @Override
        public void run() {
            if (STABLE.this.suspended) {
                if (STABLE.this.log.isDebugEnabled()) {
                    STABLE.this.log.debug("STABILITY message will not be sent as suspended=" + STABLE.this.suspended);
                }
                return;
            }
            if (this.stability_digest != null) {
                Message msg = new Message();
                msg.setFlag((byte)1);
                StableHeader hdr = new StableHeader(2, this.stability_digest);
                msg.putHeader(STABLE.this.id, hdr);
                if (STABLE.this.log.isTraceEnabled()) {
                    STABLE.this.log.trace(STABLE.this.local_addr + ": sending stability msg " + this.stability_digest.printHighestDeliveredSeqnos() + " (copy=" + this.stability_digest.hashCode() + ")");
                }
                STABLE.this.num_stability_msgs_sent++;
                STABLE.this.down_prot.down(new Event(1, msg));
            }
        }
    }

    private class StableTask
    implements TimeScheduler.Task {
        private StableTask() {
        }

        @Override
        public long nextInterval() {
            long interval = this.computeSleepTime();
            if (interval <= 0L) {
                return 10000L;
            }
            return interval;
        }

        @Override
        public void run() {
            if (STABLE.this.suspended) {
                if (STABLE.this.log.isTraceEnabled()) {
                    STABLE.this.log.trace("stable task will not run as suspended=" + STABLE.this.suspended);
                }
                return;
            }
            Digest my_digest = STABLE.this.getDigest();
            if (my_digest == null) {
                if (STABLE.this.log.isWarnEnabled()) {
                    STABLE.this.log.warn("received null digest, skipped sending of stable message");
                }
                return;
            }
            if (STABLE.this.log.isTraceEnabled()) {
                STABLE.this.log.trace(STABLE.this.local_addr + ": setting latest_local_digest from NAKACK: " + my_digest.printHighestDeliveredSeqnos());
            }
            STABLE.this.sendStableMessage(my_digest);
        }

        long computeSleepTime() {
            return this.getRandom((long)STABLE.this.mbrs.size() * STABLE.this.desired_avg_gossip * 2L);
        }

        long getRandom(long range) {
            return (long)(Math.random() * (double)range % (double)range);
        }
    }

    public static class StableHeader
    extends Header {
        public static final int STABLE_GOSSIP = 1;
        public static final int STABILITY = 2;
        int type = 0;
        Digest stableDigest = null;

        public StableHeader() {
        }

        public StableHeader(int type, Digest digest) {
            this.type = type;
            this.stableDigest = digest;
        }

        static String type2String(int t) {
            switch (t) {
                case 1: {
                    return "STABLE_GOSSIP";
                }
                case 2: {
                    return "STABILITY";
                }
            }
            return "<unknown>";
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            sb.append(StableHeader.type2String(this.type));
            sb.append("]: digest is ");
            sb.append(this.stableDigest);
            return sb.toString();
        }

        @Override
        public int size() {
            int retval = 5;
            if (this.stableDigest != null) {
                retval = (int)((long)retval + this.stableDigest.serializedSize());
            }
            return retval;
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeInt(this.type);
            Util.writeStreamable(this.stableDigest, out);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readInt();
            this.stableDigest = (Digest)Util.readStreamable(Digest.class, in);
        }
    }
}

