/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.tests.perf.Data;
import org.jgroups.tests.perf.MemberInfo;
import org.jgroups.tests.perf.Receiver;
import org.jgroups.tests.perf.Transport;
import org.jgroups.util.Util;

public class Test
implements Receiver {
    String props = null;
    Properties config;
    boolean sender = false;
    Transport transport = null;
    Object local_addr = null;
    final Map<Object, MemberInfo> senders = Util.createConcurrentMap();
    final List members = new ArrayList();
    long start = 0L;
    long last_interval = 0L;
    long stop = 0L;
    int num_members = 0;
    int num_senders = 0;
    int warmup = 0;
    int num_buddies = 0;
    List buddies = null;
    long num_msgs_expected = 0L;
    long num_msgs_received = 0L;
    long num_bytes_received = 0L;
    Log log = LogFactory.getLog(this.getClass());
    final AtomicBoolean all_received = new AtomicBoolean(false);
    boolean final_results_received = false;
    final Map<Object, MemberInfo> results = Util.createConcurrentMap();
    private ResultsPublisher publisher = new ResultsPublisher();
    final List heard_from = new ArrayList();
    final List final_results_ok_list = new ArrayList();
    boolean dump_transport_stats = false;
    long log_interval = 1000L;
    long counter = 1L;
    long msg_size = 1000L;
    boolean jmx = false;
    long processing_delay = 0L;
    final Set start_msgs_received = new HashSet(12);
    FileWriter output = null;
    static NumberFormat f = NumberFormat.getNumberInstance();

    public void start(Properties c, boolean verbose, boolean jmx, String output, int num_threads, int num_buddies, int warmup) throws Exception {
        String line;
        String config_file = "config.txt";
        Properties tmp = new Properties();
        long num_msgs = 0L;
        if (output != null) {
            this.output = new FileWriter(output, false);
        }
        config_file = c.getProperty("config");
        BufferedReader fileReader = new BufferedReader(new FileReader(config_file));
        while ((line = fileReader.readLine()) != null) {
            if (line.startsWith("#") || (line = line.trim()).length() == 0) continue;
            StringTokenizer st = new StringTokenizer(line, "=", false);
            String key = st.nextToken().toLowerCase();
            String val = st.nextToken();
            tmp.put(key, val);
        }
        fileReader.close();
        this.warmup = warmup;
        tmp.putAll((Map<?, ?>)c);
        this.config = tmp;
        num_msgs = Integer.parseInt(this.config.getProperty("num_msgs"));
        if (num_threads > 0 && num_msgs % (long)num_threads != 0L) {
            throw new IllegalArgumentException("num_msgs (" + num_msgs + ") must be divisible by num_threads (" + num_threads + ")");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n----------------------- TEST -----------------------\n");
        sb.append("Date: ").append(new Date()).append('\n');
        sb.append("Run by: ").append(System.getProperty("user.name")).append("\n\n");
        if (verbose) {
            sb.append("Properties: ").append(Test.printProperties()).append("\n-------------------------\n\n");
        }
        for (Map.Entry<Object, Object> entry : this.config.entrySet()) {
            sb.append(entry.getKey()).append(":\t").append(entry.getValue()).append('\n');
        }
        sb.append("JGroups version: ").append("2.11.1.Final").append('\n');
        System.out.println("Configuration is: " + sb);
        this.output(sb.toString());
        this.props = this.config.getProperty("props");
        this.num_members = Integer.parseInt(this.config.getProperty("num_members"));
        this.num_senders = Integer.parseInt(this.config.getProperty("num_senders"));
        this.num_buddies = Integer.parseInt(this.config.getProperty("num_buddies", "0"));
        if (num_buddies > 0) {
            this.num_buddies = num_buddies;
        }
        if (num_buddies > this.num_members - 1) {
            throw new IllegalArgumentException("num_buddes (" + num_buddies + " cannot be greater than num_members -1 (" + (this.num_members - 1) + ")");
        }
        num_msgs = Long.parseLong(this.config.getProperty("num_msgs"));
        this.num_msgs_expected = (long)this.num_senders * num_msgs;
        this.sender = Boolean.valueOf(this.config.getProperty("sender"));
        this.msg_size = Long.parseLong(this.config.getProperty("msg_size"));
        String tmp2 = this.config.getProperty("dump_transport_stats", "false");
        if (Boolean.valueOf(tmp2).booleanValue()) {
            this.dump_transport_stats = true;
        }
        this.log_interval = (tmp2 = this.config.getProperty("log_interval")) != null ? Long.parseLong(tmp2) : num_msgs / 10L;
        if (num_threads > 0 && this.log_interval % (long)num_threads != 0L) {
            throw new IllegalArgumentException("log_interval (" + this.log_interval + ") must be divisible by num_threads (" + num_threads + ")");
        }
        sb = new StringBuilder();
        sb.append("\n##### msgs_received");
        sb.append(", current time (in ms)");
        sb.append(", msgs/sec");
        sb.append(", throughput/sec [KB]");
        sb.append(", free_mem [KB] ");
        sb.append(", total_mem [KB] ");
        this.output(sb.toString());
        if (jmx) {
            this.config.setProperty("jmx", "true");
        }
        this.jmx = Boolean.valueOf(this.config.getProperty("jmx"));
        String tmp3 = this.config.getProperty("processing_delay");
        if (tmp3 != null) {
            this.processing_delay = Long.parseLong(tmp3);
        }
        String transport_name = this.config.getProperty("transport");
        this.transport = (Transport)Util.loadClass(transport_name, this.getClass()).newInstance();
        this.transport.create(this.config);
        this.transport.setReceiver(this);
        this.transport.start();
        this.local_addr = this.transport.getLocalAddress();
    }

    private void output(String msg) {
        if (this.output != null) {
            try {
                this.output.write(msg + "\n");
                this.output.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String printProperties() {
        StringBuilder sb = new StringBuilder();
        Properties p = System.getProperties();
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
        }
        return sb.toString();
    }

    public void stop() {
        if (this.transport != null) {
            this.transport.stop();
            this.transport.destroy();
        }
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(Object sender, byte[] payload) {
        if (payload == null || payload.length == 0) {
            System.err.println("payload is incorrect (sender=" + sender + ")");
            return;
        }
        try {
            byte type = payload[0];
            if (type == 1) {
                int len = payload.length - 1;
                this.handleData(sender, len);
                return;
            }
            byte[] tmp = new byte[payload.length - 1];
            System.arraycopy(payload, 1, tmp, 0, tmp.length);
            Data d = (Data)Util.streamableFromByteBuffer(Data.class, tmp);
            switch (d.getType()) {
                case 1: {
                    this.sendDiscoveryResponse();
                    break;
                }
                case 8: {
                    break;
                }
                case 2: {
                    List list = this.members;
                    synchronized (list) {
                        if (!this.members.contains(sender)) {
                            this.members.add(sender);
                            System.out.println("-- " + sender + " joined");
                            if (d.sender && !this.senders.containsKey(sender)) {
                                this.senders.put(sender, new MemberInfo(d.num_msgs));
                            }
                            this.members.notifyAll();
                            if (this.num_buddies > 0) {
                                this.computeBuddies();
                            }
                        }
                        break;
                    }
                }
                case 4: {
                    this.results.put(sender, d.result);
                    this.heard_from.remove(sender);
                    if (this.heard_from.isEmpty()) {
                        for (int i = 0; i < 3; ++i) {
                            this.sendFinalResults();
                            Util.sleep(300L);
                        }
                    }
                    break;
                }
                case 5: {
                    if (!this.final_results_received) {
                        this.dumpResults(d.results);
                        this.final_results_received = true;
                    }
                    boolean done = false;
                    List list = this.final_results_ok_list;
                    synchronized (list) {
                        this.final_results_ok_list.remove(sender);
                        if (this.final_results_ok_list.isEmpty()) {
                            done = true;
                        }
                    }
                    if (done) {
                        for (int i = 0; i < 3; ++i) {
                            this.sendFinalResultsOk();
                            Util.sleep(300L);
                        }
                    }
                    break;
                }
                case 6: {
                    this.publisher.stop();
                    Test test = this;
                    synchronized (test) {
                        this.notifyAll();
                        break;
                    }
                }
                case 7: {
                    Set set = this.start_msgs_received;
                    synchronized (set) {
                        if (this.start_msgs_received.add(sender)) {
                            this.start_msgs_received.notifyAll();
                        }
                        break;
                    }
                }
                default: {
                    this.log.error("received invalid data type: " + payload[0]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void computeBuddies() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleData(Object sender, int num_bytes) {
        MemberInfo info = null;
        boolean do_sleep = false;
        if (this.all_received.get()) {
            return;
        }
        Test test = this;
        synchronized (test) {
            if (this.start == 0L) {
                this.start = this.last_interval = System.currentTimeMillis();
            }
            ++this.num_msgs_received;
            this.num_bytes_received += (long)num_bytes;
            if (this.num_msgs_received >= this.num_msgs_expected) {
                if (this.stop == 0L) {
                    this.stop = System.currentTimeMillis();
                }
                this.all_received.set(true);
            }
            if (this.num_msgs_received % this.log_interval == 0L) {
                long curr = System.currentTimeMillis();
                long diff = curr - this.last_interval;
                this.last_interval = curr;
                double msgs_sec = (double)this.log_interval / ((double)diff / 1000.0);
                double throughput = msgs_sec * (double)this.msg_size;
                System.out.println(new StringBuilder("-- received ").append(this.num_msgs_received).append(" messages").append(" (" + diff + " ms, " + f.format(msgs_sec) + " msgs/sec, " + Util.printBytes(throughput) + "/sec)"));
            }
            if (this.counter % this.log_interval == 0L) {
                this.output(this.dumpStats(this.counter));
            }
            if ((info = this.senders.get(sender)) != null) {
                if (info.start == 0L) {
                    info.start = System.currentTimeMillis();
                }
                ++info.num_msgs_received;
                ++this.counter;
                info.total_bytes_received += (long)num_bytes;
                if (info.num_msgs_received >= info.num_msgs_expected) {
                    info.done = true;
                    if (info.stop == 0L) {
                        info.stop = System.currentTimeMillis();
                    }
                } else if (this.processing_delay > 0L) {
                    do_sleep = true;
                }
            } else {
                this.log.error("-- sender " + sender + " not found in senders hashmap");
            }
        }
        if (do_sleep && this.processing_delay > 0L) {
            Util.sleep(this.processing_delay);
        }
        if (this.all_received.get()) {
            if (!this.sender) {
                this.dumpSenders();
            }
            this.publisher.start();
        }
    }

    private void sendResults() {
        Data d = new Data(4);
        MemberInfo info = new MemberInfo(this.num_msgs_expected);
        info.done = true;
        info.num_msgs_received = this.num_msgs_received;
        info.start = this.start;
        info.stop = this.stop;
        info.total_bytes_received = this.num_bytes_received;
        d.result = info;
        try {
            byte[] buf = Test.generatePayload(d, null);
            this.transport.send(null, buf, true);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    private void sendFinalResults() throws Exception {
        Data d = new Data(5);
        d.results = new ConcurrentHashMap<Object, MemberInfo>(this.results);
        byte[] buf = Test.generatePayload(d, null);
        try {
            this.transport.send(null, buf, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void sendFinalResultsOk() throws Exception {
        Data d = new Data(6);
        byte[] buf = Test.generatePayload(d, null);
        try {
            this.transport.send(null, buf, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    boolean receivedFinalResults() {
        return this.final_results_received;
    }

    void sendMessages(long interval, int nanos, boolean busy_sleep, int num_threads) throws Exception {
        long total_msgs = 0L;
        int msgSize = Integer.parseInt(this.config.getProperty("msg_size"));
        int num_msgs = Integer.parseInt(this.config.getProperty("num_msgs"));
        byte[] buf = new byte[msgSize];
        for (int k = 0; k < msgSize; ++k) {
            buf[k] = 46;
        }
        Data d = new Data(3);
        byte[] payload = Test.generatePayload(d, buf);
        StringBuilder sb = new StringBuilder();
        sb.append("-- sending ").append(num_msgs).append(" ").append(Util.printBytes(msgSize)).append(" messages");
        if (num_threads > 0) {
            sb.append(" in ").append(num_threads).append(" threads");
        }
        System.out.println(sb);
        if (num_threads > 0) {
            int number = num_msgs / num_threads;
            long thread_interval = this.log_interval / (long)num_threads;
            CyclicBarrier barrier = new CyclicBarrier(num_threads + 1);
            Thread[] threads = new Thread[num_threads];
            for (int i = 0; i < threads.length; ++i) {
                threads[i] = new Sender(barrier, number, payload, interval, nanos, busy_sleep, thread_interval);
                threads[i].setName("thread-" + (i + 1));
                threads[i].start();
            }
            barrier.await();
        } else {
            for (int i = 0; i < num_msgs; ++i) {
                this.transport.send(null, payload, false);
                if (++total_msgs % this.log_interval == 0L) {
                    System.out.println("++ sent " + total_msgs);
                }
                if (interval <= 0L && nanos <= 0) continue;
                if (busy_sleep) {
                    Util.sleep(interval, busy_sleep);
                    continue;
                }
                Util.sleep(interval, nanos);
            }
        }
    }

    void sendWarmupMessages(int num) throws Exception {
        Data data = new Data(8);
        data.payload = new byte[(int)this.msg_size];
        byte[] buf = Test.generatePayload(data, null);
        System.out.println("sending " + num + " warmup messages");
        for (int i = 0; i < num; ++i) {
            this.transport.send(null, buf, false);
        }
        System.out.println("done");
    }

    static byte[] generatePayload(Data d, byte[] buf) throws Exception {
        byte[] tmp = buf != null ? buf : Util.streamableToByteBuffer(d);
        byte[] payload = new byte[tmp.length + 1];
        payload[0] = Test.intToByte(d.getType());
        System.arraycopy(tmp, 0, payload, 1, tmp.length);
        return payload;
    }

    private static byte intToByte(int type) {
        switch (type) {
            case 3: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        return 0;
    }

    private void dumpResults(Map<Object, MemberInfo> final_results) {
        double tmp = 0.0;
        StringBuilder sb = new StringBuilder();
        sb.append("\n-- results:\n");
        for (Map.Entry<Object, MemberInfo> entry : final_results.entrySet()) {
            Object member = entry.getKey();
            MemberInfo val = entry.getValue();
            tmp += val.getMessageSec();
            sb.append("\n").append(member);
            if (member.equals(this.local_addr)) {
                sb.append(" (myself)");
            }
            sb.append(":\n");
            sb.append(val);
            sb.append('\n');
        }
        double combined_msgs_sec = tmp / (double)final_results.size();
        long combined_tp = (long)combined_msgs_sec * this.msg_size;
        sb.append("\ncombined: ").append(f.format(combined_msgs_sec)).append(" msgs/sec averaged over all receivers (throughput=" + Util.printBytes(combined_tp) + "/sec)\n");
        System.out.println(sb.toString());
        this.output(sb.toString());
    }

    private void dumpSenders() {
        StringBuilder sb = new StringBuilder();
        Test.dump(this.senders, sb);
        System.out.println(sb.toString());
    }

    private static void dump(Map<Object, MemberInfo> map, StringBuilder sb) {
        MemberInfo combined = new MemberInfo(0L);
        combined.start = Long.MAX_VALUE;
        combined.stop = Long.MIN_VALUE;
        sb.append("\n-- local results:\n");
        for (Map.Entry<Object, MemberInfo> entry : map.entrySet()) {
            Object mySender = entry.getKey();
            MemberInfo mi = entry.getValue();
            combined.start = Math.min(combined.start, mi.start);
            combined.stop = Math.max(combined.stop, mi.stop);
            combined.num_msgs_expected += mi.num_msgs_expected;
            combined.num_msgs_received += mi.num_msgs_received;
            combined.total_bytes_received += mi.total_bytes_received;
            sb.append("sender: ").append(mySender).append(": ").append(mi).append('\n');
        }
    }

    private String dumpStats(long received_msgs) {
        Map stats;
        StringBuilder sb = new StringBuilder();
        sb.append(received_msgs).append(' ');
        long current = System.currentTimeMillis();
        sb.append(current).append(' ');
        double msgs_sec = (double)received_msgs / ((double)(current - this.start) / 1000.0);
        double throughput_sec = msgs_sec * (double)this.msg_size;
        sb.append(f.format(msgs_sec)).append(' ').append(f.format(throughput_sec)).append(' ');
        sb.append((double)Runtime.getRuntime().freeMemory() / 1000.0).append(' ');
        sb.append((double)Runtime.getRuntime().totalMemory() / 1000.0);
        if (this.dump_transport_stats && (stats = this.transport.dumpStats()) != null) {
            Test.print(stats, sb);
        }
        return sb.toString();
    }

    public String dumpTransportStats() {
        Map stats = this.transport.dumpStats();
        StringBuilder sb = new StringBuilder(128);
        if (stats != null) {
            for (Map.Entry entry : stats.entrySet()) {
                String key = (String)entry.getKey();
                Map value = (Map)entry.getValue();
                sb.append("\n").append(key).append(":\n");
                Iterator it2 = value.entrySet().iterator();
                while (it2.hasNext()) {
                    sb.append(it2.next()).append("\n");
                }
            }
        }
        return sb.toString();
    }

    private static void print(Map stats, StringBuilder sb) {
        sb.append("\nTransport stats:\n\n");
        for (Map.Entry entry : stats.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            sb.append(key).append(": ").append(val).append("\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runDiscoveryPhase() throws Exception {
        List list;
        this.sendDiscoveryRequest();
        this.sendDiscoveryResponse();
        System.out.println("-- waiting for " + this.num_members + " members to join");
        boolean received_all_discovery_rsps = false;
        while (!received_all_discovery_rsps) {
            list = this.members;
            synchronized (list) {
                boolean bl = received_all_discovery_rsps = this.members.size() >= this.num_members;
                if (!received_all_discovery_rsps) {
                    this.members.wait(2000L);
                }
            }
            if (received_all_discovery_rsps) continue;
            this.sendDiscoveryRequest();
            this.sendDiscoveryResponse();
        }
        list = this.members;
        synchronized (list) {
            this.heard_from.addAll(this.members);
        }
        list = this.final_results_ok_list;
        synchronized (list) {
            this.final_results_ok_list.addAll(this.members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForAllOKs() throws Exception {
        this.sendStarted();
        boolean received_all_start_msgs = false;
        while (!received_all_start_msgs) {
            Set set = this.start_msgs_received;
            synchronized (set) {
                boolean bl = received_all_start_msgs = this.start_msgs_received.size() >= this.num_members;
                if (!received_all_start_msgs) {
                    this.start_msgs_received.wait(2000L);
                }
            }
            if (received_all_start_msgs) continue;
            this.sendStarted();
        }
        System.out.println("-- READY (" + this.start_msgs_received.size() + " acks)\n");
    }

    void sendStarted() throws Exception {
        this.transport.send(null, Test.generatePayload(new Data(7), null), true);
    }

    void sendDiscoveryRequest() throws Exception {
        Data d = new Data(1);
        this.transport.send(null, Test.generatePayload(d, null), true);
    }

    void sendDiscoveryResponse() throws Exception {
        Data d2 = new Data(2);
        if (this.sender) {
            d2.sender = true;
            d2.num_msgs = Long.parseLong(this.config.getProperty("num_msgs"));
        }
        this.transport.send(null, Test.generatePayload(d2, null), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Properties config = new Properties();
        boolean sender = false;
        boolean verbose = false;
        boolean jmx = false;
        boolean dump_stats = false;
        Test t = null;
        String output = null;
        long interval = 0L;
        int interval_nanos = 0;
        boolean busy_sleep = false;
        int num_threads = 0;
        int num_buddies = 0;
        int warmup = 0;
        for (int i = 0; i < args.length; ++i) {
            if ("-bind_addr".equals(args[i])) {
                String bind_addr = args[++i];
                System.setProperty("jgroups.bind_addr", bind_addr);
                continue;
            }
            if ("-sender".equals(args[i])) {
                config.put("sender", "true");
                sender = true;
                continue;
            }
            if ("-receiver".equals(args[i])) {
                config.put("sender", "false");
                sender = false;
                continue;
            }
            if ("-config".equals(args[i])) {
                String config_file = args[++i];
                config.put("config", config_file);
                continue;
            }
            if ("-props".equals(args[i])) {
                String props = args[++i];
                config.put("props", props);
                continue;
            }
            if ("-verbose".equals(args[i])) {
                verbose = true;
                continue;
            }
            if ("-jmx".equals(args[i])) {
                jmx = true;
                continue;
            }
            if ("-dump_stats".equals(args[i])) {
                dump_stats = true;
                continue;
            }
            if ("-num_threads".equals(args[i])) {
                num_threads = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-interval".equals(args[i])) {
                interval = Long.parseLong(args[++i]);
                continue;
            }
            if ("-nanos".equals(args[i])) {
                interval_nanos = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-busy_sleep".equals(args[i])) {
                busy_sleep = true;
                continue;
            }
            if ("-f".equals(args[i])) {
                output = args[++i];
                continue;
            }
            if ("-num_buddies".equals(args[i])) {
                num_buddies = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-warmup".equals(args[i])) {
                warmup = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-name".equals(args[i])) {
                String name = args[++i];
                config.setProperty("name", name);
                continue;
            }
            Test.help();
            return;
        }
        try {
            t = new Test();
            t.start(config, verbose, jmx, output, num_threads, num_buddies, warmup);
            t.runDiscoveryPhase();
            t.waitForAllOKs();
            if (sender) {
                if (warmup > 0) {
                    t.sendWarmupMessages(warmup);
                }
                t.sendMessages(interval, interval_nanos, busy_sleep, num_threads);
            }
            Test i = t;
            synchronized (i) {
                while (!t.receivedFinalResults()) {
                    t.wait(2000L);
                }
            }
            if (dump_stats) {
                String stats = t.dumpTransportStats();
                System.out.println("\nTransport statistics:\n" + stats);
            }
            if (t.jmx) {
                System.out.println("jmx=true: not terminating");
                if (t != null) {
                    t.stop();
                    t = null;
                }
                while (true) {
                    Util.sleep(60000L);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (t != null) {
                t.stop();
            }
        }
    }

    static void help() {
        System.out.println("Test [-help] ([-sender] | [-receiver]) [-config <config file>] [-num_threads <number of threads for sending messages>][-props <stack config>] [-verbose] [-jmx] [-bind_addr <bind address>[-dump_stats] [-f <filename>] [-interval <ms between sends>] [-nanos <additional nanos to sleep in interval>] [-busy_sleep (cancels out -nanos)] [-num_buddies <number of backup buddies>, this enables buddy replication] [-warmup <num messages>] [-name <logical name>]");
    }

    static {
        f.setGroupingUsed(false);
        f.setMaximumFractionDigits(2);
    }

    private class ResultsPublisher
    implements Runnable {
        static final long interval = 1000L;
        boolean running = true;
        volatile Thread thread;

        private ResultsPublisher() {
        }

        void start() {
            if (this.thread == null) {
                this.thread = new Thread((Runnable)this, "ResultsPublisher");
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }

        void stop() {
            if (this.thread != null && this.thread.isAlive()) {
                Thread tmp = this.thread;
                this.thread = null;
                if (tmp != null) {
                    tmp.interrupt();
                }
            }
        }

        @Override
        public void run() {
            while (this.thread != null) {
                Test.this.sendResults();
                Util.sleep(1000L);
            }
        }
    }

    class Sender
    extends Thread {
        CyclicBarrier barrier;
        int num_msgs = 0;
        byte[] payload;
        long total_msgs = 0L;
        long interval = 0L;
        boolean busy_sleep = false;
        int nanos = 0;
        long thread_interval;

        Sender(CyclicBarrier barrier, int num_msgs, byte[] payload, long interval, int nanos, boolean busy_sleep, long thread_interval) {
            this.barrier = barrier;
            this.num_msgs = num_msgs;
            this.payload = payload;
            this.interval = interval;
            this.nanos = nanos;
            this.busy_sleep = busy_sleep;
            this.thread_interval = thread_interval;
        }

        @Override
        public void run() {
            try {
                this.barrier.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
            catch (BrokenBarrierException e) {
                e.printStackTrace();
                return;
            }
            System.out.println("-- [" + this.getName() + "] sending " + this.num_msgs + " msgs");
            for (int i = 0; i < this.num_msgs; ++i) {
                try {
                    Test.this.transport.send(null, this.payload, false);
                    ++this.total_msgs;
                    if (this.total_msgs % Test.this.log_interval == 0L) {
                        System.out.println("++ sent " + this.total_msgs + " [" + this.getName() + "]");
                    }
                    if (this.interval <= 0L && this.nanos <= 0) continue;
                    if (this.busy_sleep) {
                        Util.sleep(this.interval, this.busy_sleep);
                        continue;
                    }
                    Util.sleep(this.interval, this.nanos);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

