/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock;

import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.impl.core.lock.LockRemover;
import org.exoplatform.services.jcr.impl.core.lock.WorkspaceLockManager;
import org.exoplatform.services.jcr.impl.proccess.WorkerService;

public class LockRemoverHolder {
    public final int DEFAULT_THREAD_COUNT = 1;
    private final WorkerService workerService;

    public LockRemoverHolder(RepositoryEntry entry) {
        this(null, entry);
    }

    public LockRemoverHolder(ExoContainerContext ctx, RepositoryEntry entry) {
        int threadCount = 1;
        if (entry != null && entry.getLockRemoverThreadsCount() > 0) {
            threadCount = entry.getLockRemoverThreadsCount();
        }
        this.workerService = new WorkerService(threadCount, "Lock Remover " + (ctx != null ? ctx.getName() : (entry == null ? "" : entry.getName())));
    }

    public LockRemover getLockRemover(WorkspaceLockManager lockManager) {
        return new LockRemover(this.workerService, lockManager);
    }

    public LockRemover getLockRemover(WorkspaceLockManager lockManager, long timeout) {
        return new LockRemover(this.workerService, lockManager, timeout);
    }
}

