/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.jbosscache;

import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.core.query.IndexerChangesFilter;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.IndexingTree;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.ChangesFilterListsWrapper;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.IndexerCacheLoader;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.IndexerSingletonStoreCacheLoader;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.JBossCacheIndexInfos;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.JBossCacheIndexUpdateMonitor;
import org.exoplatform.services.jcr.impl.core.query.lucene.ChangesHolder;
import org.exoplatform.services.jcr.jbosscache.ExoJBossCacheFactory;
import org.exoplatform.services.jcr.jbosscache.PrivilegedJBossCacheHelper;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.CacheLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheIndexChangesFilter
extends IndexerChangesFilter {
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.JBossCacheIndexChangesFilter");
    public static final String PARAM_JBOSSCACHE_CONFIGURATION = "jbosscache-configuration";
    public static final String PARAM_JBOSSCACHE_PUSHSTATE = "jbosscache-sscl-push.state.enabled";
    public static final String PARAM_JBOSSCACHE_PUSHSTATE_TIMEOUT = "jbosscache-sscl-push.state.timeout";
    public static final String PARAM_JBOSSCACHE_SHAREABLE = "jbosscache-shareable";
    public static final Boolean PARAM_JBOSSCACHE_SHAREABLE_DEFAULT = Boolean.FALSE;
    private final Cache<Serializable, Object> cache;
    private final Fqn<String> rootFqn;
    public static final String LISTWRAPPER = "$lists".intern();

    public JBossCacheIndexChangesFilter(SearchManager searchManager, SearchManager parentSearchManager, QueryHandlerEntry config, IndexingTree indexingTree, IndexingTree parentIndexingTree, QueryHandler handler, QueryHandler parentHandler, ConfigurationManager cfm) throws IOException, RepositoryException, RepositoryConfigurationException {
        super(searchManager, parentSearchManager, config, indexingTree, parentIndexingTree, handler, parentHandler, cfm);
        ExoJBossCacheFactory factory = new ExoJBossCacheFactory(cfm);
        Cache initCache = factory.createCache(config);
        IndexerCacheLoader indexerCacheLoader = new IndexerCacheLoader();
        CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig singletonStoreConfig = new CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig();
        singletonStoreConfig.setSingletonStoreClass(IndexerSingletonStoreCacheLoader.class.getName());
        Properties singletonStoreProperties = new Properties();
        Boolean pushState = config.getParameterBoolean(PARAM_JBOSSCACHE_PUSHSTATE, false);
        Long pushStateTimeOut = config.getParameterTime(PARAM_JBOSSCACHE_PUSHSTATE_TIMEOUT, 10000L);
        singletonStoreProperties.setProperty("pushStateWhenCoordinator", pushState.toString());
        singletonStoreProperties.setProperty("pushStateWhenCoordinatorTimeout", pushStateTimeOut.toString());
        singletonStoreConfig.setProperties(singletonStoreProperties);
        singletonStoreConfig.setSingletonStoreEnabled(true);
        CacheLoaderConfig.IndividualCacheLoaderConfig individualCacheLoaderConfig = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        individualCacheLoaderConfig.setSingletonStoreConfig(singletonStoreConfig);
        individualCacheLoaderConfig.setCacheLoader((CacheLoader)indexerCacheLoader);
        individualCacheLoaderConfig.setFetchPersistentState(false);
        individualCacheLoaderConfig.setAsync(false);
        individualCacheLoaderConfig.setIgnoreModifications(false);
        individualCacheLoaderConfig.setPurgeOnStartup(false);
        CacheLoaderConfig cacheLoaderConfig = new CacheLoaderConfig();
        cacheLoaderConfig.setShared(false);
        cacheLoaderConfig.setPassivation(false);
        cacheLoaderConfig.addIndividualCacheLoaderConfig(individualCacheLoaderConfig);
        initCache.getConfiguration().setCacheLoaderConfig(cacheLoaderConfig);
        this.rootFqn = Fqn.fromElements((Object[])new String[]{searchManager.getWsId()});
        this.cache = ExoJBossCacheFactory.getUniqueInstance(ExoJBossCacheFactory.CacheType.INDEX_CACHE, this.rootFqn, initCache, config.getParameterBoolean(PARAM_JBOSSCACHE_SHAREABLE, PARAM_JBOSSCACHE_SHAREABLE_DEFAULT));
        PrivilegedJBossCacheHelper.create(this.cache);
        PrivilegedJBossCacheHelper.start(this.cache);
        IndexerIoMode ioMode = ((CacheSPI)this.cache).getRPCManager().isCoordinator() ? IndexerIoMode.READ_WRITE : IndexerIoMode.READ_ONLY;
        IndexerSingletonStoreCacheLoader issCacheLoader = (IndexerSingletonStoreCacheLoader)((CacheSPI)this.cache).getCacheLoaderManager().getCacheLoader();
        indexerCacheLoader = (IndexerCacheLoader)issCacheLoader.getCacheLoader();
        indexerCacheLoader.register(searchManager, parentSearchManager, handler, parentHandler);
        IndexerIoModeHandler modeHandler = indexerCacheLoader.getModeHandler();
        handler.setIndexerIoModeHandler(modeHandler);
        parentHandler.setIndexerIoModeHandler(modeHandler);
        if (!parentHandler.isInitialized()) {
            parentHandler.setIndexInfos(new JBossCacheIndexInfos(this.rootFqn, this.cache, true, modeHandler));
            parentHandler.setIndexUpdateMonitor(new JBossCacheIndexUpdateMonitor(this.rootFqn, this.cache, true, modeHandler));
            parentHandler.init();
        }
        if (!handler.isInitialized()) {
            handler.setIndexInfos(new JBossCacheIndexInfos(this.rootFqn, this.cache, false, modeHandler));
            handler.setIndexUpdateMonitor(new JBossCacheIndexUpdateMonitor(this.rootFqn, this.cache, false, modeHandler));
            handler.init();
        }
    }

    @Override
    protected void doUpdateIndex(Set<String> removedNodes, Set<String> addedNodes, Set<String> parentRemovedNodes, Set<String> parentAddedNodes) {
        ChangesHolder changes = this.searchManager.getChanges(removedNodes, addedNodes);
        ChangesHolder parentChanges = this.parentSearchManager.getChanges(parentRemovedNodes, parentAddedNodes);
        if (changes == null && parentChanges == null) {
            return;
        }
        String id = IdGenerator.generate();
        try {
            PrivilegedJBossCacheHelper.put(this.cache, Fqn.fromRelativeElements(this.rootFqn, (Object[])new String[]{id}), (Serializable)((Object)LISTWRAPPER), (Object)new ChangesFilterListsWrapper(changes, parentChanges));
        }
        catch (CacheException e) {
            this.log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            this.logErrorChanges(this.handler, removedNodes, addedNodes);
            this.logErrorChanges(this.parentHandler, parentRemovedNodes, parentAddedNodes);
        }
    }

    private void logErrorChanges(QueryHandler logHandler, Set<String> removedNodes, Set<String> addedNodes) {
        try {
            logHandler.logErrorChanges(addedNodes, removedNodes);
        }
        catch (IOException ioe) {
            this.log.warn((Object)("Exception occure when errorLog writed. Error log is not complete. " + ioe), (Throwable)ioe);
        }
    }

    @Override
    public boolean isShared() {
        return true;
    }
}

