/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.IndexInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexingQueueStore {
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.IndexingQueueStore");
    private static final String ENCODING = "UTF-8";
    private static final String ADD = "ADD";
    private static final String REMOVE = "REMOVE";
    private static final String INDEXING_QUEUE_FILE = "indexing_queue.log";
    private final Set pending = new HashSet();
    private final Directory dir;

    IndexingQueueStore(Directory directory) throws IOException {
        this.dir = directory;
        this.readStore();
    }

    public String[] getPending() {
        return this.pending.toArray(new String[this.pending.size()]);
    }

    public void addUUID(String uuid) {
        this.pending.add(uuid);
    }

    public void removeUUID(String uuid) {
        this.pending.remove(uuid);
    }

    public void close() {
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (IndexingQueueStore.this.pending.isEmpty()) {
                    try {
                        if (IndexingQueueStore.this.dir.fileExists(IndexingQueueStore.INDEXING_QUEUE_FILE)) {
                            IndexingQueueStore.this.dir.deleteFile(IndexingQueueStore.INDEXING_QUEUE_FILE);
                        }
                    }
                    catch (IOException e) {
                        log.warn("unable to delete indexing_queue.log");
                    }
                }
                return null;
            }
        });
    }

    private void readStore() throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                if (IndexingQueueStore.this.dir.fileExists(IndexingQueueStore.INDEXING_QUEUE_FILE)) {
                    IndexInputStream in = new IndexInputStream(IndexingQueueStore.this.dir.openInput(IndexingQueueStore.INDEXING_QUEUE_FILE));
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, IndexingQueueStore.ENCODING));
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            int idx = line.indexOf(32);
                            if (idx == -1) {
                                log.warn("invalid line in {}: {}", (Object)IndexingQueueStore.INDEXING_QUEUE_FILE, (Object)line);
                                continue;
                            }
                            String cmd = line.substring(0, idx);
                            String uuid = line.substring(idx + 1, line.length());
                            if (IndexingQueueStore.ADD.equals(cmd)) {
                                IndexingQueueStore.this.pending.add(uuid);
                                continue;
                            }
                            if (IndexingQueueStore.REMOVE.equals(cmd)) {
                                IndexingQueueStore.this.pending.remove(uuid);
                                continue;
                            }
                            log.warn("invalid line in {}: {}", (Object)IndexingQueueStore.INDEXING_QUEUE_FILE, (Object)line);
                        }
                        Object var8_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        ((InputStream)in).close();
                        throw throwable;
                    }
                    ((InputStream)in).close();
                    {
                    }
                }
                return null;
            }
        });
    }
}

