/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.store.Directory;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.IndexInputStream;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.IndexOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RedoLog {
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.RedoLog");
    private static final String REDO_LOG = "redo.log";
    private final ActionCollector ENTRY_COUNTER = new ActionCollector(){

        public void collect(MultiIndex.Action a) {
            RedoLog.this.entryCount++;
        }
    };
    private final Directory dir;
    private int entryCount = 0;
    private Writer out;

    RedoLog(Directory dir) throws IOException {
        this.dir = dir;
        this.read(this.ENTRY_COUNTER);
    }

    boolean hasEntries() {
        return this.entryCount > 0;
    }

    int getSize() {
        return this.entryCount;
    }

    List<MultiIndex.Action> getActions() throws IOException {
        final ArrayList<MultiIndex.Action> actions = new ArrayList<MultiIndex.Action>();
        this.read(new ActionCollector(){

            public void collect(MultiIndex.Action a) {
                actions.add(a);
            }
        });
        return actions;
    }

    void append(final MultiIndex.Action action) throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                RedoLog.this.initOut();
                RedoLog.this.out.write(action.toString() + "\n");
                RedoLog.this.entryCount++;
                return null;
            }
        });
    }

    void flush() throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                if (RedoLog.this.out != null) {
                    RedoLog.this.out.flush();
                }
                return null;
            }
        });
    }

    synchronized void clear() throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                if (RedoLog.this.out != null) {
                    RedoLog.this.out.close();
                    RedoLog.this.out = null;
                }
                try {
                    RedoLog.this.dir.deleteFile(RedoLog.REDO_LOG);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                RedoLog.this.entryCount = 0;
                return null;
            }
        });
    }

    private synchronized void initOut() throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                if (RedoLog.this.out == null) {
                    IndexOutputStream os = new IndexOutputStream(RedoLog.this.dir.createOutput(RedoLog.REDO_LOG));
                    RedoLog.this.out = new BufferedWriter(new OutputStreamWriter(os));
                }
                return null;
            }
        });
    }

    private void read(final ActionCollector collector) throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object run() throws Exception {
                if (!RedoLog.this.dir.fileExists(RedoLog.REDO_LOG)) {
                    return null;
                }
                IndexInputStream in = new IndexInputStream(RedoLog.this.dir.openInput(RedoLog.REDO_LOG));
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    while ((line = reader.readLine()) != null) {
                        try {
                            collector.collect(MultiIndex.Action.fromString(line));
                        }
                        catch (IllegalArgumentException e) {
                            log.warn("Malformed redo entry: " + e.getMessage());
                        }
                    }
                    Object var6_5 = null;
                    if (in == null) return null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (in == null) throw throwable;
                    try {
                        ((InputStream)in).close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.warn("Exception while closing redo log: " + e.toString());
                    }
                    throw throwable;
                }
                try {
                    ((InputStream)in).close();
                    return null;
                }
                catch (IOException e) {
                    log.warn("Exception while closing redo log: " + e.toString());
                }
                return null;
            }
        });
    }

    static interface ActionCollector {
        public void collect(MultiIndex.Action var1);
    }
}

