/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlRootElement;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.Util;

@Path(value="{portalName}/social/spaces")
public class SpacesRestService
implements ResourceContainer {
    private SpaceService _spaceService;
    private IdentityManager _identityManager;
    private static final String CONFIRMED_STATUS = "confirmed";
    private static final String PENDING_STATUS = "pending";
    private static final String INCOMING_STATUS = "incoming";
    private static final String PUBLIC_STATUS = "public";
    private String portalContainerName;

    private SpaceList showMySpaceList(String userId) {
        List mySpaces;
        SpaceList spaceList = new SpaceList();
        this._spaceService = this.getSpaceService();
        try {
            mySpaces = this._spaceService.getSpaces(userId);
        }
        catch (SpaceException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        spaceList.setSpaces(mySpaces);
        return spaceList;
    }

    private SpaceList showPendingSpaceList(String userId) {
        List pendingSpaces;
        SpaceList spaceList = new SpaceList();
        this._spaceService = this.getSpaceService();
        try {
            pendingSpaces = this._spaceService.getPendingSpaces(userId);
        }
        catch (SpaceException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        spaceList.setSpaces(pendingSpaces);
        return spaceList;
    }

    @GET
    @Path(value="mySpaces/show.{format}")
    public Response showMySpaceList(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        ConversationState state = ConversationState.getCurrent();
        this.portalContainerName = portalName;
        String userId = null;
        userId = state != null ? state.getIdentity().getUserId() : Util.getViewerId(uriInfo);
        SpaceList mySpaceList = this.showMySpaceList(userId);
        return Util.getResponse(mySpaceList, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="pendingSpaces/show.{format}")
    public Response showPendingSpaceList(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        this.portalContainerName = portalName;
        if (!userId.equals(Util.getViewerId(uriInfo))) {
            return null;
        }
        SpaceList pendingSpaceList = this.showPendingSpaceList(userId);
        return Util.getResponse(pendingSpaceList, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="suggest.{format}")
    public Response suggestSpacenames(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @QueryParam(value="conditionToSearch") String conditionToSearch, @QueryParam(value="typeOfRelation") String typeOfRelation, @QueryParam(value="currentUser") String userId, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        SpaceNameList nameList = new SpaceNameList();
        this.portalContainerName = portalName;
        SpaceService spaceSrv = this.getSpaceService();
        List spaces = spaceSrv.getSpacesBySearchCondition(conditionToSearch);
        for (Space space : spaces) {
            if (PENDING_STATUS.equals(typeOfRelation) && spaceSrv.isPending(space, userId)) {
                nameList.addName(space.getDisplayName());
                continue;
            }
            if (INCOMING_STATUS.equals(typeOfRelation) && spaceSrv.isInvited(space, userId)) {
                nameList.addName(space.getDisplayName());
                continue;
            }
            if (CONFIRMED_STATUS.equals(typeOfRelation) && spaceSrv.isMember(space, userId)) {
                nameList.addName(space.getDisplayName());
                continue;
            }
            if (!PUBLIC_STATUS.equals(typeOfRelation) || space.getVisibility().equals("hidden") || spaceSrv.isPending(space, userId) || spaceSrv.isInvited(space, userId) || spaceSrv.isMember(space, userId)) continue;
            nameList.addName(space.getDisplayName());
        }
        return Util.getResponse(nameList, uriInfo, mediaType, Response.Status.OK);
    }

    private SpaceService getSpaceService() {
        return (SpaceService)this.getPortalContainer().getComponentInstanceOfType(SpaceService.class);
    }

    private IdentityManager getIdentityManager() {
        if (this._identityManager == null) {
            this._identityManager = (IdentityManager)this.getPortalContainer().getComponentInstanceOfType(IdentityManager.class);
        }
        return this._identityManager;
    }

    private PortalContainer getPortalContainer() {
        return (PortalContainer)ExoContainerContext.getContainerByName((String)this.portalContainerName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlRootElement
    public static class SpaceNameList {
        private List<String> _names;

        public void setNames(List<String> names) {
            this._names = names;
        }

        public List<String> getNames() {
            return this._names;
        }

        public void addName(String name) {
            if (this._names == null) {
                this._names = new ArrayList<String>();
            }
            this._names.add(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlRootElement
    public static class SpaceList {
        private List<Space> _spaces;

        public void setSpaces(List<Space> spaces) {
            this._spaces = spaces;
        }

        public List<Space> getSpaces() {
            return this._spaces;
        }

        public void addSpace(Space space) {
            if (this._spaces == null) {
                this._spaces = new ArrayList<Space>();
            }
            this._spaces.add(space);
        }
    }
}

