/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.apt;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.chromattic.apt.FormatterStyle;
import org.chromattic.apt.Instrumented;
import org.chromattic.apt.Invoker;
import org.chromattic.apt.TypeFormatter;
import org.chromattic.spi.instrument.MethodHandler;
import org.reflext.api.ClassKind;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.VoidTypeInfo;
import org.reflext.api.introspection.MethodIntrospector;
import org.reflext.api.visit.HierarchyScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProxyTypeGenerator {
    private final ClassTypeInfo type;

    ProxyTypeGenerator(ClassTypeInfo type) {
        this.type = type;
    }

    void build(StringBuilder code) {
        String simpleClassName = this.type.getSimpleName() + "_Chromattic";
        code.append("package ").append(this.type.getPackageName()).append(";\n");
        code.append("import ").append(Invoker.class.getName()).append(";\n");
        code.append("import ").append(Instrumented.class.getName()).append(";\n");
        code.append("public class ");
        code.append(simpleClassName);
        code.append(" extends ");
        if (this.type.getKind() == ClassKind.INTERFACE) {
            code.append(Object.class.getName());
            code.append(" implements ");
            code.append(this.type.getSimpleName());
            code.append(",");
            code.append(Instrumented.class.getSimpleName());
        } else {
            code.append(this.type.getSimpleName());
            code.append(" implements ");
            code.append(Instrumented.class.getSimpleName());
        }
        code.append(" {\n");
        this.appendContructor(code);
        this.appendMethods(code);
        code.append("}\n");
    }

    private void appendContructor(StringBuilder code) {
        code.append("public final ").append(MethodHandler.class.getName()).append(" handler;\n");
        code.append("public ").append(this.type.getSimpleName()).append("_Chromattic(").append(MethodHandler.class.getName()).append(" handler) {\n");
        code.append("this.handler = handler;\n");
        code.append("}\n");
    }

    private void appendMethods(StringBuilder code) {
        int id = 0;
        Iterable<MethodInfo> methods = this.getMethodsToImplement();
        for (MethodInfo method : methods) {
            String scope;
            String methodId = "method_" + id++;
            String methodName = method.getName();
            List parameterTypes = method.getParameterTypes();
            TypeInfo rti = method.getReturnType();
            switch (method.getAccess()) {
                case PACKAGE_PROTECTED: {
                    scope = "";
                    break;
                }
                case PROTECTED: {
                    scope = "protected";
                    break;
                }
                case PUBLIC: {
                    scope = "public";
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            code.append("private static final ").append(Invoker.class.getSimpleName()).append(" ").append(methodId).append(" = ").append(Invoker.class.getSimpleName()).append(".getDeclaredMethod(").append(method.getOwner().getName()).append(".class,").append('\"').append(methodName).append('\"');
            for (TypeInfo parameterType : parameterTypes) {
                code.append(",");
                new TypeFormatter(this.type, FormatterStyle.LITERAL, code).format(parameterType);
                code.append(".class");
            }
            code.append(");\n");
            code.append(scope).append(" final ");
            new TypeFormatter(this.type, FormatterStyle.RETURN_TYPE, code).format(rti);
            code.append(" ").append(methodName).append("(");
            for (int i = 0; i < parameterTypes.size(); ++i) {
                TypeInfo parameterType;
                parameterType = (TypeInfo)parameterTypes.get(i);
                if (i > 0) {
                    code.append(",");
                }
                new TypeFormatter(this.type, FormatterStyle.TYPE_PARAMETER, code).format(parameterType);
                code.append(" arg_").append(i);
            }
            code.append(")");
            LinkedHashSet<String> catched = new LinkedHashSet<String>();
            boolean hasThrown = false;
            for (ClassTypeInfo thrownCTI : method.getThrownTypes()) {
                if (hasThrown) {
                    code.append(", ");
                } else {
                    code.append(" throws ");
                    hasThrown = true;
                }
                code.append(thrownCTI.getName());
                catched.add(thrownCTI.getName());
            }
            catched.add(RuntimeException.class.getName());
            catched.add(Error.class.getName());
            code.append(" {\n");
            code.append("try {\n");
            switch (parameterTypes.size()) {
                case 0: {
                    if (rti instanceof VoidTypeInfo) {
                        code.append("handler.invoke(this,").append(methodId).append(".getMethod());\n");
                        break;
                    }
                    code.append("return (");
                    new TypeFormatter(this.type, FormatterStyle.CAST, code).format(rti);
                    code.append(")");
                    code.append("handler.invoke(this,").append(methodId).append(".getMethod());\n");
                    break;
                }
                case 1: {
                    if (rti instanceof VoidTypeInfo) {
                        code.append("handler.invoke(this,").append(methodId).append(".getMethod(),(Object)arg_0);\n");
                        break;
                    }
                    code.append("return (");
                    new TypeFormatter(this.type, FormatterStyle.CAST, code).format(rti);
                    code.append(")");
                    code.append("handler.invoke(this,").append(methodId).append(".getMethod(),(Object)arg_0);\n");
                    break;
                }
                default: {
                    code.append("Object[] args = new Object[]{");
                    for (int i = 0; i < parameterTypes.size(); ++i) {
                        if (i > 0) {
                            code.append(",");
                        }
                        code.append("arg_").append(i);
                    }
                    code.append("};\n");
                    if (rti instanceof VoidTypeInfo) {
                        code.append("handler.invoke(this,").append(methodId).append(".getMethod(),args);\n");
                        break;
                    }
                    code.append("return (");
                    new TypeFormatter(this.type, FormatterStyle.CAST, code).format(rti);
                    code.append(")");
                    code.append("handler.invoke(this,").append(methodId).append(".getMethod(),args);\n");
                }
            }
            code.append("} catch(Throwable t) {\n");
            for (String c : catched) {
                code.append("if (t instanceof ").append(c).append(") throw (").append(c).append(")t;\n");
            }
            code.append("throw new java.lang.reflect.UndeclaredThrowableException(t);\n");
            code.append("}\n");
            code.append("}\n");
        }
    }

    private Iterable<MethodInfo> getMethodsToImplement() {
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        MethodIntrospector introspector = new MethodIntrospector(HierarchyScope.ALL, true);
        for (MethodInfo method : introspector.getMethods((TypeInfo)this.type)) {
            if (!method.isAbstract()) continue;
            methods.add(method);
        }
        return methods;
    }
}

