/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Calendar;
import java.util.Properties;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.jempbox.xmp.XMPSchemaBasic;
import org.apache.jempbox.xmp.XMPSchemaDublinCore;
import org.apache.jempbox.xmp.XMPSchemaPDF;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.exceptions.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.util.PDFTextStripper;
import org.exoplatform.services.document.DCMetaData;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PDFDocumentReader
extends BaseDocumentReader {
    protected static Log log = ExoLogger.getLogger((String)"exo.core.component.document.PDFDocumentReader");

    public String[] getMimeTypes() {
        return new String[]{"application/pdf"};
    }

    public String getContentAsText(final InputStream is) throws IOException, DocumentReadException {
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws Exception {
                    if (is == null) {
                        throw new NullPointerException("InputStream is null.");
                    }
                    PDDocument pdDocument = null;
                    StringWriter sw = new StringWriter();
                    try {
                        if (is.available() == 0) {
                            String string = "";
                            return string;
                        }
                        try {
                            pdDocument = PDDocument.load((InputStream)is);
                        }
                        catch (IOException e) {
                            throw new DocumentReadException("Can not load PDF document.", e);
                        }
                        PDFTextStripper stripper = new PDFTextStripper();
                        stripper.setStartPage(1);
                        stripper.setEndPage(Integer.MAX_VALUE);
                        stripper.writeText(pdDocument, (Writer)sw);
                    }
                    finally {
                        if (pdDocument != null) {
                            try {
                                pdDocument.close();
                            }
                            catch (IOException e) {}
                        }
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    return sw.toString();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    public Properties getProperties(final InputStream is) throws IOException, DocumentReadException {
        try {
            return (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws Exception {
                    Properties props;
                    block67: {
                        if (is == null) {
                            throw new NullPointerException("InputStream is null.");
                        }
                        PDDocument pdDocument = PDDocument.load((InputStream)is);
                        props = new Properties();
                        try {
                            PDDocumentCatalog catalog;
                            PDMetadata meta;
                            if (pdDocument.isEncrypted()) {
                                try {
                                    pdDocument.decrypt("");
                                }
                                catch (InvalidPasswordException e) {
                                    throw new DocumentReadException("The pdf document is encrypted.", e);
                                }
                                catch (CryptographyException e) {
                                    throw new DocumentReadException(e.getMessage(), e);
                                }
                            }
                            if ((meta = (catalog = pdDocument.getDocumentCatalog()).getMetadata()) != null) {
                                XMPSchemaBasic basic;
                                XMPSchemaPDF pdf;
                                XMPMetadata metadata = meta.exportXMPMetadata();
                                XMPSchemaDublinCore dc = metadata.getDublinCoreSchema();
                                if (dc != null) {
                                    try {
                                        if (dc.getTitle() != null) {
                                            props.put(DCMetaData.TITLE, dc.getTitle());
                                        }
                                    }
                                    catch (Exception e) {
                                        log.warn((Object)("getTitle failed: " + e));
                                    }
                                    try {
                                        if (dc.getDescription() != null) {
                                            props.put(DCMetaData.DESCRIPTION, dc.getDescription());
                                        }
                                    }
                                    catch (Exception e) {
                                        log.warn((Object)("getSubject failed: " + e));
                                    }
                                    try {
                                        if (dc.getCreators() != null) {
                                            for (String creator : dc.getCreators()) {
                                                props.put(DCMetaData.CREATOR, creator);
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        log.warn((Object)("getCreator failed: " + e));
                                    }
                                    try {
                                        if (dc.getDates() != null) {
                                            for (Calendar date : dc.getDates()) {
                                                props.put(DCMetaData.DATE, date);
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        log.warn((Object)("getDate failed: " + e));
                                    }
                                }
                                if ((pdf = metadata.getPDFSchema()) != null) {
                                    try {
                                        if (pdf.getKeywords() != null) {
                                            props.put(DCMetaData.SUBJECT, pdf.getKeywords());
                                        }
                                    }
                                    catch (Exception e) {
                                        log.warn((Object)("getKeywords failed: " + e));
                                    }
                                    try {
                                        if (pdf.getProducer() != null) {
                                            props.put(DCMetaData.PUBLISHER, pdf.getProducer());
                                        }
                                    }
                                    catch (Exception e) {
                                        log.warn((Object)("getProducer failed: " + e));
                                    }
                                }
                                if ((basic = metadata.getBasicSchema()) == null) break block67;
                                try {
                                    if (basic.getCreateDate() != null) {
                                        props.put(DCMetaData.DATE, basic.getCreateDate());
                                    }
                                }
                                catch (Exception e) {
                                    log.warn((Object)("getCreationDate failed: " + e));
                                }
                                try {
                                    if (basic.getModifyDate() != null) {
                                        props.put(DCMetaData.DATE, basic.getModifyDate());
                                    }
                                    break block67;
                                }
                                catch (Exception e) {
                                    log.warn((Object)("getModificationDate failed: " + e));
                                }
                                break block67;
                            }
                            PDDocumentInformation docInfo = pdDocument.getDocumentInformation();
                            if (docInfo == null) break block67;
                            try {
                                if (docInfo.getAuthor() != null) {
                                    props.put(DCMetaData.CONTRIBUTOR, docInfo.getAuthor());
                                }
                            }
                            catch (Exception e) {
                                log.warn((Object)("getAuthor failed: " + e));
                            }
                            try {
                                if (docInfo.getCreationDate() != null) {
                                    props.put(DCMetaData.DATE, docInfo.getCreationDate());
                                }
                            }
                            catch (Exception e) {
                                log.warn((Object)("getCreationDate failed: " + e));
                            }
                            try {
                                if (docInfo.getCreator() != null) {
                                    props.put(DCMetaData.CREATOR, docInfo.getCreator());
                                }
                            }
                            catch (Exception e) {
                                log.warn((Object)("getCreator failed: " + e));
                            }
                            try {
                                if (docInfo.getKeywords() != null) {
                                    props.put(DCMetaData.SUBJECT, docInfo.getKeywords());
                                }
                            }
                            catch (Exception e) {
                                log.warn((Object)("getKeywords failed: " + e));
                            }
                            try {
                                if (docInfo.getModificationDate() != null) {
                                    props.put(DCMetaData.DATE, docInfo.getModificationDate());
                                }
                            }
                            catch (Exception e) {
                                log.warn((Object)("getModificationDate failed: " + e));
                            }
                            try {
                                if (docInfo.getProducer() != null) {
                                    props.put(DCMetaData.PUBLISHER, docInfo.getProducer());
                                }
                            }
                            catch (Exception e) {
                                log.warn((Object)("getProducer failed: " + e));
                            }
                            try {
                                if (docInfo.getSubject() != null) {
                                    props.put(DCMetaData.DESCRIPTION, docInfo.getSubject());
                                }
                            }
                            catch (Exception e) {
                                log.warn((Object)("getSubject failed: " + e));
                            }
                            try {
                                if (docInfo.getTitle() != null) {
                                    props.put(DCMetaData.TITLE, docInfo.getTitle());
                                }
                            }
                            catch (Exception e) {
                                log.warn((Object)("getTitle failed: " + e));
                            }
                        }
                        finally {
                            if (pdDocument != null) {
                                pdDocument.close();
                            }
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    return props;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

