/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.macs.CBCBlockCipherMac;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.params.CCMParameters;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class CCMBlockCipher {
    private BlockCipher cipher = null;
    private int blockSize;
    private boolean forEncryption;
    private CCMParameters params;
    private byte[] macBlock;

    public CCMBlockCipher(BlockCipher blockCipher) {
        this.cipher = blockCipher;
        this.blockSize = blockCipher.getBlockSize();
        this.macBlock = new byte[this.blockSize];
        if (this.blockSize != 16) {
            throw new IllegalArgumentException("cipher required with a block size of 16.");
        }
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof CCMParameters)) {
            throw new IllegalArgumentException("parameters need to be CCMParameters");
        }
        this.forEncryption = bl;
        this.params = (CCMParameters)cipherParameters;
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/CCM";
    }

    public byte[] getMac() {
        byte[] byArray = new byte[this.params.getMacSize() / 8];
        System.arraycopy(this.macBlock, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public byte[] processPacket(byte[] byArray, int n, int n2) throws IllegalStateException, InvalidCipherTextException {
        byte[] byArray2;
        if (this.params == null) {
            throw new IllegalStateException("CCM cipher unitialized.");
        }
        SICBlockCipher sICBlockCipher = new SICBlockCipher(this.cipher);
        byte[] byArray3 = new byte[this.blockSize];
        byte[] byArray4 = this.params.getNonce();
        int n3 = this.params.getMacSize() / 8;
        byArray3[0] = (byte)(15 - byArray4.length - 1 & 7);
        System.arraycopy(byArray4, 0, byArray3, 1, byArray4.length);
        sICBlockCipher.init(this.forEncryption, new ParametersWithIV(this.params.getKey(), byArray3));
        if (this.forEncryption) {
            int n4;
            int n5 = 0;
            byArray2 = new byte[n2 + n3];
            this.calculateMac(byArray, n, n2, this.macBlock);
            sICBlockCipher.processBlock(this.macBlock, 0, this.macBlock, 0);
            for (n4 = n; n4 < n2 - this.blockSize; n4 += this.blockSize) {
                sICBlockCipher.processBlock(byArray, n4, byArray2, n5);
                n5 += this.blockSize;
            }
            byte[] byArray5 = new byte[this.blockSize];
            System.arraycopy(byArray, n4, byArray5, 0, n2 - n4);
            sICBlockCipher.processBlock(byArray5, 0, byArray5, 0);
            System.arraycopy(byArray5, 0, byArray2, n5, n2 - n4);
            System.arraycopy(this.macBlock, 0, byArray2, n5 += n2 - n4, byArray2.length - n5);
        } else {
            int n6 = n;
            int n7 = 0;
            byArray2 = new byte[n2 - n3];
            System.arraycopy(byArray, n + n2 - n3, this.macBlock, 0, n3);
            sICBlockCipher.processBlock(this.macBlock, 0, this.macBlock, 0);
            for (int i = n3; i != this.macBlock.length; ++i) {
                this.macBlock[i] = 0;
            }
            while (n7 < byArray2.length - this.blockSize) {
                sICBlockCipher.processBlock(byArray, n6, byArray2, n7);
                n7 += this.blockSize;
                n6 += this.blockSize;
            }
            byte[] byArray6 = new byte[this.blockSize];
            System.arraycopy(byArray, n6, byArray6, 0, byArray2.length - n7);
            sICBlockCipher.processBlock(byArray6, 0, byArray6, 0);
            System.arraycopy(byArray6, 0, byArray2, n7, byArray2.length - n7);
            byte[] byArray7 = new byte[this.blockSize];
            this.calculateMac(byArray2, 0, byArray2.length, byArray7);
            if (!this.areEqual(this.macBlock, byArray7)) {
                throw new InvalidCipherTextException("mac check in CCM failed");
            }
        }
        return byArray2;
    }

    private int calculateMac(byte[] byArray, int n, int n2, byte[] byArray2) {
        CBCBlockCipherMac cBCBlockCipherMac = new CBCBlockCipherMac(this.cipher, this.params.getMacSize());
        byte[] byArray3 = this.params.getNonce();
        byte[] byArray4 = this.params.getAssociatedText();
        cBCBlockCipherMac.init(this.params.getKey());
        byte[] byArray5 = new byte[16];
        if (byArray4 != null && byArray4.length != 0) {
            byArray5[0] = (byte)(byArray5[0] | 0x40);
        }
        byArray5[0] = (byte)(byArray5[0] | ((cBCBlockCipherMac.getMacSize() - 2) / 2 & 7) << 3);
        byArray5[0] = (byte)(byArray5[0] | 15 - byArray3.length - 1 & 7);
        System.arraycopy(byArray3, 0, byArray5, 1, byArray3.length);
        int n3 = n2;
        int n4 = 1;
        while (n3 > 0) {
            byArray5[byArray5.length - n4] = (byte)(n3 & 0xFF);
            n3 >>>= 8;
            ++n4;
        }
        cBCBlockCipherMac.update(byArray5, 0, byArray5.length);
        if (byArray4 != null) {
            int n5;
            if (byArray4.length < 65280) {
                cBCBlockCipherMac.update((byte)(byArray4.length >> 8));
                cBCBlockCipherMac.update((byte)byArray4.length);
                n5 = 2;
            } else {
                cBCBlockCipherMac.update((byte)-1);
                cBCBlockCipherMac.update((byte)-2);
                cBCBlockCipherMac.update((byte)(byArray4.length >> 24));
                cBCBlockCipherMac.update((byte)(byArray4.length >> 16));
                cBCBlockCipherMac.update((byte)(byArray4.length >> 8));
                cBCBlockCipherMac.update((byte)byArray4.length);
                n5 = 6;
            }
            cBCBlockCipherMac.update(byArray4, 0, byArray4.length);
            n5 = (n5 + byArray4.length) % 16;
            if (n5 != 0) {
                for (int i = 0; i != 16 - n5; ++i) {
                    cBCBlockCipherMac.update((byte)0);
                }
            }
        }
        cBCBlockCipherMac.update(byArray, n, n2);
        return cBCBlockCipherMac.doFinal(byArray2, 0);
    }

    private boolean areEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i != byArray2.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }
}

